/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.A_CmsWorkplaceAction;
import org.opencms.ui.apps.CmsQuickLaunchLocationCache;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.explorer.menu.CmsMenuItemVisibilityMode;

public final class CmsClassicWorkplaceAction
extends A_CmsWorkplaceAction {
    public static final String WORKPLACE_WINDOW_NAME = "workplaceClassic";

    @Override
    public void executeAction(I_CmsDialogContext context) {
        CmsObject cms = context.getCms();
        String initPath = CmsQuickLaunchLocationCache.getLocationCache(A_CmsUI.get().getHttpSession()).getFileExplorerLocation(cms.getRequestContext().getSiteRoot());
        initPath = CmsStringUtil.isNotEmptyOrWhitespaceOnly(initPath) ? cms.getRequestContext().addSiteRoot(initPath) : CmsFileUtil.addTrailingSeparator(cms.getRequestContext().getSiteRoot());
        String link = CmsWorkplace.getWorkplaceExplorerLink(cms, initPath);
        A_CmsUI.get().openPageOrWarn(link, WORKPLACE_WINDOW_NAME);
    }

    @Override
    public String getId() {
        return "oldworkplace";
    }

    @Override
    public String getTitle() {
        return CmsVaadinUtils.getMessageText("GUI_EXPLORER_CONTEXT_OLD_WORKPLACE_0", new Object[0]);
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        boolean visible = (resources == null || resources.isEmpty()) && cms.existsResource("/system/workplace/views/workplace.jsp");
        return visible ? CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE : CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
    }
}

