/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.A_CmsWorkplaceAction;
import org.opencms.ui.contextmenu.CmsStandardVisibilityCheck;
import org.opencms.ui.contextmenu.I_CmsHasMenuItemVisibility;
import org.opencms.ui.dialogs.CmsCopyMoveDialog;
import org.opencms.workplace.explorer.menu.CmsMenuItemVisibilityMode;

public class CmsCopyDialogAction
extends A_CmsWorkplaceAction {
    private static final Log LOG = CmsLog.getLog(CmsCopyDialogAction.class);
    public static final String ACTION_ID = "copy";
    public static final I_CmsHasMenuItemVisibility VISIBILITY = CmsStandardVisibilityCheck.DEFAULT;

    @Override
    public void executeAction(I_CmsDialogContext context) {
        if (!this.hasBlockingLocks(context)) {
            CmsCopyMoveDialog dialog = new CmsCopyMoveDialog(context, CmsCopyMoveDialog.DialogMode.copy);
            if (!context.getResources().isEmpty()) {
                CmsResource res = context.getResources().get(0);
                try {
                    CmsResource parent = context.getCms().readParentFolder(res.getStructureId());
                    dialog.setTargetForlder(parent);
                }
                catch (CmsException e) {
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            this.openDialog(dialog, context);
        }
    }

    @Override
    public String getDialogTitle() {
        return this.getWorkplaceMessage("GUI_DIALOGTITLE_COPY_0");
    }

    @Override
    public String getId() {
        return ACTION_ID;
    }

    @Override
    public String getTitle() {
        return this.getWorkplaceMessage("GUI_DIALOGTITLE_COPY_0");
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        return VISIBILITY.getVisibility(cms, resources);
    }
}

