/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import com.google.common.collect.Lists;
import com.vaadin.ui.UI;
import java.util.ArrayList;
import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.I_CmsUpdateListener;
import org.opencms.ui.actions.A_CmsWorkplaceAction;
import org.opencms.ui.components.extensions.CmsGwtDialogExtension;
import org.opencms.ui.contextmenu.CmsStandardVisibilityCheck;
import org.opencms.ui.contextmenu.I_CmsHasMenuItemVisibility;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.explorer.menu.CmsMenuItemVisibilityMode;

public class CmsDirectPublishDialogAction
extends A_CmsWorkplaceAction {
    public static final String ACTION_ID = "directpublish";
    public static final I_CmsHasMenuItemVisibility VISIBILITY = CmsStandardVisibilityCheck.PUBLISH;

    @Override
    public void executeAction(final I_CmsDialogContext context) {
        if (!this.hasBlockingLocks(context)) {
            CmsGwtDialogExtension extension = new CmsGwtDialogExtension(UI.getCurrent(), new I_CmsUpdateListener<String>(){

                @Override
                public void onUpdate(List<String> updatedItems) {
                    ArrayList updatedIds = Lists.newArrayList();
                    for (String item : updatedItems) {
                        updatedIds.add(new CmsUUID(item));
                    }
                    context.finish(updatedIds);
                }
            });
            extension.openPublishDialog(context.getResources());
        }
    }

    @Override
    public String getId() {
        return ACTION_ID;
    }

    @Override
    public String getTitle() {
        return this.getWorkplaceMessage("GUI_EXPLORER_CONTEXT_PUBLISH_0");
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        return VISIBILITY.getVisibility(cms, resources);
    }
}

