/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.jsp.CmsJspTagEnableAde;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.A_CmsWorkplaceAction;
import org.opencms.ui.actions.I_CmsDefaultAction;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilitySingleOnly;
import org.opencms.ui.contextmenu.CmsStandardVisibilityCheck;
import org.opencms.ui.contextmenu.I_CmsHasMenuItemVisibility;
import org.opencms.workplace.explorer.menu.CmsMenuItemVisibilityMode;

public class CmsDisplayAction
extends A_CmsWorkplaceAction
implements I_CmsDefaultAction {
    public static final String ONLINE_WINDOW_NAME = "opencmsOnline";
    public static final String ACTION_ID = "display";
    public static final I_CmsHasMenuItemVisibility VISIBILITY = new CmsMenuItemVisibilitySingleOnly(CmsStandardVisibilityCheck.EDIT);

    @Override
    public void executeAction(I_CmsDialogContext context) {
        if (context.getResources().size() == 1) {
            HttpServletRequest req = CmsVaadinUtils.getRequest();
            CmsJspTagEnableAde.removeDirectEditFlagFromSession(req.getSession());
            if (context.getCms().getRequestContext().getCurrentProject().isOnlineProject()) {
                String link = OpenCms.getLinkManager().getOnlineLink(context.getCms(), context.getCms().getSitePath(context.getResources().get(0)));
                A_CmsUI.get().openPageOrWarn(link, ONLINE_WINDOW_NAME);
            } else {
                String link = OpenCms.getLinkManager().substituteLink(context.getCms(), context.getResources().get(0));
                A_CmsUI.get().getPage().setLocation(link);
            }
        }
    }

    @Override
    public int getDefaultActionRank(I_CmsDialogContext context) {
        return 10;
    }

    @Override
    public String getId() {
        return ACTION_ID;
    }

    @Override
    public String getTitle() {
        return this.getWorkplaceMessage("GUI_ACTION_DISPLAY_0");
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        if (resources.size() == 1 && resources.get(0).isFile() && !CmsResourceTypeXmlContainerPage.isContainerPage(resources.get(0))) {
            return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
        }
        return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
    }
}

