/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.I_CmsUpdateListener;
import org.opencms.ui.actions.A_CmsWorkplaceAction;
import org.opencms.ui.components.extensions.CmsGwtDialogExtension;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilitySingleOnly;
import org.opencms.ui.contextmenu.CmsStandardVisibilityCheck;
import org.opencms.ui.contextmenu.I_CmsHasMenuItemVisibility;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.explorer.menu.CmsMenuItemVisibilityMode;

public final class CmsResourceInfoAction
extends A_CmsWorkplaceAction {
    private I_CmsHasMenuItemVisibility m_visibility = new CmsMenuItemVisibilitySingleOnly(CmsStandardVisibilityCheck.VISIBLE);

    @Override
    public void executeAction(final I_CmsDialogContext context) {
        CmsGwtDialogExtension extension = new CmsGwtDialogExtension(A_CmsUI.get(), new I_CmsUpdateListener<String>(){

            @Override
            public void onUpdate(List<String> updatedItems) {
                ArrayList ids = Lists.newArrayList();
                for (String item : updatedItems) {
                    ids.add(new CmsUUID(item));
                }
                context.finish(ids);
            }
        });
        extension.openInfoDialog(context.getResources().get(0));
    }

    @Override
    public String getId() {
        return "resourceinfo";
    }

    @Override
    public String getTitle() {
        return CmsVaadinUtils.getMessageText("GUI_RESOURCE_INFO_0", new Object[0]);
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        return this.m_visibility.getVisibility(cms, resources);
    }
}

