/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.A_CmsWorkplaceAction;
import org.opencms.ui.contextmenu.CmsStandardVisibilityCheck;
import org.opencms.workplace.explorer.menu.CmsMenuItemVisibilityMode;

public class CmsUnlockAction
extends A_CmsWorkplaceAction {
    private static final Log LOG = CmsLog.getLog(CmsUnlockAction.class);

    @Override
    public void executeAction(I_CmsDialogContext context) {
        CmsObject cms = A_CmsUI.getCmsObject();
        ArrayList changedIds = Lists.newArrayList();
        for (CmsResource res : context.getResources()) {
            try {
                cms.unlockResource(res);
                changedIds.add(res.getStructureId());
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            context.finish(changedIds);
        }
    }

    @Override
    public String getId() {
        return "unlock";
    }

    @Override
    public String getTitle() {
        return CmsVaadinUtils.getMessageText("GUI_EXPLORER_CONTEXT_UNLOCK_0", new Object[0]);
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        return CmsStandardVisibilityCheck.UNLOCK.getVisibility(cms, resources);
    }
}

