/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.opencms.ui.apps.CmsAppCategory;
import org.opencms.ui.apps.I_CmsAppCategory;
import org.opencms.ui.apps.I_CmsWorkplaceAppConfiguration;

public class CmsAppCategoryNode {
    private I_CmsAppCategory m_data;
    private List<CmsAppCategoryNode> m_children = Lists.newArrayList();
    private List<I_CmsWorkplaceAppConfiguration> m_appConfigurations = Lists.newArrayList();
    private int m_appCount;

    public CmsAppCategoryNode() {
        this.m_data = new CmsAppCategory(null, null, 0, 0);
    }

    public CmsAppCategoryNode(I_CmsAppCategory appCategory) {
        this.m_data = appCategory;
    }

    public void addAppConfiguration(I_CmsWorkplaceAppConfiguration appConfig) {
        this.m_appConfigurations.add(appConfig);
    }

    public void addChild(CmsAppCategoryNode node) {
        this.m_children.add(node);
    }

    public List<I_CmsWorkplaceAppConfiguration> getAppConfigurations() {
        return this.m_appConfigurations;
    }

    public I_CmsAppCategory getCategory() {
        return this.m_data;
    }

    public List<CmsAppCategoryNode> getChildren() {
        return this.m_children;
    }

    public void removeApplessSubtrees() {
        this.internalRemoveApplessSubtrees(true);
    }

    public void sort() {
        Collections.sort(this.m_appConfigurations, new Comparator<I_CmsWorkplaceAppConfiguration>(){

            @Override
            public int compare(I_CmsWorkplaceAppConfiguration app1, I_CmsWorkplaceAppConfiguration app2) {
                return ComparisonChain.start().compare(app1.getOrder(), app2.getOrder()).result();
            }
        });
        Collections.sort(this.m_children, new Comparator<CmsAppCategoryNode>(){

            @Override
            public int compare(CmsAppCategoryNode o1, CmsAppCategoryNode o2) {
                return ComparisonChain.start().compare(o1.getCategory().getOrder(), o2.getCategory().getOrder()).result();
            }
        });
    }

    public void sortRecursively() {
        this.sort();
        for (CmsAppCategoryNode child : this.m_children) {
            child.sortRecursively();
        }
    }

    private void computeAppCount() {
        this.m_appCount = this.m_appConfigurations.size();
        for (CmsAppCategoryNode child : this.m_children) {
            child.computeAppCount();
            this.m_appCount += child.m_appCount;
        }
    }

    private void internalRemoveApplessSubtrees(boolean isRoot) {
        if (isRoot) {
            this.computeAppCount();
        }
        Iterator<CmsAppCategoryNode> iter = this.m_children.iterator();
        while (iter.hasNext()) {
            CmsAppCategoryNode child = iter.next();
            if (child.m_appCount == 0) {
                iter.remove();
                continue;
            }
            child.internalRemoveApplessSubtrees(false);
        }
    }
}

