/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps;

import com.vaadin.annotations.Theme;
import com.vaadin.navigator.NavigationStateManager;
import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.navigator.ViewDisplay;
import com.vaadin.navigator.ViewProvider;
import com.vaadin.server.ErrorHandler;
import com.vaadin.server.Page;
import com.vaadin.server.VaadinRequest;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Component;
import com.vaadin.ui.Notification;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.Buffer;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsBroadcast;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsSessionInfo;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinErrorHandler;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsAppView;
import org.opencms.ui.apps.CmsAppNavigator;
import org.opencms.ui.apps.CmsAppView;
import org.opencms.ui.apps.CmsWorkplaceAppManager;
import org.opencms.ui.apps.I_CmsWorkplaceAppConfiguration;
import org.opencms.ui.components.I_CmsWindowCloseListener;
import org.opencms.ui.components.extensions.CmsHistoryExtension;
import org.opencms.ui.components.extensions.CmsPollServerExtension;
import org.opencms.ui.components.extensions.CmsWindowCloseExtension;
import org.opencms.ui.login.CmsLoginHelper;
import org.opencms.util.CmsExpiringValue;
import org.opencms.util.CmsStringUtil;

@Theme(value="opencms")
public class CmsAppWorkplaceUi
extends A_CmsUI
implements ViewDisplay,
ViewProvider,
ViewChangeListener,
I_CmsWindowCloseListener,
Page.BrowserWindowResizeListener {
    public static final String WINDOW_TITLE_PREFIX = "OpenCms - ";
    private static final Log LOG = CmsLog.getLog(CmsAppWorkplaceUi.class);
    private static final long serialVersionUID = -5606711048683809028L;
    protected View m_launchRedirect = new LaunchpadRedirectView();
    private Map<String, I_CmsAppView> m_cachedViews;
    private View m_currentView;
    private CmsHistoryExtension m_history;
    private CmsExpiringValue<Locale> m_localeCache = new CmsExpiringValue(1000L);
    private NavigationStateManager m_navigationStateManager;
    private boolean m_refreshing;

    public CmsAppWorkplaceUi() {
        this.m_cachedViews = new HashMap<String, I_CmsAppView>();
    }

    public static CmsAppWorkplaceUi get() {
        return (CmsAppWorkplaceUi)A_CmsUI.get();
    }

    public static boolean isOnlineProject() {
        return CmsAppWorkplaceUi.getCmsObject().getRequestContext().getCurrentProject().isOnlineProject();
    }

    public static void setWindowTitle(String title) {
        CmsAppWorkplaceUi.get().getPage().setTitle(WINDOW_TITLE_PREFIX + title);
    }

    public void afterViewChange(ViewChangeListener.ViewChangeEvent event) {
        if (this.m_currentView != null && this.m_currentView instanceof ViewChangeListener) {
            ((ViewChangeListener)this.m_currentView).afterViewChange(event);
        }
    }

    public boolean beforeViewChange(ViewChangeListener.ViewChangeEvent event) {
        this.cacheView(this.m_currentView);
        if (this.m_currentView != null && this.m_currentView instanceof ViewChangeListener) {
            return ((ViewChangeListener)this.m_currentView).beforeViewChange(event);
        }
        return true;
    }

    public void browserWindowResized(Page.BrowserWindowResizeEvent event) {
        this.markAsDirtyRecursive();
        if (this.m_currentView != null && this.m_currentView instanceof Page.BrowserWindowResizeListener) {
            ((Page.BrowserWindowResizeListener)this.m_currentView).browserWindowResized(event);
        }
    }

    public void changeCurrentAppState(String state) {
        String view;
        String completeState = this.m_navigationStateManager.getState();
        String newCompleteState = view = this.getViewName(completeState);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(state)) {
            newCompleteState = newCompleteState + "/" + state;
        }
        this.m_navigationStateManager.setState(newCompleteState);
    }

    public void checkBroadcasts() {
        CmsSessionInfo info = OpenCms.getSessionManager().getSessionInfo(this.getHttpSession());
        Buffer queue = info.getBroadcastQueue();
        if (!queue.isEmpty()) {
            StringBuffer broadcasts = new StringBuffer();
            while (!queue.isEmpty()) {
                CmsBroadcast broadcastMessage = (CmsBroadcast)queue.remove();
                String from = broadcastMessage.getUser() != null ? broadcastMessage.getUser().getName() : CmsVaadinUtils.getMessageText("GUI_LABEL_BROADCAST_FROM_SYSTEM_0", new Object[0]);
                String date = CmsVaadinUtils.getWpMessagesForCurrentLocale().getDateTime(broadcastMessage.getSendTime());
                String content = broadcastMessage.getMessage();
                content = content.replaceAll("\\n", "<br />");
                broadcasts.append("<p><em>").append(date).append("</em><br />");
                broadcasts.append(CmsVaadinUtils.getMessageText("GUI_LABEL_BROADCASTMESSAGEFROM_0", new Object[0])).append(" <b>").append(from).append("</b>:</p><p>");
                broadcasts.append(content).append("<br /></p>");
            }
            Notification notification = new Notification(CmsVaadinUtils.getMessageText("GUI_BROADCAST_TITLE_0", new Object[0]), broadcasts.toString(), Notification.Type.WARNING_MESSAGE, true);
            notification.setDelayMsec(-1);
            notification.show(this.getPage());
        }
    }

    @Override
    public void closeWindows() {
        super.closeWindows();
        if (this.m_currentView instanceof CmsAppView) {
            ((CmsAppView)this.m_currentView).getComponent().closePopupViews();
        }
    }

    public void detach() {
        this.clearCachedViews();
        super.detach();
    }

    public void disableGlobalShortcuts() {
        if (this.m_currentView instanceof I_CmsAppView) {
            ((I_CmsAppView)this.m_currentView).disableGlobalShortcuts();
        }
    }

    public void enableGlobalShortcuts() {
        if (this.m_currentView instanceof I_CmsAppView) {
            ((I_CmsAppView)this.m_currentView).enableGlobalShortcuts();
        }
    }

    public String getAppState() {
        CmsWorkplaceAppManager.NavigationState state = new CmsWorkplaceAppManager.NavigationState(this.m_navigationStateManager.getState());
        return state.getParams();
    }

    public View getCurrentView() {
        return this.m_currentView;
    }

    public Locale getLocale() {
        Locale result = this.m_localeCache.get();
        if (result == null) {
            CmsObject cms = CmsAppWorkplaceUi.getCmsObject();
            result = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
            this.m_localeCache.set(result);
        }
        return result;
    }

    public View getView(String viewName) {
        I_CmsWorkplaceAppConfiguration appConfig;
        View view;
        if (this.m_cachedViews.containsKey(viewName) && (view = (View)this.m_cachedViews.get(viewName)) instanceof CmsAppView) {
            CmsAppView appView = (CmsAppView)view;
            if (appView.getCacheStatus() == CmsAppView.CacheStatus.cache) {
                appView.setRequiresRestore(true);
                return appView;
            }
            if (appView.getCacheStatus() == CmsAppView.CacheStatus.cacheOnce) {
                appView.setCacheStatus(CmsAppView.CacheStatus.noCache);
                appView.setRequiresRestore(true);
                return appView;
            }
        }
        if ((appConfig = OpenCms.getWorkplaceAppManager().getAppConfiguration(viewName)) != null) {
            return new CmsAppView(appConfig);
        }
        LOG.warn((Object)("Nonexistant view '" + viewName + "' requested"));
        return this.m_launchRedirect;
    }

    public String getViewName(String viewAndParameters) {
        CmsWorkplaceAppManager.NavigationState state = new CmsWorkplaceAppManager.NavigationState(viewAndParameters);
        return state.getViewName();
    }

    public void historyBack() {
        this.m_history.historyBack();
    }

    public void historyForward() {
        this.m_history.historyForward();
    }

    public void onError() {
    }

    @Override
    public void onWindowClose() {
        if (this.m_currentView != null && this.m_currentView instanceof I_CmsWindowCloseListener) {
            ((I_CmsWindowCloseListener)this.m_currentView).onWindowClose();
        }
        this.cacheView(this.m_currentView);
    }

    @Override
    public void reload() {
        if (this.m_currentView instanceof I_CmsAppView) {
            Component component = ((I_CmsAppView)this.m_currentView).reinitComponent();
            this.setContent(component);
            ((I_CmsAppView)this.m_currentView).enter(this.getAppState());
        }
    }

    public void setLastHeartbeatTimestamp(long lastHeartbeat) {
        super.setLastHeartbeatTimestamp(lastHeartbeat);
        this.checkBroadcasts();
    }

    public void showApp(I_CmsWorkplaceAppConfiguration appConfig) {
        this.getNavigator().navigateTo(appConfig.getId());
    }

    public void showApp(I_CmsWorkplaceAppConfiguration appConfig, String state) {
        this.getNavigator().navigateTo(appConfig.getId() + "/" + state);
    }

    public void showHome() {
        this.getNavigator().navigateTo("launchpad");
    }

    public void showView(View view) {
        this.closeWindows();
        this.m_currentView = view;
        Component component = null;
        if (view instanceof I_CmsAppView) {
            if (((I_CmsAppView)view).requiresRestore()) {
                ((I_CmsAppView)view).restoreFromCache();
            }
            component = ((I_CmsAppView)view).getComponent();
        } else if (view instanceof Component) {
            component = (Component)view;
        }
        this.initializeClientPolling(component);
        if (component != null) {
            this.setContent(component);
        }
    }

    @Override
    protected void init(VaadinRequest req) {
        super.init(req);
        if (!OpenCms.getRoleManager().hasRole(CmsAppWorkplaceUi.getCmsObject(), CmsRole.EDITOR)) {
            Notification.show((String)CmsVaadinUtils.getMessageText("GUI_WORKPLACE_ACCESS_DENIED_TITLE_0", new Object[0]), (String)CmsVaadinUtils.getMessageText("GUI_WORKPLACE_ACCESS_DENIED_MESSAGE_0", new Object[0]), (Notification.Type)Notification.Type.ERROR_MESSAGE);
            return;
        }
        this.getSession().setErrorHandler((ErrorHandler)new CmsVaadinErrorHandler(this));
        this.m_navigationStateManager = new Navigator.UriFragmentManager(this.getPage());
        CmsAppNavigator navigator = new CmsAppNavigator(this, this.m_navigationStateManager, this);
        navigator.addProvider(this);
        this.setNavigator(navigator);
        Page.getCurrent().addBrowserWindowResizeListener((Page.BrowserWindowResizeListener)this);
        this.m_history = new CmsHistoryExtension(CmsAppWorkplaceUi.getCurrent());
        CmsWindowCloseExtension windowClose = new CmsWindowCloseExtension(CmsAppWorkplaceUi.getCurrent());
        windowClose.addWindowCloseListener(this);
        navigator.addViewChangeListener(this);
        this.navigateToFragment();
        this.getReconnectDialogConfiguration().setDialogText(CmsVaadinUtils.getMessageText("GUI_SYSTEM_CONNECTION_LOST_TRYING_RECONNECT_0", new Object[0]));
        this.getReconnectDialogConfiguration().setDialogTextGaveUp(CmsVaadinUtils.getMessageText("GUI_SYSTEM_CONNECTION_LOST_GIVING_UP_0", new Object[0]));
    }

    private void cacheView(View view) {
        if (!this.m_refreshing && view instanceof I_CmsAppView && ((I_CmsAppView)view).isCachable()) {
            this.m_cachedViews.put(((I_CmsAppView)view).getName(), (I_CmsAppView)view);
        }
    }

    private void clearCachedViews() {
        this.m_cachedViews.clear();
    }

    private void initializeClientPolling(Component component) {
        if (component instanceof AbstractComponent) {
            new CmsPollServerExtension((AbstractComponent)component);
        }
    }

    private void navigateToFragment() {
        String fragment = this.getPage().getUriFragment();
        if (fragment != null) {
            this.getNavigator().navigateTo(fragment);
        } else {
            CmsObject cms = CmsAppWorkplaceUi.getCmsObject();
            String target = CmsLoginHelper.getStartView(cms);
            if (target != null) {
                if (target.startsWith("#")) {
                    this.getNavigator().navigateTo(target.substring(1));
                } else {
                    Page.getCurrent().setLocation(OpenCms.getLinkManager().substituteLink(cms, target));
                }
            } else {
                this.showHome();
            }
        }
    }

    class LaunchpadRedirectView
    implements View {
        private static final long serialVersionUID = 1L;

        LaunchpadRedirectView() {
        }

        public void enter(ViewChangeListener.ViewChangeEvent event) {
            A_CmsUI.get().getNavigator().navigateTo("launchpad");
        }
    }
}

