/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps;

import com.vaadin.event.Action;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.Page;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.I_CmsAppUIContext;
import org.opencms.ui.apps.I_CmsHasShortcutActions;
import org.opencms.ui.apps.I_CmsWorkplaceApp;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.I_CmsWindowCloseListener;
import org.opencms.ui.editors.I_CmsEditor;
import org.opencms.util.CmsUUID;

public class CmsEditor
implements I_CmsWorkplaceApp,
ViewChangeListener,
I_CmsWindowCloseListener,
I_CmsHasShortcutActions {
    private static final long serialVersionUID = 7503052469189004387L;
    private static final Log LOG = CmsLog.getLog(CmsEditor.class);
    public static final String RESOURCE_ID_PREFIX = "resourceId:";
    public static final String RESOURCE_PATH_PREFIX = "resourcePath:";
    public static final String BACK_LINK_PREFIX = "backLink:";
    public static final String PLAIN_TEXT_PREFIX = "plainText:";
    public static final String STATE_SEPARATOR = ";;";
    private static final int UUID_LENGTH = CmsUUID.getNullUUID().toString().length();
    private I_CmsAppUIContext m_context;
    private I_CmsEditor m_editorInstance;

    public static String getEditState(CmsUUID resourceId, boolean plainText, String backLink) {
        try {
            backLink = URLEncoder.encode(backLink, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        String state = RESOURCE_ID_PREFIX + resourceId.toString() + STATE_SEPARATOR + PLAIN_TEXT_PREFIX + plainText + STATE_SEPARATOR + BACK_LINK_PREFIX + backLink;
        return state;
    }

    public static void openBackLink(String backlink) {
        try {
            backlink = URLDecoder.decode(backlink, "UTF-8");
            String current = Page.getCurrent().getLocation().toString();
            if (current.contains("#")) {
                current = current.substring(0, current.indexOf("#"));
            }
            if (backlink.startsWith(current)) {
                String target = backlink.substring(backlink.indexOf("#") + 1);
                CmsAppWorkplaceUi.get().getNavigator().navigateTo(target);
            } else {
                Page.getCurrent().setLocation(backlink);
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void afterViewChange(ViewChangeListener.ViewChangeEvent event) {
        if (this.m_editorInstance instanceof ViewChangeListener) {
            ((ViewChangeListener)this.m_editorInstance).afterViewChange(event);
        }
    }

    public boolean beforeViewChange(ViewChangeListener.ViewChangeEvent event) {
        if (this.m_editorInstance instanceof ViewChangeListener) {
            return ((ViewChangeListener)this.m_editorInstance).beforeViewChange(event);
        }
        return true;
    }

    @Override
    public Map<Action, Runnable> getShortcutActions() {
        if (this.m_editorInstance instanceof I_CmsHasShortcutActions) {
            return ((I_CmsHasShortcutActions)((Object)this.m_editorInstance)).getShortcutActions();
        }
        return Collections.EMPTY_MAP;
    }

    @Override
    public void initUI(I_CmsAppUIContext context) {
        this.m_context = context;
    }

    @Override
    public void onStateChange(String state) {
        CmsUUID resId = this.getResourceIdFromState(state);
        String path = null;
        if (resId == null) {
            path = this.getResourcePathFromState(state);
        }
        CmsObject cms = A_CmsUI.getCmsObject();
        final String backlink = this.getBackLinkFromState(state);
        try {
            CmsResource resource = resId != null ? cms.readResource(resId, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED) : cms.readResource(path, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
            OpenCms.getRoleManager().checkRoleForResource(cms, CmsRole.ELEMENT_AUTHOR, cms.getSitePath(resource));
            I_CmsEditor editor = OpenCms.getWorkplaceAppManager().getEditorForResource(resource, this.isPlainText(state));
            if (editor != null) {
                this.m_editorInstance = editor.newInstance();
                this.m_editorInstance.initUI(this.m_context, resource, backlink);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error initializing the editor.", (Throwable)e);
            CmsErrorDialog.showErrorDialog(e, new Runnable(){

                @Override
                public void run() {
                    CmsEditor.openBackLink(backlink);
                }
            });
        }
    }

    @Override
    public void onWindowClose() {
        if (this.m_editorInstance instanceof I_CmsWindowCloseListener) {
            ((I_CmsWindowCloseListener)((Object)this.m_editorInstance)).onWindowClose();
        }
    }

    private String getBackLinkFromState(String state) {
        String result = null;
        int index = state.indexOf(BACK_LINK_PREFIX);
        if (index >= 0 && (index = (result = state.substring(index + BACK_LINK_PREFIX.length())).indexOf(STATE_SEPARATOR)) > 0) {
            result = result.substring(0, index);
        }
        return result;
    }

    private CmsUUID getResourceIdFromState(String state) {
        String id;
        CmsUUID result = null;
        int index = state.indexOf(RESOURCE_ID_PREFIX);
        if (index >= 0 && CmsUUID.isValidUUID(id = state.substring(index + RESOURCE_ID_PREFIX.length(), index + RESOURCE_ID_PREFIX.length() + UUID_LENGTH))) {
            result = new CmsUUID(id);
        }
        return result;
    }

    private String getResourcePathFromState(String state) {
        String result = null;
        int index = state.indexOf(RESOURCE_PATH_PREFIX);
        if (index >= 0 && (index = (result = state.substring(index + RESOURCE_PATH_PREFIX.length())).indexOf(STATE_SEPARATOR)) > 0) {
            result = result.substring(0, index);
        }
        return result;
    }

    private boolean isPlainText(String state) {
        return state.indexOf(PLAIN_TEXT_PREFIX + Boolean.TRUE.toString()) >= 0;
    }
}

