/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps;

import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import java.util.Locale;
import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.ui.apps.CmsAppVisibilityStatus;
import org.opencms.ui.apps.CmsLegacyApp;
import org.opencms.ui.apps.I_CmsWorkplaceApp;
import org.opencms.ui.apps.I_CmsWorkplaceAppConfiguration;
import org.opencms.util.CmsMacroResolver;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.tools.I_CmsToolHandler;

public class CmsLegacyAppConfiguration
implements I_CmsWorkplaceAppConfiguration {
    private I_CmsToolHandler m_toolHandler;

    public CmsLegacyAppConfiguration(I_CmsToolHandler toolHandler) {
        this.m_toolHandler = toolHandler;
    }

    @Override
    public String getAppCategory() {
        return "Legacy";
    }

    @Override
    public I_CmsWorkplaceApp getAppInstance() {
        return new CmsLegacyApp(this.m_toolHandler);
    }

    @Override
    public String getButtonStyle() {
        return "";
    }

    @Override
    public String getHelpText(Locale locale) {
        return CmsMacroResolver.newInstance().setMessages(OpenCms.getWorkplaceManager().getMessages(locale)).resolveMacros(this.m_toolHandler.getHelpText());
    }

    @Override
    public Resource getIcon() {
        return new ExternalResource(CmsWorkplace.getSkinUri() + this.m_toolHandler.getIconPath());
    }

    @Override
    public String getId() {
        return this.m_toolHandler.getPath();
    }

    @Override
    public String getName(Locale locale) {
        return CmsMacroResolver.newInstance().setMessages(OpenCms.getWorkplaceManager().getMessages(locale)).resolveMacros(this.m_toolHandler.getName());
    }

    @Override
    public int getOrder() {
        return 10 + Math.round(this.m_toolHandler.getPosition());
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public CmsAppVisibilityStatus getVisibility(CmsObject cms) {
        boolean visible = cms.existsResource(this.m_toolHandler.getLink()) && this.m_toolHandler.isVisible(cms);
        return new CmsAppVisibilityStatus(visible, this.m_toolHandler.isEnabled(cms), "");
    }
}

