/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps;

import com.vaadin.event.Transferable;
import com.vaadin.event.dd.DragAndDropEvent;
import com.vaadin.event.dd.DropHandler;
import com.vaadin.event.dd.acceptcriteria.AcceptAll;
import com.vaadin.event.dd.acceptcriteria.AcceptCriterion;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.DragAndDropWrapper;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.CmsAppVisibilityStatus;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.CmsDefaultAppButtonProvider;
import org.opencms.ui.apps.I_CmsWorkplaceAppConfiguration;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.CmsWrappedHorizontalLayout;

public class CmsQuickLaunchEditor
extends VerticalLayout {
    private static final long serialVersionUID = -6608352673763873030L;
    private CmsWrappedHorizontalLayout m_availableApps;
    private Button m_cancel;
    private Button m_save;
    private HorizontalLayout m_standardApps;
    private CmsWrappedHorizontalLayout m_userApps;

    public CmsQuickLaunchEditor() {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_userApps.setDropHandler(new ReorderLayoutDropHandler((AbstractOrderedLayout)this.m_userApps.getWrappedLayout(), false));
        this.m_userApps.getWrappedLayout().setMargin(true);
        this.m_userApps.getWrappedLayout().addStyleName("wrapping");
        this.m_availableApps.setDropHandler(new ReorderLayoutDropHandler((AbstractOrderedLayout)this.m_availableApps.getWrappedLayout(), false));
        this.m_availableApps.getWrappedLayout().setMargin(true);
        this.m_availableApps.getWrappedLayout().addStyleName("wrapping");
        this.m_save.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsQuickLaunchEditor.this.saveToUser();
            }
        });
        this.m_cancel.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsQuickLaunchEditor.this.close();
            }
        });
    }

    protected void initAppIcons() {
        Button button;
        CmsAppVisibilityStatus visibility;
        CmsObject cms = A_CmsUI.getCmsObject();
        Locale locale = UI.getCurrent().getLocale();
        Collection<I_CmsWorkplaceAppConfiguration> allApps = OpenCms.getWorkplaceAppManager().getWorkplaceApps();
        List<I_CmsWorkplaceAppConfiguration> standardApps = OpenCms.getWorkplaceAppManager().getDefaultQuickLaunchConfigurations();
        List<I_CmsWorkplaceAppConfiguration> userApps = OpenCms.getWorkplaceAppManager().getUserQuickLauchConfigurations(cms);
        for (I_CmsWorkplaceAppConfiguration config : standardApps) {
            visibility = config.getVisibility(cms);
            if (!visibility.isVisible() || !visibility.isActive()) continue;
            button = CmsDefaultAppButtonProvider.createAppIconButton(config, locale);
            this.m_standardApps.addComponent((Component)button);
        }
        for (I_CmsWorkplaceAppConfiguration config : userApps) {
            visibility = config.getVisibility(cms);
            if (!visibility.isVisible() || !visibility.isActive()) continue;
            button = CmsDefaultAppButtonProvider.createAppIconButton(config, locale);
            this.m_userApps.getWrappedLayout().addComponent((Component)new WrappedDraggableComponent((Component)button, config.getId()));
        }
        for (I_CmsWorkplaceAppConfiguration config : allApps) {
            visibility = config.getVisibility(cms);
            if (standardApps.contains(config) || userApps.contains(config) || !visibility.isVisible() || !visibility.isActive()) continue;
            button = CmsDefaultAppButtonProvider.createAppIconButton(config, locale);
            this.m_availableApps.getWrappedLayout().addComponent((Component)new WrappedDraggableComponent((Component)button, config.getId()));
        }
    }

    void close() {
        CmsAppWorkplaceUi.get().getNavigator().navigateTo("launchpad");
    }

    void saveToUser() {
        ArrayList<String> apps = new ArrayList<String>();
        HorizontalLayout appsLayout = this.m_userApps.getWrappedLayout();
        int count = appsLayout.getComponentCount();
        for (int i = 0; i < count; ++i) {
            WrappedDraggableComponent wrapper = (WrappedDraggableComponent)appsLayout.getComponent(i);
            apps.add(wrapper.getItemId());
        }
        try {
            OpenCms.getWorkplaceAppManager().setUserQuickLaunchApps(A_CmsUI.getCmsObject(), apps);
        }
        catch (CmsException e) {
            CmsErrorDialog.showErrorDialog("Could not write user Quicklaunch apps", e);
        }
        this.close();
    }

    private static class WrappedDraggableComponent
    extends DragAndDropWrapper {
        private static final long serialVersionUID = 5204771630321411021L;
        private String m_id;

        public WrappedDraggableComponent(Component content, String id) {
            super(content);
            this.m_id = id;
            this.setDragStartMode(DragAndDropWrapper.DragStartMode.WRAPPER);
            this.setWidth("166px");
        }

        public String getItemId() {
            return this.m_id;
        }
    }

    private static class ReorderLayoutDropHandler
    implements DropHandler {
        private static final int ITEM_HEIGHT = 88;
        private static final int ITEM_WIDTH = 176;
        private static final int LAYOUT_WIDTH = 1158;
        private static final long serialVersionUID = 7598829826841275823L;
        private AbstractOrderedLayout m_layout;
        private boolean m_verticalOnly;

        public ReorderLayoutDropHandler(AbstractOrderedLayout layout, boolean verticalOnly) {
            this.m_layout = layout;
            this.m_verticalOnly = verticalOnly;
        }

        public void drop(DragAndDropEvent dropEvent) {
            int currentIndex;
            int index;
            DragAndDropWrapper.WrapperTargetDetails targetDetails = (DragAndDropWrapper.WrapperTargetDetails)dropEvent.getTargetDetails();
            Transferable transferable = dropEvent.getTransferable();
            Component sourceComponent = transferable.getSourceComponent();
            int top = targetDetails.getMouseEvent().getClientY() - targetDetails.getAbsoluteTop();
            if (this.m_verticalOnly) {
                index = top / 88;
                if (index * 88 + 44 < top) {
                    ++index;
                }
            } else {
                int columnCount = 6;
                int left = targetDetails.getMouseEvent().getClientX() - targetDetails.getAbsoluteLeft();
                int column = left / 176;
                int row = top / 88;
                index = row * columnCount + column;
                if (column * 176 + 88 < left) {
                    ++index;
                }
            }
            if ((currentIndex = this.m_layout.getComponentIndex(sourceComponent)) != -1 && currentIndex < index) {
                --index;
            }
            if (currentIndex == index) {
                return;
            }
            this.m_layout.removeComponent(sourceComponent);
            if (this.m_layout.getComponentCount() < index) {
                index = this.m_layout.getComponentCount();
            }
            this.m_layout.addComponent(sourceComponent, index);
        }

        public AcceptCriterion getAcceptCriterion() {
            return AcceptAll.get();
        }
    }
}

