/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps;

import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.ui.Notification;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.A_CmsWorkplaceAppConfiguration;
import org.opencms.ui.apps.CmsAppVisibilityStatus;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.CmsQuickLaunchLocationCache;
import org.opencms.ui.apps.I_CmsHasAppLaunchCommand;
import org.opencms.ui.apps.I_CmsWorkplaceApp;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.components.OpenCmsTheme;
import org.opencms.util.CmsStringUtil;

public class CmsSitemapEditorConfiguration
extends A_CmsWorkplaceAppConfiguration
implements I_CmsHasAppLaunchCommand {
    public static final String APP_ID = "sitemapeditor";
    private static final Log LOG = CmsLog.getLog(CmsSitemapEditorConfiguration.class);

    @Override
    public String getAppCategory() {
        return "Main";
    }

    @Override
    public I_CmsWorkplaceApp getAppInstance() {
        throw new IllegalStateException("The sitemap app should be launched through the app launch command only.");
    }

    @Override
    public Runnable getAppLaunchCommand() {
        return new Runnable(){

            @Override
            public void run() {
                CmsSitemapEditorConfiguration.this.openSitemapEditor();
            }
        };
    }

    @Override
    public String getButtonStyle() {
        return "o-color-transparent";
    }

    @Override
    public String getHelpText(Locale locale) {
        return Messages.get().getBundle(locale).key("GUI_SITEMAP_HELP_0");
    }

    @Override
    public Resource getIcon() {
        return new ExternalResource(OpenCmsTheme.getImageLink("apps/sitemap.png"));
    }

    @Override
    public String getId() {
        return APP_ID;
    }

    @Override
    public String getName(Locale locale) {
        return Messages.get().getBundle(locale).key("GUI_SITEMAP_TITLE_0");
    }

    @Override
    public int getOrder() {
        return 2;
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public CmsAppVisibilityStatus getVisibility(CmsObject cms) {
        if (OpenCms.getRoleManager().hasRole(cms, CmsRole.EDITOR)) {
            String siteRoot = cms.getRequestContext().getSiteRoot();
            boolean active = CmsStringUtil.isNotEmptyOrWhitespaceOnly(siteRoot);
            HttpServletRequest req = CmsVaadinUtils.getRequest();
            String message = null;
            if (active) {
                if (req != null) {
                    boolean bl = active = this.getPath(cms, req.getSession()) != null;
                    if (!active) {
                        message = CmsVaadinUtils.getMessageText("GUI_SITEMAP_COULD_NOT_BE_DETERMINED_0", new Object[0]);
                    }
                }
            } else {
                message = CmsVaadinUtils.getMessageText("GUI_SITEMAP_NOT_AVAILABLE_0", new Object[0]);
            }
            return new CmsAppVisibilityStatus(true, active, message);
        }
        return CmsAppVisibilityStatus.INVISIBLE;
    }

    void openSitemapEditor() {
        String path;
        CmsObject cms = A_CmsUI.getCmsObject();
        String siteRoot = cms.getRequestContext().getSiteRoot();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(siteRoot) && (path = this.getPath(cms, A_CmsUI.get().getHttpSession())) != null) {
            try {
                CmsAppWorkplaceUi ui = CmsAppWorkplaceUi.get();
                if (ui.beforeViewChange(new ViewChangeListener.ViewChangeEvent(ui.getNavigator(), ui.getCurrentView(), null, APP_ID, null))) {
                    CmsResource res = cms.readResource("/system/workplace/commons/sitemap.jsp");
                    String link = OpenCms.getLinkManager().substituteLink(cms, res);
                    A_CmsUI.get().getPage().setLocation(link + "?path=" + path);
                }
                return;
            }
            catch (CmsException e) {
                LOG.debug((Object)"Unable to open sitemap editor.", (Throwable)e);
            }
        }
        Notification.show((String)CmsVaadinUtils.getMessageText("GUI_SITEMAP_NOT_AVAILABLE_0", new Object[0]), (Notification.Type)Notification.Type.WARNING_MESSAGE);
    }

    private String getPath(CmsObject cms, HttpSession session) {
        CmsQuickLaunchLocationCache locationCache = CmsQuickLaunchLocationCache.getLocationCache(session);
        String page = locationCache.getFileExplorerLocation(cms.getRequestContext().getSiteRoot());
        if (page != null) {
            CmsADEConfigData conf = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().addSiteRoot(page));
            page = conf == null || conf.getBasePath() == null ? null : cms.getRequestContext().removeSiteRoot(conf.getBasePath());
        }
        if (page == null) {
            page = locationCache.getSitemapEditorLocation(cms.getRequestContext().getSiteRoot());
        }
        return page;
    }
}

