/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps;

import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import java.util.Locale;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.ui.apps.A_CmsWorkplaceAppConfiguration;
import org.opencms.ui.apps.CmsAppVisibilityStatus;
import org.opencms.ui.apps.I_CmsWorkplaceApp;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.components.OpenCmsTheme;

public class CmsTraditionalWorkplaceConfiguration
extends A_CmsWorkplaceAppConfiguration {
    public static final String APP_ID = "workplace-traditional";

    @Override
    public String getAppCategory() {
        return "none";
    }

    @Override
    public I_CmsWorkplaceApp getAppInstance() {
        throw new IllegalStateException("The editor app should be launched through the app launch command only.");
    }

    @Override
    public String getButtonStyle() {
        return "o-color-transparent";
    }

    @Override
    public String getHelpText(Locale locale) {
        return Messages.get().getBundle(locale).key("GUI_WORKPLACE_HELP_0");
    }

    @Override
    public Resource getIcon() {
        return new ExternalResource(OpenCmsTheme.getImageLink("apps/workplace-traditional.png"));
    }

    @Override
    public String getId() {
        return APP_ID;
    }

    @Override
    public String getName(Locale locale) {
        return Messages.get().getBundle(locale).key("GUI_WORKPLACE_TITLE_0");
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public CmsAppVisibilityStatus getVisibility(CmsObject cms) {
        CmsUserSettings userSettings = new CmsUserSettings(cms);
        boolean usesNewWorkplace = userSettings.usesNewWorkplace();
        if (!usesNewWorkplace) {
            return super.getVisibility(cms);
        }
        return CmsAppVisibilityStatus.INVISIBLE;
    }
}

