/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.CmsUserIconHelper;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.CmsContextMenuActionItem;
import org.opencms.ui.actions.I_CmsDefaultAction;
import org.opencms.ui.apps.CmsAppCategory;
import org.opencms.ui.apps.CmsAppHierarchyConfiguration;
import org.opencms.ui.apps.CmsAppVisibilityStatus;
import org.opencms.ui.apps.CmsDefaultMenuItemProvider;
import org.opencms.ui.apps.CmsEditorConfiguration;
import org.opencms.ui.apps.CmsFileExplorerConfiguration;
import org.opencms.ui.apps.CmsLegacyAppConfiguration;
import org.opencms.ui.apps.CmsPageEditorConfiguration;
import org.opencms.ui.apps.CmsQuickLaunchEditorConfiguration;
import org.opencms.ui.apps.CmsSitemapEditorConfiguration;
import org.opencms.ui.apps.CmsTraditionalWorkplaceConfiguration;
import org.opencms.ui.apps.I_CmsAppCategory;
import org.opencms.ui.apps.I_CmsAppSettings;
import org.opencms.ui.apps.I_CmsWorkplaceAppConfiguration;
import org.opencms.ui.apps.projects.CmsProjectManagerConfiguration;
import org.opencms.ui.apps.scheduler.CmsScheduledJobsAppConfig;
import org.opencms.ui.apps.search.CmsSourceSearchAppConfiguration;
import org.opencms.ui.contextmenu.CmsContextMenuItemProviderGroup;
import org.opencms.ui.contextmenu.I_CmsContextMenuItem;
import org.opencms.ui.contextmenu.I_CmsContextMenuItemProvider;
import org.opencms.ui.editors.CmsAcaciaEditor;
import org.opencms.ui.editors.CmsSourceEditor;
import org.opencms.ui.editors.CmsXmlContentEditor;
import org.opencms.ui.editors.CmsXmlPageEditor;
import org.opencms.ui.editors.I_CmsEditor;
import org.opencms.ui.editors.messagebundle.CmsMessageBundleEditor;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.tools.CmsTool;
import org.opencms.workplace.tools.I_CmsToolHandler;

public class CmsWorkplaceAppManager {
    public static String WORKPLACE_APP_SETTINGS_KEY = "WORKPLACE_APP_SETTINGS";
    protected static Log LOG = CmsLog.getLog(CmsWorkplaceAppManager.class.getName());
    private static final I_CmsEditor[] EDITORS = new I_CmsEditor[]{new CmsAcaciaEditor(), new CmsSourceEditor(), new CmsXmlContentEditor(), new CmsXmlPageEditor(), new CmsMessageBundleEditor()};
    private static final Set<String> LEGACY_BLACKLIST = Sets.newConcurrentHashSet(Arrays.asList("/git", "/scheduler", "/galleryoverview", "/projects"));
    private static final String[] STANDARD_APPS = new String[]{"pageeditor", "sitemapeditor", "explorer", "launchpad"};
    private static final String[] DEFAULT_USER_APPS = new String[]{"/accounts", "/modules"};
    private static final String QUICK_LAUCH_APPS_KEY = "quick_launch_apps";
    public static final String MAIN_CATEGORY_ID = "Main";
    public static final String LEGACY_CATEGORY_ID = "Legacy";
    private CmsObject m_adminCms;
    private Map<String, I_CmsAppCategory> m_appCategories;
    private Map<String, I_CmsWorkplaceAppConfiguration> m_appsById = Maps.newHashMap();
    private CmsUserIconHelper m_iconHelper;
    private CmsContextMenuItemProviderGroup m_workplaceMenuItemProvider;
    private List<I_CmsWorkplaceAppConfiguration> m_standardQuickLaunchApps;

    public CmsWorkplaceAppManager(CmsObject adminCms) throws CmsException {
        this.m_adminCms = adminCms;
        this.m_iconHelper = new CmsUserIconHelper(OpenCms.initCmsObject(this.m_adminCms));
        this.m_workplaceMenuItemProvider = new CmsContextMenuItemProviderGroup();
        this.m_workplaceMenuItemProvider.addProvider(CmsDefaultMenuItemProvider.class);
        this.m_workplaceMenuItemProvider.initialize();
    }

    protected CmsWorkplaceAppManager() {
    }

    public I_CmsWorkplaceAppConfiguration getAppConfiguration(String appId) {
        return this.m_appsById.get(appId);
    }

    public List<I_CmsWorkplaceAppConfiguration> getAppConfigurations(String ... appIds) {
        ArrayList<I_CmsWorkplaceAppConfiguration> result = new ArrayList<I_CmsWorkplaceAppConfiguration>();
        for (int i = 0; i < appIds.length; ++i) {
            I_CmsWorkplaceAppConfiguration config = this.getAppConfiguration(appIds[i]);
            if (config == null) continue;
            result.add(config);
        }
        return result;
    }

    public <T extends I_CmsAppSettings> T getAppSettings(CmsObject cms, Class<T> type) throws InstantiationException, IllegalAccessException {
        CmsUser user = cms.getRequestContext().getCurrentUser();
        CmsUserSettings settings = new CmsUserSettings(user);
        String settingsString = settings.getAdditionalPreference(type.getName(), true);
        I_CmsAppSettings result = (I_CmsAppSettings)type.newInstance();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(settingsString)) {
            result.restoreSettings(settingsString);
        }
        return (T)result;
    }

    public Collection<I_CmsAppCategory> getCategories() {
        return Collections.unmodifiableCollection(this.m_appCategories.values());
    }

    public I_CmsDefaultAction getDefaultAction(I_CmsDialogContext context) {
        I_CmsDefaultAction result = null;
        int resultRank = -1;
        if (context.getResources().size() == 1) {
            for (I_CmsContextMenuItem menuItem : this.getMenuItemProvider().getMenuItems()) {
                I_CmsDefaultAction action;
                if (!(menuItem instanceof CmsContextMenuActionItem) || !(((CmsContextMenuActionItem)menuItem).getWorkplaceAction() instanceof I_CmsDefaultAction) || !(action = (I_CmsDefaultAction)((CmsContextMenuActionItem)menuItem).getWorkplaceAction()).getVisibility(context).isActive()) continue;
                if (result == null) {
                    result = action;
                    resultRank = action.getDefaultActionRank(context);
                    continue;
                }
                int rank = action.getDefaultActionRank(context);
                if (rank <= resultRank) continue;
                result = action;
                resultRank = rank;
            }
        }
        return result;
    }

    public I_CmsEditor getEditorForResource(CmsResource resource, boolean plainText) {
        ArrayList<I_CmsEditor> editors = new ArrayList<I_CmsEditor>();
        for (int i = 0; i < EDITORS.length; ++i) {
            if (!EDITORS[i].matchesResource(resource, plainText)) continue;
            editors.add(EDITORS[i]);
        }
        I_CmsEditor result = null;
        if (editors.size() == 1) {
            result = (I_CmsEditor)editors.get(0);
        } else if (editors.size() > 1) {
            Collections.sort(editors, new Comparator<I_CmsEditor>(){

                @Override
                public int compare(I_CmsEditor o1, I_CmsEditor o2) {
                    return o1.getPriority() > o2.getPriority() ? -1 : 1;
                }
            });
            result = (I_CmsEditor)editors.get(0);
        }
        return result;
    }

    public I_CmsContextMenuItemProvider getMenuItemProvider() {
        return this.m_workplaceMenuItemProvider;
    }

    public List<I_CmsWorkplaceAppConfiguration> getQuickLaunchConfigurations(CmsObject cms) {
        ArrayList<I_CmsWorkplaceAppConfiguration> result = new ArrayList<I_CmsWorkplaceAppConfiguration>();
        result.addAll(this.getDefaultQuickLaunchConfigurations());
        result.addAll(this.getUserQuickLauchConfigurations(cms));
        Iterator it = result.iterator();
        while (it.hasNext()) {
            I_CmsWorkplaceAppConfiguration appConfig = (I_CmsWorkplaceAppConfiguration)it.next();
            CmsAppVisibilityStatus visibility = appConfig.getVisibility(cms);
            if (visibility.isVisible()) continue;
            it.remove();
        }
        return result;
    }

    public CmsUserIconHelper getUserIconHelper() {
        return this.m_iconHelper;
    }

    public Collection<I_CmsWorkplaceAppConfiguration> getWorkplaceApps() {
        return this.m_appsById.values();
    }

    public void loadApps() {
        this.m_appsById.clear();
        this.m_appCategories = this.loadCategories();
        this.addAppConfigurations(this.loadDefaultApps());
        this.addAppConfigurations(this.loadAppsUsingServiceLoader());
        this.addAppConfigurations(this.loadLegacyApps());
    }

    public void storeAppSettings(CmsObject cms, Class<? extends I_CmsAppSettings> type, I_CmsAppSettings appSettings) {
        CmsUser user = cms.getRequestContext().getCurrentUser();
        CmsUserSettings settings = new CmsUserSettings(user);
        String currentSetting = settings.getAdditionalPreference(type.getName(), true);
        String state = appSettings.getSettingsString();
        if (state == null && currentSetting == null || state != null && state.equals(currentSetting)) {
            return;
        }
        settings.setAdditionalPreference(type.getName(), state);
        try {
            settings.save(cms);
        }
        catch (CmsException e) {
            LOG.error((Object)("Failed to store workplace app settings for type " + type.getName()), (Throwable)e);
        }
    }

    protected List<I_CmsWorkplaceAppConfiguration> getDefaultQuickLaunchConfigurations() {
        if (this.m_standardQuickLaunchApps == null) {
            this.m_standardQuickLaunchApps = Collections.unmodifiableList(this.getAppConfigurations(STANDARD_APPS));
        }
        return this.m_standardQuickLaunchApps;
    }

    protected List<I_CmsWorkplaceAppConfiguration> getUserQuickLauchConfigurations(CmsObject cms) {
        String apps_info = (String)cms.getRequestContext().getCurrentUser().getAdditionalInfo(QUICK_LAUCH_APPS_KEY);
        String[] appIds = null;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(apps_info)) {
            try {
                JSONArray ids = new JSONArray(apps_info);
                appIds = new String[ids.length()];
                for (int i = 0; i < appIds.length; ++i) {
                    appIds[i] = ids.getString(i);
                }
            }
            catch (JSONException e) {
                LOG.error((Object)"Error parsing user quick launch apps setting.", (Throwable)e);
                appIds = null;
            }
        }
        return this.getAppConfigurations(appIds != null ? appIds : DEFAULT_USER_APPS);
    }

    protected void setUserQuickLaunchApps(CmsObject cms, List<String> apps) throws CmsException {
        JSONArray appIds = new JSONArray(apps);
        CmsUser user = cms.getRequestContext().getCurrentUser();
        user.setAdditionalInfo(QUICK_LAUCH_APPS_KEY, appIds.toString());
        cms.writeUser(user);
    }

    private void addAppConfigurations(Collection<I_CmsWorkplaceAppConfiguration> appConfigs) {
        for (I_CmsWorkplaceAppConfiguration appConfig : appConfigs) {
            I_CmsWorkplaceAppConfiguration old = this.m_appsById.get(appConfig.getId());
            if (old != null && old.getPriority() >= appConfig.getPriority()) continue;
            this.m_appsById.put(appConfig.getId(), appConfig);
        }
    }

    private List<I_CmsWorkplaceAppConfiguration> loadAppsUsingServiceLoader() {
        ArrayList<I_CmsWorkplaceAppConfiguration> appConfigurations = new ArrayList<I_CmsWorkplaceAppConfiguration>();
        Iterator<I_CmsWorkplaceAppConfiguration> configs = ServiceLoader.load(I_CmsWorkplaceAppConfiguration.class).iterator();
        while (configs.hasNext()) {
            try {
                I_CmsWorkplaceAppConfiguration config = configs.next();
                appConfigurations.add(config);
            }
            catch (Throwable t) {
                LOG.error((Object)"Error loading workplace app configuration from classpath.", t);
            }
        }
        return appConfigurations;
    }

    private Map<String, I_CmsAppCategory> loadCategories() {
        HashMap<String, I_CmsAppCategory> appCategories = new HashMap<String, I_CmsAppCategory>();
        CmsAppCategory main = new CmsAppCategory(MAIN_CATEGORY_ID, null, 0, 0);
        appCategories.put(main.getId(), main);
        CmsAppCategory legacy = new CmsAppCategory(LEGACY_CATEGORY_ID, null, 1, 0);
        appCategories.put(legacy.getId(), legacy);
        Iterator<I_CmsAppCategory> categoryIt = ServiceLoader.load(I_CmsAppCategory.class).iterator();
        while (categoryIt.hasNext()) {
            try {
                I_CmsAppCategory cat = categoryIt.next();
                if (appCategories.containsKey(cat.getId()) && ((I_CmsAppCategory)appCategories.get(cat.getId())).getPriority() >= cat.getPriority()) continue;
                appCategories.put(cat.getId(), cat);
            }
            catch (Throwable t) {
                LOG.error((Object)"Error loading workplace app category from classpath.", t);
            }
        }
        return appCategories;
    }

    private Collection<I_CmsWorkplaceAppConfiguration> loadDefaultApps() {
        ArrayList result = Lists.newArrayList();
        result.addAll(Arrays.asList(new CmsSitemapEditorConfiguration(), new CmsPageEditorConfiguration(), new CmsFileExplorerConfiguration(), new CmsScheduledJobsAppConfig(), new CmsAppHierarchyConfiguration(), new CmsEditorConfiguration(), new CmsQuickLaunchEditorConfiguration(), new CmsTraditionalWorkplaceConfiguration(), new CmsProjectManagerConfiguration(), new CmsSourceSearchAppConfiguration()));
        return result;
    }

    private Collection<I_CmsWorkplaceAppConfiguration> loadLegacyApps() {
        ArrayList<I_CmsWorkplaceAppConfiguration> configs = new ArrayList<I_CmsWorkplaceAppConfiguration>();
        List<CmsTool> tools = OpenCms.getWorkplaceManager().getToolManager().getToolHandlers();
        for (CmsTool tool : tools) {
            I_CmsToolHandler handler = tool.getHandler();
            String path = handler.getPath();
            if (path.length() <= 1 || path.indexOf("/", 1) >= 0 || LEGACY_BLACKLIST.contains(path)) continue;
            configs.add(new CmsLegacyAppConfiguration(handler));
        }
        return configs;
    }

    public static class NavigationState {
        public static final String PARAM_SEPARATOR = "/";
        private String m_params = "";
        private String m_viewName = "";

        public NavigationState(String stateString) {
            int separatorPos;
            if (stateString.startsWith("!")) {
                stateString = stateString.substring(1);
            }
            if ((separatorPos = stateString.indexOf(PARAM_SEPARATOR)) > 0) {
                this.m_viewName = stateString.substring(0, separatorPos);
                this.m_params = stateString.substring(separatorPos + 1);
            } else {
                this.m_viewName = stateString;
            }
            if (this.m_viewName.endsWith(PARAM_SEPARATOR)) {
                this.m_viewName = this.m_viewName.substring(0, this.m_viewName.length() - 1);
            }
        }

        String getParams() {
            return this.m_params;
        }

        String getViewName() {
            return this.m_viewName;
        }
    }
}

