/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.scheduler;

import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsSystemConfiguration;
import org.opencms.main.CmsContextInfo;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.scheduler.CmsScheduledJobInfo;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.A_CmsWorkplaceApp;
import org.opencms.ui.apps.scheduler.CmsJobEditView;
import org.opencms.ui.apps.scheduler.CmsJobTable;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.OpenCmsTheme;
import org.opencms.util.CmsStringUtil;

public class CmsJobManagerApp
extends A_CmsWorkplaceApp {
    public static final String PARAM_COPY = "copy";
    public static final String PARAM_JOB_ID = "jobId";
    public static final String PATH_NAME_EDIT = "edit";
    private static final Log LOG = CmsLog.getLog(CmsJobManagerApp.class);
    protected CmsJobTable m_jobTable;

    public void restoreMainView() {
        this.openSubView("", true);
    }

    @Override
    protected LinkedHashMap<String, String> getBreadCrumbForState(String state) {
        LinkedHashMap<String, String> crumbs = new LinkedHashMap<String, String>();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(state)) {
            crumbs.put("", CmsVaadinUtils.getMessageText("GUI_JOBS_ADMIN_TOOL_NAME_0", new Object[0]));
        } else if (state.startsWith(PATH_NAME_EDIT)) {
            crumbs.put("scheduledjobs", CmsVaadinUtils.getMessageText("GUI_JOBS_ADMIN_TOOL_NAME_0", new Object[0]));
            String jobId = A_CmsWorkplaceApp.getParamFromState(state, PARAM_JOB_ID);
            CmsScheduledJobInfo info = OpenCms.getScheduleManager().getJob(jobId);
            String viewName = info == null ? CmsVaadinUtils.getMessageText("GUI_NEWJOB_ADMIN_TOOL_NAME_0", new Object[0]) : (Boolean.valueOf(A_CmsWorkplaceApp.getParamFromState(state, PARAM_COPY)) != false ? CmsVaadinUtils.getMessageText("GUI_SCHEDULER_TITLE_COPY_1", info.getJobName()) : CmsVaadinUtils.getMessageText("GUI_JOBS_LIST_ACTION_EDIT_NAME_0", new Object[0]));
            crumbs.put("", viewName);
        }
        return crumbs;
    }

    @Override
    protected Component getComponentForState(String state) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(state)) {
            this.m_rootLayout.setMainHeightFull(true);
            CmsJobTable table = this.getJobTable();
            table.reloadJobs();
            return table;
        }
        if (state.startsWith(PATH_NAME_EDIT)) {
            this.m_rootLayout.setMainHeightFull(false);
            String jobId = A_CmsWorkplaceApp.getParamFromState(state, PARAM_JOB_ID);
            String copyMode = A_CmsWorkplaceApp.getParamFromState(state, PARAM_COPY);
            return this.getJobEditView(jobId, Boolean.valueOf(copyMode));
        }
        return null;
    }

    @Override
    protected List<A_CmsWorkplaceApp.NavEntry> getSubNavEntries(String state) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(state)) {
            ArrayList<A_CmsWorkplaceApp.NavEntry> subNav = new ArrayList<A_CmsWorkplaceApp.NavEntry>();
            subNav.add(new A_CmsWorkplaceApp.NavEntry(CmsVaadinUtils.getMessageText("GUI_NEWJOB_ADMIN_TOOL_NAME_0", new Object[0]), CmsVaadinUtils.getMessageText("GUI_NEWJOB_ADMIN_TOOL_HELP_0", new Object[0]), (Resource)new ExternalResource(OpenCmsTheme.getImageLink("scheduler/scheduler_big_add.png")), PATH_NAME_EDIT));
            return subNav;
        }
        return null;
    }

    private CmsJobEditView getJobEditView(String jobId, boolean copy) {
        CmsScheduledJobInfo job = null;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(jobId)) {
            job = OpenCms.getScheduleManager().getJob(jobId);
        }
        if (job == null) {
            job = new CmsScheduledJobInfo();
            job.setContextInfo(new CmsContextInfo());
        }
        final CmsScheduledJobInfo jobCopy = (CmsScheduledJobInfo)job.clone();
        jobCopy.setActive(job.isActive());
        if (copy) {
            jobCopy.clearId();
        }
        final CmsJobEditView editPanel = new CmsJobEditView(jobCopy);
        editPanel.loadFromBean(jobCopy);
        Button saveButton = new Button(CmsVaadinUtils.getMessageText("GUI_DIALOG_BUTTON_OK_0", new Object[0]));
        Button cancelButton = new Button(CmsVaadinUtils.getMessageText("GUI_DIALOG_BUTTON_CANCEL_0", new Object[0]));
        editPanel.setButtons(new Component[]{saveButton, cancelButton});
        saveButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                try {
                    if (editPanel.trySaveToBean()) {
                        OpenCms.getScheduleManager().scheduleJob(A_CmsUI.getCmsObject(), jobCopy);
                        OpenCms.writeConfiguration(CmsSystemConfiguration.class);
                        CmsJobManagerApp.this.restoreMainView();
                    }
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    CmsErrorDialog.showErrorDialog(e, new Runnable(){

                        @Override
                        public void run() {
                            CmsJobManagerApp.this.restoreMainView();
                        }
                    });
                }
            }
        });
        cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsJobManagerApp.this.restoreMainView();
            }
        });
        return editPanel;
    }

    private CmsJobTable getJobTable() {
        if (this.m_jobTable == null) {
            this.m_jobTable = new CmsJobTable();
            this.m_jobTable.setWidth("100%");
        }
        return this.m_jobTable;
    }
}

