/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.scheduler;

import com.vaadin.data.Container;
import com.vaadin.data.util.BeanItemContainer;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Table;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsSystemConfiguration;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.scheduler.CmsScheduleManager;
import org.opencms.scheduler.CmsScheduledJobInfo;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.A_CmsWorkplaceApp;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.scheduler.CmsJobBean;
import org.opencms.ui.components.CmsConfirmationDialog;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.OpenCmsTheme;
import org.opencms.ui.util.table.CmsTableUtil;
import org.opencms.workplace.CmsWorkplace;

public class CmsJobTable
extends Table
implements Table.ColumnGenerator {
    private static final Log LOG = CmsLog.getLog(CmsJobTable.class);
    private static final long serialVersionUID = 1L;
    private BeanItemContainer<CmsJobBean> m_beanContainer = new BeanItemContainer(CmsJobBean.class);

    public CmsJobTable() {
        this.setContainerDataSource((Container)this.m_beanContainer);
        this.setVisibleColumns(new Object[0]);
        for (Action action : Action.values()) {
            this.addGeneratedColumn((Object)action, this);
            this.setColumnWidth((Object)action, 26);
        }
        this.setVisibleColumns(new Object[]{Action.edit, Action.activation, Action.copy, Action.delete, Action.run, "name", "className", "lastExecution", "nextExecution"});
        this.setColumnExpandRatio("name", 1.0f);
        this.setColumnExpandRatio("className", 1.0f);
        this.setColumnExpandRatio("lastExecution", 1.0f);
        this.setColumnExpandRatio("nextExecution", 1.0f);
        this.setSortContainerPropertyId("name");
        this.getVisibleColumns();
        this.setColumnHeader((Object)Action.edit, "E");
        this.setColumnHeader((Object)Action.activation, "A");
        this.setColumnHeader((Object)Action.copy, "C");
        this.setColumnHeader((Object)Action.delete, "D");
        this.setColumnHeader((Object)Action.run, "X");
        this.setColumnHeader("name", CmsVaadinUtils.getMessageText("GUI_JOBS_LIST_COL_NAME_0", new Object[0]));
        this.setColumnHeader("className", CmsVaadinUtils.getMessageText("GUI_JOBS_LIST_COL_CLASS_0", new Object[0]));
        this.setColumnHeader("lastExecution", CmsVaadinUtils.getMessageText("GUI_JOBS_LIST_COL_LASTEXE_0", new Object[0]));
        this.setColumnHeader("nextExecution", CmsVaadinUtils.getMessageText("GUI_JOBS_LIST_COL_NEXTEXE_0", new Object[0]));
    }

    public Object generateCell(Table source, Object itemId, Object columnId) {
        final Action action = (Action)((Object)columnId);
        CmsJobBean jobBean = (CmsJobBean)itemId;
        final CmsScheduledJobInfo job = jobBean.getJob();
        final CmsScheduledJobInfo jobClone = (CmsScheduledJobInfo)job.clone();
        FontOpenCms resource = null;
        String resPath = null;
        switch (action) {
            case activation: {
                resource = job.isActive() ? FontOpenCms.CIRCLE_CHECK : FontOpenCms.CIRCLE_PAUSE;
                break;
            }
            case copy: {
                resource = FontOpenCms.CIRCLE_PLUS;
                break;
            }
            case delete: {
                resource = FontOpenCms.CIRCLE_MINUS;
                break;
            }
            case edit: {
                resPath = OpenCmsTheme.getImageLink("scheduler/scheduler.png");
                break;
            }
            case run: {
                resource = FontOpenCms.CIRCLE_PLAY;
                break;
            }
        }
        if (resource == null && resPath != null) {
            resource = new ExternalResource(resPath);
        }
        Button button = CmsTableUtil.createIconButton((Resource)resource, CmsVaadinUtils.getMessageText(action.getMessageKey(), new Object[0]));
        button.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                try {
                    switch (action) {
                        case activation: {
                            jobClone.setActive(!job.isActive());
                            CmsJobTable.this.writeChangedJob(jobClone);
                            break;
                        }
                        case copy: {
                            String stateCopy = "scheduledjobs/edit";
                            stateCopy = A_CmsWorkplaceApp.addParamToState(stateCopy, "jobId", job.getId());
                            stateCopy = A_CmsWorkplaceApp.addParamToState(stateCopy, "copy", Boolean.TRUE.toString());
                            CmsAppWorkplaceUi.get().getNavigator().navigateTo(stateCopy);
                            break;
                        }
                        case delete: {
                            CmsConfirmationDialog.show(CmsVaadinUtils.getMessageText(action.getMessageKey(), new Object[0]), CmsVaadinUtils.getMessageText("GUI_SCHEDULER_CONFIRM_DELETE_1", job.getJobName()), new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        OpenCms.getScheduleManager().unscheduleJob(A_CmsUI.getCmsObject(), job.getId());
                                        OpenCms.writeConfiguration(CmsSystemConfiguration.class);
                                        CmsJobTable.this.reloadJobs();
                                    }
                                    catch (CmsRoleViolationException e) {
                                        CmsErrorDialog.showErrorDialog(e);
                                    }
                                }
                            });
                            break;
                        }
                        case edit: {
                            String stateEdit = "scheduledjobs/edit";
                            stateEdit = A_CmsWorkplaceApp.addParamToState(stateEdit, "jobId", job.getId());
                            CmsAppWorkplaceUi.get().getNavigator().navigateTo(stateEdit);
                            break;
                        }
                        case run: {
                            CmsConfirmationDialog.show(CmsVaadinUtils.getMessageText(action.getMessageKey(), new Object[0]), CmsVaadinUtils.getMessageText("GUI_SCHEDULER_CONFIRM_EXECUTE_1", job.getJobName()), new Runnable(){

                                @Override
                                public void run() {
                                    CmsScheduleManager scheduler = OpenCms.getScheduleManager();
                                    scheduler.executeDirectly(job.getId());
                                }
                            });
                            break;
                        }
                    }
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    CmsErrorDialog.showErrorDialog(e, new Runnable(){

                        @Override
                        public void run() {
                        }
                    });
                }
            }
        });
        return button;
    }

    public void reloadJobs() {
        this.m_beanContainer.removeAllItems();
        for (CmsScheduledJobInfo job : OpenCms.getScheduleManager().getJobs()) {
            this.m_beanContainer.addBean((Object)new CmsJobBean(job));
        }
        this.sort();
        this.refreshRowCache();
    }

    ExternalResource getIconResource(String subPath) {
        String resPath = CmsWorkplace.getResourceUri(subPath);
        return new ExternalResource(resPath);
    }

    private void writeChangedJob(CmsScheduledJobInfo jobInfo) throws CmsException {
        OpenCms.getScheduleManager().scheduleJob(A_CmsUI.getCmsObject(), jobInfo);
        OpenCms.writeConfiguration(CmsSystemConfiguration.class);
        this.reloadJobs();
    }

    static enum Action {
        activation("GUI_JOBS_LIST_ACTION_MACTIVATE_NAME_0"),
        copy("GUI_JOBS_LIST_ACTION_COPY_NAME_0"),
        delete("GUI_JOBS_LIST_ACTION_DELETE_NAME_0"),
        edit("GUI_JOBS_LIST_ACTION_EDIT_NAME_0"),
        run("GUI_JOBS_LIST_ACTION_EXECUTE_NAME_0");

        private String m_key;

        private Action(String key) {
            this.m_key = key;
        }

        String getMessageKey() {
            return this.m_key;
        }
    }
}

