/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.scheduler;

import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import java.util.Locale;
import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.ui.apps.A_CmsWorkplaceAppConfiguration;
import org.opencms.ui.apps.CmsAppVisibilityStatus;
import org.opencms.ui.apps.I_CmsWorkplaceApp;
import org.opencms.ui.apps.scheduler.CmsJobManagerApp;
import org.opencms.ui.components.OpenCmsTheme;
import org.opencms.workplace.tools.scheduler.Messages;

public class CmsScheduledJobsAppConfig
extends A_CmsWorkplaceAppConfiguration {
    public static final String APP_ID = "scheduledjobs";

    @Override
    public String getAppCategory() {
        return "Main";
    }

    @Override
    public I_CmsWorkplaceApp getAppInstance() {
        return new CmsJobManagerApp();
    }

    @Override
    public String getButtonStyle() {
        return "o-color-transparent";
    }

    @Override
    public String getHelpText(Locale locale) {
        return Messages.get().getBundle(locale).key("GUI_JOBS_ADMIN_TOOL_HELP_0");
    }

    @Override
    public Resource getIcon() {
        return new ExternalResource(OpenCmsTheme.getImageLink("apps/scheduler.png"));
    }

    @Override
    public String getId() {
        return APP_ID;
    }

    @Override
    public String getName(Locale locale) {
        return Messages.get().getBundle(locale).key("GUI_JOBS_ADMIN_TOOL_SHORTNAME_0");
    }

    @Override
    public int getOrder() {
        return 8;
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public CmsAppVisibilityStatus getVisibility(CmsObject cms) {
        boolean visible = OpenCms.getRoleManager().hasRole(cms, CmsRole.WORKPLACE_MANAGER);
        return new CmsAppVisibilityStatus(visible, visible, "");
    }
}

