/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components;

import com.google.common.collect.Lists;
import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.Validator;
import com.vaadin.data.util.DefaultItemSorter;
import com.vaadin.data.util.filter.Or;
import com.vaadin.data.util.filter.SimpleStringFilter;
import com.vaadin.event.FieldEvents;
import com.vaadin.event.ItemClickEvent;
import com.vaadin.event.ShortcutListener;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.ui.AbstractTextField;
import com.vaadin.ui.Component;
import com.vaadin.ui.DefaultFieldFactory;
import com.vaadin.ui.Field;
import com.vaadin.ui.Table;
import com.vaadin.ui.TableFieldFactory;
import com.vaadin.ui.TextField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.I_CmsEditPropertyContext;
import org.opencms.ui.actions.I_CmsDefaultAction;
import org.opencms.ui.apps.CmsFileExplorerSettings;
import org.opencms.ui.apps.I_CmsContextProvider;
import org.opencms.ui.components.CmsResourceTable;
import org.opencms.ui.components.CmsResourceTableProperty;
import org.opencms.ui.components.I_CmsFilePropertyEditHandler;
import org.opencms.ui.contextmenu.CmsContextMenu;
import org.opencms.ui.contextmenu.CmsResourceContextMenuBuilder;
import org.opencms.ui.contextmenu.I_CmsContextMenuBuilder;
import org.opencms.ui.util.I_CmsItemSorter;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsFileTable
extends CmsResourceTable {
    static final Log LOG = CmsLog.getLog(CmsFileTable.class);
    private static final Map<CmsResourceTableProperty, Integer> DEFAULT_TABLE_PROPERTIES = new LinkedHashMap<CmsResourceTableProperty, Integer>();
    private static final long serialVersionUID = 5460048685141699277L;
    protected List<CmsResource> m_currentResources = new ArrayList<CmsResource>();
    I_CmsFilePropertyEditHandler m_editHandler;
    FileEditHandler m_fileEditHandler = new FileEditHandler();
    CmsContextMenu m_menu;
    I_CmsContextMenuBuilder m_menuBuilder;
    private I_CmsContextProvider m_contextProvider;
    private CmsUUID m_editItemId;
    private CmsResourceTableProperty m_editProperty;
    private I_FolderSelectHandler m_folderSelectHandler;
    private String m_originalEditValue;
    private Table.TableDragMode m_beforEditDragMode;
    CmsResourceTableProperty m_actionColumnProperty;

    public CmsFileTable(I_CmsContextProvider contextProvider) {
        DEFAULT_TABLE_PROPERTIES.put(CmsResourceTableProperty.PROPERTY_TYPE_ICON, 0);
        DEFAULT_TABLE_PROPERTIES.put(CmsResourceTableProperty.PROPERTY_PROJECT, 1);
        DEFAULT_TABLE_PROPERTIES.put(CmsResourceTableProperty.PROPERTY_RESOURCE_NAME, 0);
        DEFAULT_TABLE_PROPERTIES.put(CmsResourceTableProperty.PROPERTY_TITLE, 0);
        DEFAULT_TABLE_PROPERTIES.put(CmsResourceTableProperty.PROPERTY_NAVIGATION_TEXT, 1);
        DEFAULT_TABLE_PROPERTIES.put(CmsResourceTableProperty.PROPERTY_NAVIGATION_POSITION, 2);
        DEFAULT_TABLE_PROPERTIES.put(CmsResourceTableProperty.PROPERTY_IN_NAVIGATION, 2);
        DEFAULT_TABLE_PROPERTIES.put(CmsResourceTableProperty.PROPERTY_COPYRIGHT, 1);
        DEFAULT_TABLE_PROPERTIES.put(CmsResourceTableProperty.PROPERTY_CACHE, 1);
        DEFAULT_TABLE_PROPERTIES.put(CmsResourceTableProperty.PROPERTY_RESOURCE_TYPE, 0);
        DEFAULT_TABLE_PROPERTIES.put(CmsResourceTableProperty.PROPERTY_SIZE, 0);
        DEFAULT_TABLE_PROPERTIES.put(CmsResourceTableProperty.PROPERTY_PERMISSIONS, 1);
        DEFAULT_TABLE_PROPERTIES.put(CmsResourceTableProperty.PROPERTY_DATE_MODIFIED, 0);
        DEFAULT_TABLE_PROPERTIES.put(CmsResourceTableProperty.PROPERTY_USER_MODIFIED, 1);
        DEFAULT_TABLE_PROPERTIES.put(CmsResourceTableProperty.PROPERTY_DATE_CREATED, 1);
        DEFAULT_TABLE_PROPERTIES.put(CmsResourceTableProperty.PROPERTY_USER_CREATED, 1);
        DEFAULT_TABLE_PROPERTIES.put(CmsResourceTableProperty.PROPERTY_DATE_RELEASED, 0);
        DEFAULT_TABLE_PROPERTIES.put(CmsResourceTableProperty.PROPERTY_DATE_EXPIRED, 0);
        DEFAULT_TABLE_PROPERTIES.put(CmsResourceTableProperty.PROPERTY_STATE_NAME, 0);
        DEFAULT_TABLE_PROPERTIES.put(CmsResourceTableProperty.PROPERTY_USER_LOCKED, 0);
        DEFAULT_TABLE_PROPERTIES.put(CmsResourceTableProperty.PROPERTY_IS_FOLDER, 2);
        DEFAULT_TABLE_PROPERTIES.put(CmsResourceTableProperty.PROPERTY_STATE, 2);
        DEFAULT_TABLE_PROPERTIES.put(CmsResourceTableProperty.PROPERTY_INSIDE_PROJECT, 2);
        DEFAULT_TABLE_PROPERTIES.put(CmsResourceTableProperty.PROPERTY_RELEASED_NOT_EXPIRED, 2);
        this.m_actionColumnProperty = CmsResourceTableProperty.PROPERTY_RESOURCE_NAME;
        this.m_contextProvider = contextProvider;
        this.m_container.setItemSorter(new FileSorter());
        this.m_fileTable.addStyleName("borderless");
        this.m_fileTable.addStyleName("o-simple-drag");
        this.m_fileTable.setSizeFull();
        this.m_fileTable.setColumnCollapsingAllowed(true);
        this.m_fileTable.setSelectable(true);
        this.m_fileTable.setMultiSelect(true);
        this.m_fileTable.setTableFieldFactory((TableFieldFactory)new FileFieldFactory());
        CmsResourceTable.ColumnBuilder builder = new CmsResourceTable.ColumnBuilder();
        for (Map.Entry<CmsResourceTableProperty, Integer> entry : DEFAULT_TABLE_PROPERTIES.entrySet()) {
            builder.column(entry.getKey(), entry.getValue());
        }
        builder.buildColumns();
        this.m_fileTable.setSortContainerPropertyId((Object)CmsResourceTableProperty.PROPERTY_RESOURCE_NAME);
        this.m_menu = new CmsContextMenu();
        this.m_fileTable.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                Set selectedIds = (Set)event.getProperty().getValue();
                ArrayList<CmsResource> selectedResources = new ArrayList<CmsResource>();
                for (CmsUUID id : selectedIds) {
                    try {
                        CmsResource resource = A_CmsUI.getCmsObject().readResource(id, CmsResourceFilter.ALL);
                        selectedResources.add(resource);
                    }
                    catch (CmsException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                CmsFileTable.this.m_currentResources = selectedResources;
                if (!selectedIds.isEmpty() && CmsFileTable.this.m_menuBuilder != null) {
                    CmsFileTable.this.m_menu.removeAllItems();
                    CmsFileTable.this.m_menuBuilder.buildContextMenu(CmsFileTable.this.getContextProvider().getDialogContext(), CmsFileTable.this.m_menu);
                }
            }
        });
        this.m_fileTable.addItemClickListener(new ItemClickEvent.ItemClickListener(){
            private static final long serialVersionUID = 1L;

            public void itemClick(ItemClickEvent event) {
                CmsFileTable.this.handleFileItemClick(event);
            }
        });
        this.m_fileTable.setCellStyleGenerator(new Table.CellStyleGenerator(){
            private static final long serialVersionUID = 1L;

            public String getStyle(Table source, Object itemId, Object propertyId) {
                Item item = CmsFileTable.this.m_container.getItem(itemId);
                String style = CmsFileTable.getStateStyle(item);
                if (CmsFileTable.this.m_actionColumnProperty == propertyId) {
                    style = style + " o-hover-column";
                } else if ((CmsResourceTableProperty.PROPERTY_NAVIGATION_TEXT == propertyId || CmsResourceTableProperty.PROPERTY_TITLE == propertyId) && item.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_IN_NAVIGATION) != null && ((Boolean)item.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_IN_NAVIGATION).getValue()).booleanValue()) {
                    style = style + " o-in-navigation";
                }
                return style;
            }
        });
        this.m_menu.setAsTableContextMenu(this.m_fileTable);
    }

    public static String getStateStyle(Item resourceItem) {
        String result = "";
        if (resourceItem != null) {
            if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_INSIDE_PROJECT) == null || ((Boolean)resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_INSIDE_PROJECT).getValue()).booleanValue()) {
                CmsResourceState state = (CmsResourceState)resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_STATE).getValue();
                result = CmsFileTable.getStateStyle(state);
            } else {
                result = "o-project-other";
            }
            if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_RELEASED_NOT_EXPIRED) != null && !((Boolean)resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_RELEASED_NOT_EXPIRED).getValue()).booleanValue()) {
                result = result + " o-expired";
            }
            if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_DISABLED) != null && ((Boolean)resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_DISABLED).getValue()).booleanValue()) {
                result = result + " o-disabled";
            }
        }
        return result;
    }

    public void applyWorkplaceAppSettings() {
        this.m_container.addContainerProperty(CmsResourceTableProperty.PROPERTY_SITE_PATH, CmsResourceTableProperty.PROPERTY_SITE_PATH.getColumnType(), CmsResourceTableProperty.PROPERTY_SITE_PATH.getDefaultValue());
        Object[] visibleCols = this.m_fileTable.getVisibleColumns();
        for (int i = 0; i < visibleCols.length; ++i) {
            if (!CmsResourceTableProperty.PROPERTY_RESOURCE_NAME.equals(visibleCols[i])) continue;
            visibleCols[i] = CmsResourceTableProperty.PROPERTY_SITE_PATH;
        }
        this.m_fileTable.setVisibleColumns(visibleCols);
        this.m_fileTable.setColumnCollapsible((Object)CmsResourceTableProperty.PROPERTY_SITE_PATH, false);
        this.m_fileTable.setColumnHeader((Object)CmsResourceTableProperty.PROPERTY_SITE_PATH, CmsVaadinUtils.getMessageText(CmsResourceTableProperty.PROPERTY_SITE_PATH.getHeaderKey(), new Object[0]));
        try {
            CmsFileExplorerSettings settings = OpenCms.getWorkplaceAppManager().getAppSettings(A_CmsUI.getCmsObject(), CmsFileExplorerSettings.class);
            this.setTableState(settings);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while reading file explorer settings from user.", (Throwable)e);
        }
        this.m_fileTable.setSortContainerPropertyId((Object)CmsResourceTableProperty.PROPERTY_SITE_PATH);
        this.setActionColumnProperty(CmsResourceTableProperty.PROPERTY_SITE_PATH);
        this.setMenuBuilder(new CmsResourceContextMenuBuilder());
    }

    public void filterTable(String search) {
        this.m_container.removeAllContainerFilters();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(search)) {
            this.m_container.addContainerFilter((Container.Filter)new Or(new Container.Filter[]{new SimpleStringFilter((Object)CmsResourceTableProperty.PROPERTY_RESOURCE_NAME, search, true, false), new SimpleStringFilter((Object)CmsResourceTableProperty.PROPERTY_NAVIGATION_TEXT, search, true, false), new SimpleStringFilter((Object)CmsResourceTableProperty.PROPERTY_TITLE, search, true, false)}));
        }
    }

    public int getFirstVisibleItemIndex() {
        return this.m_fileTable.getCurrentPageFirstItemIndex();
    }

    public Set<CmsUUID> getSelectedIds() {
        return (Set)this.m_fileTable.getValue();
    }

    public List<CmsResource> getSelectedResources() {
        return this.m_currentResources;
    }

    public CmsFileExplorerSettings getTableSettings() {
        CmsFileExplorerSettings fileTableState = new CmsFileExplorerSettings();
        fileTableState.setSortAscending(this.m_fileTable.isSortAscending());
        fileTableState.setSortColumnId((CmsResourceTableProperty)this.m_fileTable.getSortContainerPropertyId());
        ArrayList<CmsResourceTableProperty> collapsedCollumns = new ArrayList<CmsResourceTableProperty>();
        Object[] visibleCols = this.m_fileTable.getVisibleColumns();
        for (int i = 0; i < visibleCols.length; ++i) {
            if (!this.m_fileTable.isColumnCollapsed(visibleCols[i])) continue;
            collapsedCollumns.add((CmsResourceTableProperty)visibleCols[i]);
        }
        fileTableState.setCollapsedColumns(collapsedCollumns);
        return fileTableState;
    }

    public void handleSelection(CmsUUID itemId) {
        Set<CmsUUID> selection = this.getSelectedIds();
        if (selection == null) {
            this.m_fileTable.select((Object)itemId);
        } else if (!selection.contains(itemId)) {
            this.m_fileTable.setValue(null);
            this.m_fileTable.select((Object)itemId);
        }
    }

    public boolean isEditing() {
        return this.m_editItemId != null;
    }

    public boolean isEditProperty(CmsResourceTableProperty propertyId) {
        return this.m_editProperty != null && this.m_editProperty.equals(propertyId);
    }

    public void openContextMenu(ItemClickEvent event) {
        this.m_menu.openForTable(event, this.m_fileTable);
    }

    public void setActionColumnProperty(CmsResourceTableProperty actionColumnProperty) {
        this.m_actionColumnProperty = actionColumnProperty;
    }

    public void setContextProvider(I_CmsContextProvider provider) {
        this.m_contextProvider = provider;
    }

    public void setFirstVisibleItemIndex(int i) {
        this.m_fileTable.setCurrentPageFirstItemIndex(i);
    }

    public void setFolderSelectHandler(I_FolderSelectHandler folderSelectHandler) {
        this.m_folderSelectHandler = folderSelectHandler;
    }

    public void setMenuBuilder(I_CmsContextMenuBuilder builder) {
        this.m_menuBuilder = builder;
    }

    public void setTableState(CmsFileExplorerSettings state) {
        if (state != null) {
            this.m_fileTable.setSortContainerPropertyId((Object)state.getSortColumnId());
            this.m_fileTable.setSortAscending(state.isSortAscending());
            Object[] visibleCols = this.m_fileTable.getVisibleColumns();
            for (int i = 0; i < visibleCols.length; ++i) {
                this.m_fileTable.setColumnCollapsed(visibleCols[i], state.getCollapsedColumns().contains(visibleCols[i]));
            }
        }
    }

    public void startEdit(CmsUUID itemId, CmsResourceTableProperty propertyId, I_CmsFilePropertyEditHandler editHandler) {
        this.m_editItemId = itemId;
        this.m_editProperty = propertyId;
        this.m_originalEditValue = (String)this.m_container.getItem(this.m_editItemId).getItemProperty((Object)this.m_editProperty).getValue();
        this.m_editHandler = editHandler;
        this.m_beforEditDragMode = this.m_fileTable.getDragMode();
        this.m_fileTable.setDragMode(Table.TableDragMode.NONE);
        this.m_fileTable.setEditable(true);
    }

    public void stopEdit() {
        if (this.m_editHandler != null) {
            String value = (String)this.m_container.getItem(this.m_editItemId).getItemProperty((Object)this.m_editProperty).getValue();
            if (!value.equals(this.m_originalEditValue)) {
                this.m_editHandler.validate(value);
                this.m_editHandler.save(value);
            } else {
                this.m_editHandler.cancel();
            }
        }
        this.clearEdit();
        this.m_fileTable.setDragMode(this.m_beforEditDragMode);
        this.m_beforEditDragMode = null;
    }

    public void update(CmsUUID id, boolean remove) {
        this.updateItem(id, remove);
    }

    public void updateColumnWidths(int estimatedSpace) {
        Object[] cols = this.m_fileTable.getVisibleColumns();
        ArrayList expandCols = Lists.newArrayList();
        int nonExpandWidth = 0;
        int totalExpandMinWidth = 0;
        for (Object colObj : cols) {
            if (this.m_fileTable.isColumnCollapsed(colObj)) continue;
            CmsResourceTableProperty prop = (CmsResourceTableProperty)colObj;
            if (0.0f < this.m_fileTable.getColumnExpandRatio((Object)prop)) {
                expandCols.add(prop);
                totalExpandMinWidth += this.getAlternativeWidthForExpandingColumns(prop);
                continue;
            }
            nonExpandWidth += prop.getColumnWidth();
        }
        if (estimatedSpace < totalExpandMinWidth + nonExpandWidth) {
            for (CmsResourceTableProperty expandCol : expandCols) {
                this.m_fileTable.setColumnWidth((Object)expandCol, this.getAlternativeWidthForExpandingColumns(expandCol));
            }
        }
    }

    public void updateSorting() {
        this.m_fileTable.sort();
    }

    void cancelEdit() {
        if (this.m_editHandler != null) {
            this.m_editHandler.cancel();
        }
        this.clearEdit();
    }

    I_CmsContextProvider getContextProvider() {
        return this.m_contextProvider;
    }

    CmsUUID getEditItemId() {
        return this.m_editItemId;
    }

    CmsResourceTableProperty getEditProperty() {
        return this.m_editProperty;
    }

    void handleFileItemClick(ItemClickEvent event) {
        if (this.isEditing()) {
            this.stopEdit();
        } else if (!event.isCtrlKey() && !event.isShiftKey()) {
            CmsUUID itemId = (CmsUUID)event.getItemId();
            boolean openedFolder = false;
            if (event.getButton().equals((Object)MouseEventDetails.MouseButton.RIGHT)) {
                this.handleSelection(itemId);
                this.openContextMenu(event);
            } else if (event.getPropertyId() == null || CmsResourceTableProperty.PROPERTY_TYPE_ICON.equals(event.getPropertyId())) {
                this.openContextMenu(event);
            } else if (this.m_actionColumnProperty.equals(event.getPropertyId())) {
                Boolean isFolder = (Boolean)event.getItem().getItemProperty((Object)CmsResourceTableProperty.PROPERTY_IS_FOLDER).getValue();
                if (isFolder != null && isFolder.booleanValue()) {
                    if (this.m_folderSelectHandler != null) {
                        this.m_folderSelectHandler.onFolderSelect(itemId);
                    }
                    openedFolder = true;
                } else {
                    try {
                        CmsObject cms = A_CmsUI.getCmsObject();
                        CmsResource res = cms.readResource(itemId, CmsResourceFilter.IGNORE_EXPIRATION);
                        this.m_currentResources = Collections.singletonList(res);
                        I_CmsDialogContext context = this.m_contextProvider.getDialogContext();
                        I_CmsDefaultAction action = OpenCms.getWorkplaceAppManager().getDefaultAction(context);
                        if (action != null) {
                            action.executeAction(context);
                            return;
                        }
                    }
                    catch (CmsVfsResourceNotFoundException e) {
                        LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                    catch (CmsException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            } else {
                I_CmsDialogContext context = this.m_contextProvider.getDialogContext();
                if (this.m_currentResources.size() == 1 && this.m_currentResources.get(0).getStructureId().equals(itemId) && context instanceof I_CmsEditPropertyContext && ((I_CmsEditPropertyContext)((Object)context)).isPropertyEditable(event.getPropertyId())) {
                    ((I_CmsEditPropertyContext)((Object)context)).editProperty(event.getPropertyId());
                }
            }
            if (!openedFolder) {
                this.update(itemId, false);
            }
        }
    }

    private void clearEdit() {
        this.m_fileTable.setEditable(false);
        if (this.m_editItemId != null) {
            this.updateItem(this.m_editItemId, false);
        }
        this.m_editItemId = null;
        this.m_editProperty = null;
        this.m_editHandler = null;
        this.updateSorting();
    }

    private int getAlternativeWidthForExpandingColumns(CmsResourceTableProperty prop) {
        if (prop.getId().equals(CmsResourceTableProperty.PROPERTY_RESOURCE_NAME.getId())) {
            return 200;
        }
        if (prop.getId().equals(CmsResourceTableProperty.PROPERTY_TITLE.getId())) {
            return 300;
        }
        if (prop.getId().equals(CmsResourceTableProperty.PROPERTY_NAVIGATION_TEXT.getId())) {
            return 200;
        }
        return 200;
    }

    private void updateItem(CmsUUID itemId, boolean remove) {
        if (remove) {
            this.m_container.removeItem(itemId);
            return;
        }
        CmsObject cms = A_CmsUI.getCmsObject();
        try {
            CmsResource resource = cms.readResource(itemId, CmsResourceFilter.ALL);
            this.fillItem(cms, resource, OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
        }
        catch (CmsVfsResourceNotFoundException e) {
            this.m_container.removeItem(itemId);
            LOG.debug((Object)"Failed to update file table item, removing it from view.", (Throwable)e);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static interface I_FolderSelectHandler {
        public void onFolderSelect(CmsUUID var1);
    }

    public static class FileSorter
    extends DefaultItemSorter
    implements I_CmsItemSorter {
        private static final long serialVersionUID = 1L;

        @Override
        public Collection<?> getSortableContainerPropertyIds(Container container) {
            HashSet result = new HashSet();
            for (Object propId : container.getContainerPropertyIds()) {
                Class propertyType = container.getType(propId);
                if (!Comparable.class.isAssignableFrom(propertyType) && !propertyType.isPrimitive() && (!propId.equals(CmsResourceTableProperty.PROPERTY_TYPE_ICON) || !container.getContainerPropertyIds().contains(CmsResourceTableProperty.PROPERTY_NAVIGATION_POSITION))) continue;
                result.add(propId);
            }
            return result;
        }

        protected int compareProperty(Object propertyId, boolean sortDirection, Item item1, Item item2) {
            if (CmsResourceTableProperty.PROPERTY_RESOURCE_NAME.equals(propertyId)) {
                Boolean isFolder2;
                Boolean isFolder1 = (Boolean)item1.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_IS_FOLDER).getValue();
                if (!isFolder1.equals(isFolder2 = (Boolean)item2.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_IS_FOLDER).getValue())) {
                    int result;
                    int n = result = isFolder1 != false ? -1 : 1;
                    if (!sortDirection) {
                        result *= -1;
                    }
                    return result;
                }
            } else if ((CmsResourceTableProperty.PROPERTY_TYPE_ICON.equals(propertyId) || CmsResourceTableProperty.PROPERTY_NAVIGATION_TEXT.equals(propertyId)) && item1.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_NAVIGATION_POSITION) != null) {
                int result;
                Float pos1 = (Float)item1.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_NAVIGATION_POSITION).getValue();
                Float pos2 = (Float)item2.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_NAVIGATION_POSITION).getValue();
                if (pos1 == null) {
                    result = pos2 == null ? this.compareProperty(CmsResourceTableProperty.PROPERTY_RESOURCE_NAME, true, item1, item2) : 1;
                } else {
                    int n = result = pos2 == null ? -1 : Float.compare(pos1.floatValue(), pos2.floatValue());
                }
                if (!sortDirection) {
                    result *= -1;
                }
                return result;
            }
            return super.compareProperty(propertyId, sortDirection, item1, item2);
        }
    }

    public class FileFieldFactory
    extends DefaultFieldFactory {
        private static final long serialVersionUID = 3079590603587933576L;

        public Field<?> createField(Container container, Object itemId, Object propertyId, Component uiContext) {
            Field result = null;
            if (itemId.equals(CmsFileTable.this.getEditItemId()) && CmsFileTable.this.isEditProperty((CmsResourceTableProperty)propertyId)) {
                result = super.createField(container, itemId, propertyId, uiContext);
                result.addStyleName("o-inline-textfield");
                result.addValidator((Validator)CmsFileTable.this.m_editHandler);
                if (result instanceof TextField) {
                    ((TextField)result).setComponentError(null);
                    ((TextField)result).addShortcutListener(new ShortcutListener("Cancel edit", 27, null){
                        private static final long serialVersionUID = 1L;

                        public void handleAction(Object sender, Object target) {
                            CmsFileTable.this.cancelEdit();
                        }
                    });
                    ((TextField)result).addShortcutListener(new ShortcutListener("Save", 13, null){
                        private static final long serialVersionUID = 1L;

                        public void handleAction(Object sender, Object target) {
                            CmsFileTable.this.stopEdit();
                        }
                    });
                    ((TextField)result).addBlurListener((FieldEvents.BlurListener)CmsFileTable.this.m_fileEditHandler);
                    ((TextField)result).setTextChangeEventMode(AbstractTextField.TextChangeEventMode.LAZY);
                    ((TextField)result).addTextChangeListener((FieldEvents.TextChangeListener)CmsFileTable.this.m_editHandler);
                }
                result.focus();
            }
            return result;
        }
    }

    public class FileEditHandler
    implements FieldEvents.BlurListener {
        private static final long serialVersionUID = -2286815522247807054L;

        public void blur(FieldEvents.BlurEvent event) {
            CmsFileTable.this.stopEdit();
        }
    }
}

