/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components;

import com.google.common.collect.Lists;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Label;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeFolderExtended;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.jsp.CmsJspNavBuilder;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsSecurityException;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsResourceIcon
extends Label {
    private static final Log LOG = CmsLog.getLog(CmsResourceIcon.class);
    private static final long serialVersionUID = 5031544534869165777L;

    public CmsResourceIcon() {
        this.setPrimaryStyleName("o-resource-icon");
        this.setContentMode(ContentMode.HTML);
    }

    public CmsResourceIcon(CmsResourceUtil resUtil, CmsResourceState state, boolean showLocks) {
        this();
        this.initContent(resUtil, state, showLocks, true);
    }

    public static String getDefaultFileOrDetailType(CmsObject cms, CmsResource resource) {
        String type = null;
        if (resource.isFolder()) {
            if (!(OpenCms.getResourceManager().getResourceType(resource) instanceof CmsResourceTypeFolderExtended)) {
                try {
                    CmsResource defaultFile = cms.readDefaultFile(resource, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                    if (defaultFile != null && (type = CmsResourceIcon.getDetailType(cms, defaultFile, resource)) == null) {
                        type = OpenCms.getResourceManager().getResourceType(defaultFile).getTypeName();
                    }
                }
                catch (CmsSecurityException cmsSecurityException) {}
            }
        } else if (CmsResourceTypeXmlContainerPage.isContainerPage(resource)) {
            type = CmsResourceIcon.getDetailType(cms, resource, null);
        }
        return type;
    }

    public static String getDetailType(CmsObject cms, CmsResource detailPage, CmsResource parentFolder) {
        String type;
        block5: {
            type = null;
            try {
                if (!OpenCms.getADEManager().isDetailPage(cms, detailPage)) break block5;
                List<CmsDetailPageInfo> detailPages = OpenCms.getADEManager().getAllDetailPages(cms);
                if (parentFolder == null) {
                    parentFolder = cms.readParentFolder(detailPage.getStructureId());
                }
                for (CmsDetailPageInfo info : detailPages) {
                    if (!info.getId().equals(detailPage.getStructureId()) && !info.getId().equals(parentFolder.getStructureId())) continue;
                    type = info.getType();
                    if (type.startsWith("function@")) {
                        type = "function";
                    }
                    break;
                }
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
        }
        return type;
    }

    public static String getIconHTML(CmsResourceUtil resUtil, CmsResourceState state, boolean showLocks) {
        return "<span class=\"o-resource-icon\">" + CmsResourceIcon.getIconInnerHTML(resUtil, state, showLocks, true) + "</span>";
    }

    public static String getSitemapResourceIcon(CmsObject cms, CmsResource resource, IconMode iconMode) {
        boolean skipDefaultFile;
        CmsResource defaultFile = null;
        ArrayList resourcesForType = Lists.newArrayList();
        resourcesForType.add(resource);
        boolean bl = skipDefaultFile = iconMode == IconMode.sitemapSelect && OpenCms.getResourceManager().matchResourceType("subsitemap", resource.getTypeId());
        if (resource.isFolder() && !skipDefaultFile) {
            try {
                defaultFile = cms.readDefaultFile(resource, CmsResourceFilter.IGNORE_EXPIRATION);
                if (defaultFile != null) {
                    resourcesForType.add(0, defaultFile);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (CmsJspNavBuilder.isNavLevelFolder(cms, resource)) {
            return CmsWorkplace.getResourceUri("filetypes/navlevel_big.png");
        }
        CmsResource maybePage = (CmsResource)resourcesForType.get(0);
        if (CmsResourceTypeXmlContainerPage.isContainerPage(maybePage)) {
            CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, maybePage.getRootPath());
            for (CmsDetailPageInfo realInfo : config.getAllDetailPages(true)) {
                CmsExplorerTypeSettings settings;
                if (!realInfo.getUri().equals(maybePage.getRootPath()) && !realInfo.getUri().equals(CmsResource.getParentFolder(maybePage.getRootPath())) || (settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(realInfo.getIconType())) == null) continue;
                return CmsWorkplace.getResourceUri("filetypes/" + settings.getBigIconIfAvailable());
            }
        }
        String result = null;
        for (CmsResource res : resourcesForType) {
            I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(res);
            CmsExplorerTypeSettings settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(type.getTypeName());
            if (settings == null) continue;
            result = "filetypes/" + settings.getBigIconIfAvailable();
            break;
        }
        return CmsWorkplace.getResourceUri(result);
    }

    public static String getTreeCaptionHTML(String resourceName, CmsResourceUtil resUtil, CmsResourceState state, boolean showLocks) {
        return CmsResourceIcon.getIconHTML(resUtil, null, false) + "<span class=\"o-tree-caption\">" + resourceName + "</span>";
    }

    private static String getIconInnerHTML(CmsResourceUtil resUtil, CmsResourceState state, boolean showLocks, boolean showDetailIcon) {
        return CmsResourceIcon.getIconInnerHTML(resUtil, resUtil.getBigIconPath(), state, showLocks, showDetailIcon);
    }

    private static String getIconInnerHTML(CmsResourceUtil resUtil, String iconPath, CmsResourceState state, boolean showLocks, boolean showDetailIcon) {
        String content = "<img src=\"" + iconPath + "\" />";
        if (resUtil != null) {
            if (showDetailIcon && !iconPath.endsWith("navlevel_big.png")) {
                String smallIconUri;
                String detailType;
                if (resUtil.getResource().isFolder()) {
                    detailType = CmsResourceIcon.getDefaultFileOrDetailType(resUtil.getCms(), resUtil.getResource());
                    if (detailType != null && (smallIconUri = CmsResourceIcon.getSmallTypeIconURI(detailType)) != null) {
                        content = content + "<img src=\"" + smallIconUri + "\" class=\"o-icon-overlay\" />";
                    }
                } else if (CmsResourceTypeXmlContainerPage.isContainerPage(resUtil.getResource()) && (detailType = CmsResourceIcon.getDefaultFileOrDetailType(resUtil.getCms(), resUtil.getResource())) != null && (smallIconUri = CmsResourceIcon.getSmallTypeIconURI(detailType)) != null) {
                    content = content + "<img src=\"" + smallIconUri + "\" class=\"o-page-icon-overlay\" />";
                }
            }
            if (showLocks) {
                String lockIcon;
                String message = null;
                if (resUtil.getLock().getSystemLock().isPublish()) {
                    lockIcon = "o-lock-publish";
                    message = CmsVaadinUtils.getMessageText("GUI_PUBLISH_TOOLTIP_0", new Object[0]);
                } else {
                    switch (resUtil.getLockState()) {
                        case 1: {
                            lockIcon = "o-lock-other";
                            break;
                        }
                        case 2: {
                            lockIcon = "o-lock-shared";
                            break;
                        }
                        case 3: {
                            lockIcon = "o-lock-user";
                            break;
                        }
                        default: {
                            lockIcon = null;
                        }
                    }
                    if (lockIcon != null) {
                        message = CmsVaadinUtils.getMessageText("GUI_EXPLORER_LIST_ACTION_LOCK_NAME_2", resUtil.getLockedByName(), resUtil.getLockedInProjectName());
                    }
                }
                if (lockIcon != null) {
                    content = content + CmsResourceIcon.getOverlaySpan(lockIcon, message);
                }
            }
        }
        if (state != null) {
            String title;
            String string = title = resUtil != null ? CmsVaadinUtils.getMessageText("GUI_LABEL_USER_LAST_MODIFIED_0", new Object[0]) + " " + resUtil.getUserLastModified() : null;
            if (state.isChanged() || state.isDeleted()) {
                content = content + CmsResourceIcon.getOverlaySpan("o-state-changed", title);
            } else if (state.isNew()) {
                content = content + CmsResourceIcon.getOverlaySpan("o-state-new", title);
            }
        }
        if (resUtil != null && resUtil.getLinkType() == 1) {
            content = content + CmsResourceIcon.getOverlaySpan("o-sibling", null);
        }
        return content;
    }

    private static String getOverlaySpan(String cssClass, String title) {
        StringBuffer result = new StringBuffer();
        result.append("<span class=\"").append(cssClass).append("\"");
        if (title != null) {
            result.append(" title=\"").append(title).append("\"");
        }
        result.append("></span>");
        return result.toString();
    }

    private static String getSmallTypeIconURI(String type) {
        CmsExplorerTypeSettings typeSettings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(type);
        if (typeSettings == null && LOG.isWarnEnabled()) {
            LOG.warn((Object)("Could not read explorer type settings for " + type));
        }
        return typeSettings != null ? CmsWorkplace.getResourceUri("filetypes/" + typeSettings.getIcon()) : null;
    }

    public void initContent(CmsResourceUtil resUtil, CmsResourceState state, boolean showLocks, boolean showDetailIcon) {
        this.setValue(CmsResourceIcon.getIconInnerHTML(resUtil, state, showLocks, showDetailIcon));
    }

    public void initContent(CmsResourceUtil resUtil, String iconPath, CmsResourceState state, boolean showLocks, boolean showDetailIcon) {
        this.setValue(CmsResourceIcon.getIconInnerHTML(resUtil, iconPath, state, showLocks, showDetailIcon));
    }

    public static enum IconMode {
        localeCompare,
        sitemapSelect;

    }
}

