/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components;

import com.google.common.collect.Lists;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.FontIcon;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.MenuBar;
import com.vaadin.ui.PopupView;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.declarative.Design;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;
import org.opencms.ui.A_CmsDialogContext;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.CmsDefaultAppButtonProvider;
import org.opencms.ui.apps.I_CmsWorkplaceAppConfiguration;
import org.opencms.ui.components.CmsUploadButton;
import org.opencms.ui.components.CmsUserInfo;
import org.opencms.ui.contextmenu.CmsContextMenuTreeBuilder;
import org.opencms.ui.contextmenu.I_CmsContextMenuItem;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsTreeNode;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;

public class CmsToolBar
extends CssLayout
implements Page.BrowserWindowResizeListener {
    private static final Log LOG = CmsLog.getLog(CmsToolBar.class);
    private static final long serialVersionUID = -4551194983054069395L;
    private Label m_appIndicator;
    private boolean m_buttonsFolded;
    private MenuBar m_contextMenu;
    private I_CmsDialogContext m_dialogContext;
    private PopupView m_foldedButtonsMenu;
    private int m_foldingThreshhold;
    private HorizontalLayout m_itemsLeft;
    private HorizontalLayout m_itemsRight;
    private VerticalLayout m_leftButtons;
    private Component m_quickLaunchDropDown = this.createQuickLaunchDropDown();
    private VerticalLayout m_rightButtons;
    private Component m_userDropDown = this.createUserInfoDropDown();

    public CmsToolBar() {
        this.m_leftButtons = new VerticalLayout();
        this.m_rightButtons = new VerticalLayout();
        VerticalLayout layout = new VerticalLayout();
        layout.addComponent((Component)this.m_leftButtons);
        layout.addComponent((Component)this.m_rightButtons);
        this.m_foldedButtonsMenu = new PopupView(CmsToolBar.getDropDownButtonHtml(FontOpenCms.CONTEXT_MENU_DOTS), (Component)layout);
        this.m_foldedButtonsMenu.addStyleName("o-navigator-dropdown");
        this.m_foldedButtonsMenu.setHideOnMouseOut(false);
        Design.read((String)"CmsToolBar.html", (Component)this);
    }

    public static Button createButton(Resource icon, String title) {
        return CmsToolBar.createButton(icon, title, false);
    }

    public static Button createButton(Resource icon, String title, boolean alwaysShow) {
        Button button = new Button(icon);
        button.setDescription(title);
        button.addStyleName("borderless");
        button.addStyleName("o-toolbar-button");
        if (alwaysShow) {
            button.addStyleName("o-required-button");
        }
        return button;
    }

    public static Component createDropDown(ExternalResource icon, Component content, String title) {
        return CmsToolBar.createDropDown(CmsToolBar.getDropDownButtonHtml(icon), content, title);
    }

    public static Component createDropDown(FontIcon icon, Component content, String title) {
        return CmsToolBar.createDropDown(CmsToolBar.getDropDownButtonHtml(icon), content, title);
    }

    public static Component createDropDown(String buttonHtml, Component content, String title) {
        PopupView pv = new PopupView(buttonHtml, content);
        pv.setDescription(title);
        pv.addStyleName("o-navigator-dropdown");
        pv.setHideOnMouseOut(false);
        return pv;
    }

    static String getDropDownButtonHtml(ExternalResource icon) {
        return "<div tabindex=\"0\" role=\"button\" class=\"v-button v-widget borderless v-button-borderless o-toolbar-button v-button-o-toolbar-button\"><span class=\"v-button-wrap\"><img class=\"v-icon\" src=\"" + icon.getURL() + "\" /></span></div>";
    }

    static String getDropDownButtonHtml(FontIcon icon) {
        return "<div tabindex=\"0\" role=\"button\" class=\"v-button v-widget borderless v-button-borderless o-toolbar-button v-button-o-toolbar-button\"><span class=\"v-button-wrap\">" + icon.getHtml() + "</span></div>";
    }

    public void addButtonLeft(Component button) {
        if (this.m_buttonsFolded && !this.isAlwaysShow(button)) {
            this.m_leftButtons.addComponent(button);
        } else {
            this.m_itemsLeft.addComponent(button);
        }
        this.updateFoldingThreshhold();
    }

    public void addButtonRight(Component button) {
        if (this.m_buttonsFolded && !this.isAlwaysShow(button)) {
            this.m_rightButtons.addComponent(button);
        } else {
            int dropDownIndex = this.m_itemsRight.getComponentIndex(this.m_userDropDown);
            if (dropDownIndex >= 0) {
                this.m_itemsRight.addComponent(button, dropDownIndex);
            } else {
                this.m_itemsRight.addComponent(button);
            }
        }
        this.updateFoldingThreshhold();
    }

    public void browserWindowResized(Page.BrowserWindowResizeEvent event) {
        this.updateButtonVisibility(event.getWidth());
    }

    public void clearButtonsLeft() {
        this.m_itemsLeft.removeAllComponents();
        this.m_leftButtons.removeAllComponents();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_appIndicator.getValue())) {
            this.m_itemsLeft.addComponent((Component)this.m_appIndicator);
        }
        this.updateFoldingThreshhold();
    }

    public void clearButtonsRight() {
        this.m_itemsRight.removeAllComponents();
        this.m_rightButtons.removeAllComponents();
        this.updateFoldingThreshhold();
    }

    public void closePopupViews() {
        this.closePopupViews((AbstractOrderedLayout)this.m_itemsLeft);
        this.closePopupViews((AbstractOrderedLayout)this.m_itemsRight);
    }

    public void enableDefaultButtons(boolean enabled) {
        if (enabled) {
            this.m_itemsRight.addComponent((Component)this.m_contextMenu, 0);
            this.m_itemsRight.addComponent(this.m_quickLaunchDropDown, 1);
        } else {
            this.m_itemsRight.removeComponent((Component)this.m_contextMenu);
            this.m_itemsRight.removeComponent(this.m_quickLaunchDropDown);
        }
        this.updateFoldingThreshhold();
    }

    public void refreshUserInfoDropDown() {
        Component oldVersion = this.m_userDropDown;
        this.m_userDropDown = this.createUserInfoDropDown();
        this.m_itemsRight.replaceComponent(oldVersion, this.m_userDropDown);
    }

    public void removeButton(Component button) {
        this.m_itemsLeft.removeComponent(button);
        this.m_itemsRight.removeComponent(button);
        this.m_leftButtons.removeComponent(button);
        this.m_rightButtons.removeComponent(button);
        this.updateFoldingThreshhold();
    }

    public void setAppTitle(String appTitle) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(appTitle)) {
            this.m_appIndicator.setValue(appTitle);
            this.updateAppIndicator();
            this.m_appIndicator.setVisible(true);
        } else {
            this.m_appIndicator.setVisible(false);
        }
    }

    public void updateAppIndicator() {
        if (CmsAppWorkplaceUi.isOnlineProject()) {
            this.m_appIndicator.addStyleName("o-toolbar-app-indicator-online");
        } else {
            this.m_appIndicator.removeStyleName("o-toolbar-app-indicator-online");
        }
        CmsObject cms = A_CmsUI.getCmsObject();
        String siteRoot = cms.getRequestContext().getSiteRoot();
        CmsSite site = OpenCms.getSiteManager().getSiteForSiteRoot(siteRoot);
        String siteName = null;
        if (site != null) {
            siteName = site.getTitle();
        } else {
            try {
                CmsResource folder = cms.readResource("/", CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                siteName = OpenCms.getSiteManager().getSiteTitle(cms, folder);
            }
            catch (CmsException e) {
                LOG.warn((Object)"Error reading site title.", (Throwable)e);
            }
        }
        siteName = CmsStringUtil.isEmptyOrWhitespaceOnly(siteName) ? siteRoot : CmsWorkplace.substituteSiteTitleStatic(siteName, UI.getCurrent().getLocale());
        this.m_appIndicator.setDescription(CmsVaadinUtils.getMessageText("GUI_TOOLBAR_PROJECT_SITE_INFO_2", A_CmsUI.getCmsObject().getRequestContext().getCurrentProject().getName(), siteName));
    }

    protected void init(String appId) {
        this.m_dialogContext = new ToolbarContext(appId);
        this.initContextMenu();
        this.m_itemsRight.addComponent(this.m_quickLaunchDropDown);
        this.m_itemsRight.addComponent(this.m_userDropDown);
    }

    protected void setDialogContext(I_CmsDialogContext context) {
        this.m_dialogContext = context;
        this.initContextMenu();
    }

    protected void updateButtonVisibility(int width) {
        if (!this.m_buttonsFolded && this.m_foldingThreshhold > width) {
            this.foldButtons();
        } else if (this.m_buttonsFolded && width > this.m_foldingThreshhold) {
            this.unfoldButtons();
        }
    }

    protected void updateFoldingThreshhold() {
        int right;
        int requiredWidth;
        int left = this.estimateRequiredWidth((AbstractOrderedLayout)this.m_itemsLeft) + this.estimateRequiredWidth((AbstractOrderedLayout)this.m_leftButtons);
        int n = requiredWidth = left > (right = this.estimateRequiredWidth((AbstractOrderedLayout)this.m_itemsRight) + this.estimateRequiredWidth((AbstractOrderedLayout)this.m_rightButtons)) ? left : right;
        this.m_foldingThreshhold = requiredWidth < 350 ? 0 : (requiredWidth < 400 ? 984 : (requiredWidth <= 520 ? 1240 : 10000));
        this.updateButtonVisibility(Page.getCurrent().getBrowserWindowWidth());
    }

    I_CmsDialogContext getDialogContext() {
        return this.m_dialogContext;
    }

    void handleUpload(List<String> uploadedFiles) {
        CmsObject cms = A_CmsUI.getCmsObject();
        boolean success = OpenCms.getWorkplaceAppManager().getUserIconHelper().handleImageUpload(cms, uploadedFiles);
        if (success) {
            this.refreshUserInfoDropDown();
        }
    }

    private void closePopupViews(AbstractOrderedLayout layout) {
        for (Component item : layout) {
            if (!(item instanceof PopupView)) continue;
            ((PopupView)item).setPopupVisible(false);
        }
    }

    private void createMenuEntry(MenuBar.MenuItem parent, final CmsTreeNode<I_CmsContextMenuItem> node, CmsContextMenuTreeBuilder treeBuilder) {
        MenuBar.Command entryCommand = null;
        if (node.getChildren().size() == 0) {
            entryCommand = new MenuBar.Command(){
                private static final long serialVersionUID = 1L;

                public void menuSelected(MenuBar.MenuItem selectedItem) {
                    ((I_CmsContextMenuItem)node.getData()).executeAction(CmsToolBar.this.getDialogContext());
                }
            };
        }
        MenuBar.MenuItem entry = parent.addItem(node.getData().getTitle(A_CmsUI.get().getLocale()), entryCommand);
        for (CmsTreeNode<I_CmsContextMenuItem> child : node.getChildren()) {
            this.createMenuEntry(entry, child, treeBuilder);
        }
        if (treeBuilder.getVisibility(node.getData()).isInActive()) {
            entry.setEnabled(false);
        }
    }

    private Component createQuickLaunchDropDown() {
        PopupView pv = new PopupView(new PopupView.Content(){
            private static final long serialVersionUID = 1L;

            public String getMinimizedValueAsHTML() {
                return CmsToolBar.getDropDownButtonHtml(FontOpenCms.APPS);
            }

            public Component getPopupComponent() {
                CmsObject cms = A_CmsUI.getCmsObject();
                Locale locale = UI.getCurrent().getLocale();
                HorizontalLayout layout = new HorizontalLayout();
                layout.addStyleName("wrapping");
                layout.addStyleName("o-quicklaunch");
                layout.setMargin(true);
                for (I_CmsWorkplaceAppConfiguration config : OpenCms.getWorkplaceAppManager().getQuickLaunchConfigurations(cms)) {
                    layout.addComponent(CmsDefaultAppButtonProvider.createAppButton(cms, config, locale));
                }
                return layout;
            }
        });
        pv.setDescription(CmsVaadinUtils.getMessageText("GUI_QUICK_LAUNCH_TITLE_0", new Object[0]));
        pv.addStyleName("o-navigator-dropdown");
        pv.setHideOnMouseOut(false);
        return pv;
    }

    private Component createUserInfoDropDown() {
        PopupView pv = new PopupView(new PopupView.Content(){
            private static final long serialVersionUID = 1L;

            public String getMinimizedValueAsHTML() {
                CmsObject cms = A_CmsUI.getCmsObject();
                return CmsToolBar.getDropDownButtonHtml(new ExternalResource(OpenCms.getWorkplaceAppManager().getUserIconHelper().getSmallIconPath(cms, cms.getRequestContext().getCurrentUser())));
            }

            public Component getPopupComponent() {
                return new CmsUserInfo(new CmsUploadButton.I_UploadListener(){

                    @Override
                    public void onUploadFinished(List<String> uploadedFiles) {
                        CmsToolBar.this.handleUpload(uploadedFiles);
                    }
                }, CmsToolBar.this.getDialogContext());
            }
        });
        pv.setDescription(CmsVaadinUtils.getMessageText("GUI_USER_INFO_TITLE_0", new Object[0]));
        pv.addStyleName("o-navigator-dropdown");
        pv.setHideOnMouseOut(false);
        pv.addStyleName("o-user-info");
        return pv;
    }

    private int estimateRequiredWidth(AbstractOrderedLayout items) {
        int result = 0;
        if (items != null) {
            for (Component comp : items) {
                if (comp == this.m_foldedButtonsMenu) continue;
                if (comp instanceof Button || comp instanceof PopupView || comp instanceof MenuBar) {
                    result += 50;
                    continue;
                }
                if (comp == this.m_appIndicator) {
                    result += 50;
                    continue;
                }
                float compWidth = comp.getWidth();
                if (compWidth > 0.0f && comp.getWidthUnits() == Sizeable.Unit.PIXELS) {
                    result = (int)((float)result + (compWidth + 10.0f));
                    continue;
                }
                result += 200;
            }
        }
        return result;
    }

    private void foldButtons() {
        Component comp;
        int i;
        VerticalLayout mainPV = (VerticalLayout)this.m_foldedButtonsMenu.getContent().getPopupComponent();
        for (i = this.m_itemsLeft.getComponentCount() - 1; i > -1; --i) {
            comp = this.m_itemsLeft.getComponent(i);
            if (this.isAlwaysShow(comp)) continue;
            this.m_itemsLeft.removeComponent(comp);
            this.m_leftButtons.addComponent(comp, 0);
            this.m_leftButtons.setComponentAlignment(comp, Alignment.MIDDLE_CENTER);
        }
        if (this.m_leftButtons.getComponentCount() == 0) {
            mainPV.removeComponent((Component)this.m_leftButtons);
        } else {
            mainPV.addComponent((Component)this.m_leftButtons, 0);
        }
        for (i = this.m_itemsRight.getComponentCount() - 1; i > -1; --i) {
            comp = this.m_itemsRight.getComponent(i);
            if (this.isAlwaysShow(comp)) continue;
            this.m_itemsRight.removeComponent(comp);
            this.m_rightButtons.addComponent(comp, 0);
            this.m_rightButtons.setComponentAlignment(comp, Alignment.MIDDLE_CENTER);
        }
        if (this.m_rightButtons.getComponentCount() == 0) {
            mainPV.removeComponent((Component)this.m_rightButtons);
        } else {
            mainPV.addComponent((Component)this.m_rightButtons);
        }
        this.m_itemsRight.addComponent((Component)this.m_foldedButtonsMenu, 0);
        this.m_buttonsFolded = true;
        this.markAsDirtyRecursive();
    }

    private void initContextMenu() {
        this.m_contextMenu.removeItems();
        MenuBar.MenuItem main = this.m_contextMenu.addItem("", null);
        main.setIcon((Resource)FontOpenCms.CONTEXT_MENU);
        main.setDescription(CmsVaadinUtils.getMessageText("GUI_MENU_TITLE_0", new Object[0]));
        CmsContextMenuTreeBuilder treeBuilder = new CmsContextMenuTreeBuilder(this.getDialogContext());
        CmsTreeNode<I_CmsContextMenuItem> tree = treeBuilder.buildAll(OpenCms.getWorkplaceAppManager().getMenuItemProvider().getMenuItems());
        for (CmsTreeNode<I_CmsContextMenuItem> node : tree.getChildren()) {
            this.createMenuEntry(main, node, treeBuilder);
        }
    }

    private boolean isAlwaysShow(Component comp) {
        return comp == this.m_appIndicator || comp == this.m_contextMenu || comp == this.m_userDropDown || comp == this.m_quickLaunchDropDown || comp.getStyleName().contains("o-required-button");
    }

    private void unfoldButtons() {
        this.m_itemsRight.removeComponent((Component)this.m_foldedButtonsMenu);
        while (this.m_leftButtons.getComponentCount() > 0) {
            Component comp = this.m_leftButtons.getComponent(0);
            if (this.isAlwaysShow(comp)) continue;
            this.m_leftButtons.removeComponent(comp);
            this.m_itemsLeft.addComponent(comp);
        }
        int index = 0;
        while (this.m_rightButtons.getComponentCount() > 0) {
            Component comp = this.m_rightButtons.getComponent(0);
            this.m_rightButtons.removeComponent(comp);
            this.m_itemsRight.addComponent(comp, index);
            ++index;
        }
        this.m_buttonsFolded = false;
        this.markAsDirtyRecursive();
    }

    protected class ToolbarContext
    extends A_CmsDialogContext {
        protected ToolbarContext(String appId) {
            super(appId, I_CmsDialogContext.ContextType.appToolbar, Collections.emptyList());
        }

        @Override
        public void focus(CmsUUID structureId) {
        }

        @Override
        public List<CmsUUID> getAllStructureIdsInView() {
            return Lists.newArrayList();
        }

        @Override
        public void updateUserInfo() {
            CmsToolBar.this.refreshUserInfoDropDown();
        }
    }
}

