/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.contextmenu;

import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.ui.contextmenu.I_CmsHasMenuItemVisibility;
import org.opencms.workplace.explorer.menu.CmsMenuItemVisibilityMode;

public abstract class A_CmsSimpleVisibilityCheck
implements I_CmsHasMenuItemVisibility {
    protected boolean m_singleResourceOnly;

    public abstract CmsMenuItemVisibilityMode getSingleVisibility(CmsObject var1, CmsResource var2);

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        if (resources.size() <= 1) {
            return this.getSingleVisibility(cms, resources.size() == 1 ? resources.get(0) : null);
        }
        if (this.m_singleResourceOnly) {
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
        CmsMenuItemVisibilityMode currentVisibility = null;
        for (CmsResource resource : resources) {
            CmsMenuItemVisibilityMode visibilityForResource = this.getSingleVisibility(cms, resource);
            if (currentVisibility != null && this.getPriority(visibilityForResource) <= this.getPriority(currentVisibility)) continue;
            currentVisibility = visibilityForResource;
        }
        if (currentVisibility == null) {
            currentVisibility = CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
        }
        if (currentVisibility.isInActive()) {
            currentVisibility = CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
        return currentVisibility;
    }

    private int getPriority(CmsMenuItemVisibilityMode mode) {
        if (mode.isPrioritized()) {
            return 4;
        }
        if (mode.isInActive()) {
            return 0;
        }
        if (mode.isActive()) {
            return 1;
        }
        return 2;
    }
}

