/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.contextmenu;

import com.vaadin.event.ItemClickEvent;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.AbstractExtension;
import com.vaadin.server.Resource;
import com.vaadin.ui.Component;
import com.vaadin.ui.Table;
import com.vaadin.ui.Tree;
import com.vaadin.ui.UI;
import com.vaadin.util.ReflectTools;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.contextmenu.I_CmsSimpleContextMenuEntry;
import org.opencms.ui.shared.CmsContextMenuState;
import org.opencms.ui.shared.rpc.I_CmsContextMenuClientRpc;
import org.opencms.ui.shared.rpc.I_CmsContextMenuServerRpc;
import org.opencms.workplace.explorer.menu.CmsMenuItemVisibilityMode;

public class CmsContextMenu
extends AbstractExtension {
    private static final long serialVersionUID = 4275181115413786498L;
    final Map<String, ContextMenuItem> m_items;
    private final I_CmsContextMenuServerRpc m_serverRPC = new I_CmsContextMenuServerRpc(){
        private static final long serialVersionUID = 5622864428554337992L;

        @Override
        public void contextMenuClosed() {
            CmsContextMenu.this.fireEvent(new ContextMenuClosedEvent(CmsContextMenu.this));
        }

        @Override
        public void itemClicked(String itemId, boolean menuClosed) {
            ContextMenuItem item = CmsContextMenu.this.m_items.get(itemId);
            if (item == null) {
                return;
            }
            item.notifyClickListeners();
            CmsContextMenu.this.fireEvent(new ContextMenuItemClickEvent(item));
        }

        @Override
        public void onContextMenuOpenRequested(int x, int y, String connectorId) {
            CmsContextMenu.this.fireEvent(new ContextMenuOpenedOnComponentEvent(CmsContextMenu.this, x, y, (Component)UI.getCurrent().getConnectorTracker().getConnector(connectorId)));
        }
    };

    public CmsContextMenu() {
        this.registerRpc(this.m_serverRPC);
        this.m_items = new HashMap<String, ContextMenuItem>();
        this.setOpenAutomatically(true);
        this.setHideAutomatically(true);
    }

    public void addContextMenuCloseListener(ContextMenuClosedListener contextMenuClosedListener) {
        this.addListener(ContextMenuClosedEvent.class, contextMenuClosedListener, ContextMenuClosedListener.MENU_CLOSED);
    }

    public void addContextMenuComponentListener(ContextMenuOpenedListener.ComponentListener contextMenuComponentListener) {
        this.addListener(ContextMenuOpenedOnComponentEvent.class, contextMenuComponentListener, ContextMenuOpenedListener.ComponentListener.MENU_OPENED_FROM_COMPONENT);
    }

    public void addContextMenuTableListener(ContextMenuOpenedListener.TableListener contextMenuTableListener) {
        this.addListener(ContextMenuOpenedOnTableRowEvent.class, contextMenuTableListener, ContextMenuOpenedListener.TableListener.MENU_OPENED_FROM_TABLE_ROW_METHOD);
        this.addListener(ContextMenuOpenedOnTableHeaderEvent.class, contextMenuTableListener, ContextMenuOpenedListener.TableListener.MENU_OPENED_FROM_TABLE_HEADER_METHOD);
        this.addListener(ContextMenuOpenedOnTableFooterEvent.class, contextMenuTableListener, ContextMenuOpenedListener.TableListener.MENU_OPENED_FROM_TABLE_FOOTER_METHOD);
    }

    public void addContextMenuTreeListener(ContextMenuOpenedListener.TreeListener contextMenuTreeListener) {
        this.addListener(ContextMenuOpenedOnTreeItemEvent.class, contextMenuTreeListener, ContextMenuOpenedListener.TreeListener.MENU_OPENED_FROM_TREE_ITEM_METHOD);
    }

    public ContextMenuItem addItem(Resource icon) {
        ContextMenuItem item = this.addItem("");
        item.setIcon(icon);
        return item;
    }

    public ContextMenuItem addItem(String caption) {
        CmsContextMenuState.ContextMenuItemState itemState = this.getState().addChild(caption, this.getNextId());
        ContextMenuItem item = new ContextMenuItem(null, itemState);
        this.m_items.put(itemState.getId(), item);
        return item;
    }

    public ContextMenuItem addItem(String caption, Resource icon) {
        ContextMenuItem item = this.addItem(caption);
        item.setIcon(icon);
        return item;
    }

    public void addItemClickListener(ContextMenuItemClickListener clickListener) {
        this.addListener(ContextMenuItemClickEvent.class, clickListener, ContextMenuItemClickListener.ITEM_CLICK_METHOD);
    }

    public void extend(AbstractClientConnector target) {
        super.extend(target);
    }

    public void hide() {
        ((I_CmsContextMenuClientRpc)this.getRpcProxy(I_CmsContextMenuClientRpc.class)).hide();
    }

    public boolean isHideAutomatically() {
        return this.getState().isHideAutomatically();
    }

    public boolean isOpenAutomatically() {
        return this.getState().isOpenAutomatically();
    }

    public void open(Component component) {
        ((I_CmsContextMenuClientRpc)this.getRpcProxy(I_CmsContextMenuClientRpc.class)).showContextMenuRelativeTo(component.getConnectorId());
    }

    public void open(int x, int y) {
        ((I_CmsContextMenuClientRpc)this.getRpcProxy(I_CmsContextMenuClientRpc.class)).showContextMenu(x, y);
    }

    public void openForTable(ItemClickEvent event, Table table) {
        this.fireEvent(new ContextMenuOpenedOnTableRowEvent(this, table, event.getItemId(), event.getPropertyId()));
        this.open(event.getClientX(), event.getClientY());
    }

    public void openForTree(ItemClickEvent event, Tree tree) {
        this.fireEvent(new ContextMenuOpenedOnTreeItemEvent(this, tree, event.getItemId()));
        this.open(event.getClientX(), event.getClientY());
    }

    public void removeAllItems() {
        this.m_items.clear();
        this.getState().getRootItems().clear();
    }

    public void removeItem(ContextMenuItem contextMenuItem) {
        if (!this.hasMenuItem(contextMenuItem)) {
            return;
        }
        if (contextMenuItem.isRootItem()) {
            this.getState().getRootItems().remove(contextMenuItem.m_state);
        } else {
            ContextMenuItem parent = contextMenuItem.getParent();
            parent.m_state.getChildren().remove(contextMenuItem.m_state);
        }
        Set<ContextMenuItem> children = contextMenuItem.getAllChildren();
        this.m_items.remove(contextMenuItem.m_state.getId());
        for (ContextMenuItem child : children) {
            this.m_items.remove(child.m_state.getId());
        }
        this.markAsDirty();
    }

    public void setAsContextMenuOf(AbstractClientConnector component) {
        if (component instanceof Table) {
            this.setAsTableContextMenu((Table)component);
        } else if (component instanceof Tree) {
            this.setAsTreeContextMenu((Tree)component);
        } else {
            super.extend(component);
        }
    }

    public void setAsTableContextMenu(Table table) {
        this.extend((AbstractClientConnector)table);
        this.setOpenAutomatically(false);
    }

    public void setAsTreeContextMenu(Tree tree) {
        this.extend((AbstractClientConnector)tree);
        this.setOpenAutomatically(false);
    }

    public <T> void setEntries(Collection<I_CmsSimpleContextMenuEntry<T>> entries, T data) {
        this.removeAllItems();
        Locale locale = UI.getCurrent().getLocale();
        for (final I_CmsSimpleContextMenuEntry<T> entry : entries) {
            CmsMenuItemVisibilityMode visibility = entry.getVisibility(data);
            if (visibility.isInVisible()) continue;
            ContextMenuItem item = this.addItem(entry.getTitle(locale));
            if (visibility.isInActive()) {
                item.setEnabled(false);
                if (visibility.getMessageKey() != null) {
                    item.setDescription(CmsVaadinUtils.getMessageText(visibility.getMessageKey(), new Object[0]));
                }
            } else {
                item.setData(data);
                item.addItemClickListener(new ContextMenuItemClickListener(){

                    @Override
                    public void contextMenuItemClicked(ContextMenuItemClickEvent event) {
                        entry.executeAction(((ContextMenuItem)event.getSource()).getData());
                    }
                });
            }
            if (!(entry instanceof I_CmsSimpleContextMenuEntry.I_HasCssStyles)) continue;
            item.addStyleName(((I_CmsSimpleContextMenuEntry.I_HasCssStyles)((Object)entry)).getStyles());
        }
    }

    public void setHideAutomatically(boolean hideAutomatically) {
        this.getState().setHideAutomatically(hideAutomatically);
    }

    public void setOpenAutomatically(boolean openAutomatically) {
        this.getState().setOpenAutomatically(openAutomatically);
    }

    protected void fireEvent(EventObject event) {
        super.fireEvent(event);
    }

    protected String getNextId() {
        return UUID.randomUUID().toString();
    }

    protected Resource getResource(String key) {
        return super.getResource(key);
    }

    protected CmsContextMenuState getState() {
        return (CmsContextMenuState)super.getState();
    }

    protected void setResource(String key, Resource resource) {
        super.setResource(key, resource);
    }

    private boolean hasMenuItem(ContextMenuItem contextMenuItem) {
        return this.m_items.containsKey(contextMenuItem.m_state.getId());
    }

    public static class ContextMenuOpenedOnTreeItemEvent
    extends EventObject {
        private static final long serialVersionUID = -7705205542849351984L;
        private final CmsContextMenu m_contextMenu;
        private final Object m_itemId;

        public ContextMenuOpenedOnTreeItemEvent(CmsContextMenu contextMenu, Tree tree, Object itemId) {
            super(tree);
            this.m_contextMenu = contextMenu;
            this.m_itemId = itemId;
        }

        public CmsContextMenu getContextMenu() {
            return this.m_contextMenu;
        }

        public Object getItemId() {
            return this.m_itemId;
        }
    }

    public static class ContextMenuOpenedOnTableRowEvent
    extends EventObject {
        private static final long serialVersionUID = -470218301318358912L;
        private final CmsContextMenu m_contextMenu;
        private final Object m_itemId;
        private final Object m_propertyId;

        public ContextMenuOpenedOnTableRowEvent(CmsContextMenu contextMenu, Table table, Object itemId, Object propertyId) {
            super(table);
            this.m_contextMenu = contextMenu;
            this.m_itemId = itemId;
            this.m_propertyId = propertyId;
        }

        public CmsContextMenu getContextMenu() {
            return this.m_contextMenu;
        }

        public Object getItemId() {
            return this.m_itemId;
        }

        public Object getPropertyId() {
            return this.m_propertyId;
        }
    }

    public static class ContextMenuOpenedOnTableHeaderEvent
    extends EventObject {
        private static final long serialVersionUID = -1220618848356241248L;
        private final CmsContextMenu m_contextMenu;
        private final Object m_propertyId;

        public ContextMenuOpenedOnTableHeaderEvent(CmsContextMenu contextMenu, Table sourceTable, Object propertyId) {
            super(sourceTable);
            this.m_contextMenu = contextMenu;
            this.m_propertyId = propertyId;
        }

        public CmsContextMenu getContextMenu() {
            return this.m_contextMenu;
        }

        public Object getPropertyId() {
            return this.m_propertyId;
        }
    }

    public static class ContextMenuOpenedOnTableFooterEvent
    extends EventObject {
        private static final long serialVersionUID = 1999781663913723438L;
        private final CmsContextMenu m_contextMenu;
        private final Object m_propertyId;

        public ContextMenuOpenedOnTableFooterEvent(CmsContextMenu contextMenu, Table sourceTable, Object propertyId) {
            super(sourceTable);
            this.m_contextMenu = contextMenu;
            this.m_propertyId = propertyId;
        }

        public CmsContextMenu getContextMenu() {
            return this.m_contextMenu;
        }

        public Object getPropertyId() {
            return this.m_propertyId;
        }
    }

    public static class ContextMenuOpenedOnComponentEvent
    extends EventObject {
        private static final long serialVersionUID = 947108059398706966L;
        private final CmsContextMenu m_contextMenu;
        private final int m_x;
        private final int m_y;

        public ContextMenuOpenedOnComponentEvent(CmsContextMenu contextMenu, int x, int y, Component component) {
            super(component);
            this.m_contextMenu = contextMenu;
            this.m_x = x;
            this.m_y = y;
        }

        public CmsContextMenu getContextMenu() {
            return this.m_contextMenu;
        }

        public Component getRequestSourceComponent() {
            return (Component)this.getSource();
        }

        public int getX() {
            return this.m_x;
        }

        public int getY() {
            return this.m_y;
        }
    }

    public static interface ContextMenuOpenedListener
    extends EventListener {

        public static interface TreeListener
        extends ContextMenuOpenedListener {
            public static final Method MENU_OPENED_FROM_TREE_ITEM_METHOD = ReflectTools.findMethod(TreeListener.class, (String)"onContextMenuOpenFromTreeItem", (Class[])new Class[]{ContextMenuOpenedOnTreeItemEvent.class});

            public void onContextMenuOpenFromTreeItem(ContextMenuOpenedOnTreeItemEvent var1);
        }

        public static interface TableListener
        extends ContextMenuOpenedListener {
            public static final Method MENU_OPENED_FROM_TABLE_FOOTER_METHOD = ReflectTools.findMethod(TableListener.class, (String)"onContextMenuOpenFromFooter", (Class[])new Class[]{ContextMenuOpenedOnTableFooterEvent.class});
            public static final Method MENU_OPENED_FROM_TABLE_HEADER_METHOD = ReflectTools.findMethod(TableListener.class, (String)"onContextMenuOpenFromHeader", (Class[])new Class[]{ContextMenuOpenedOnTableHeaderEvent.class});
            public static final Method MENU_OPENED_FROM_TABLE_ROW_METHOD = ReflectTools.findMethod(TableListener.class, (String)"onContextMenuOpenFromRow", (Class[])new Class[]{ContextMenuOpenedOnTableRowEvent.class});

            public void onContextMenuOpenFromFooter(ContextMenuOpenedOnTableFooterEvent var1);

            public void onContextMenuOpenFromHeader(ContextMenuOpenedOnTableHeaderEvent var1);

            public void onContextMenuOpenFromRow(ContextMenuOpenedOnTableRowEvent var1);
        }

        public static interface ComponentListener
        extends ContextMenuOpenedListener {
            public static final Method MENU_OPENED_FROM_COMPONENT = ReflectTools.findMethod(ComponentListener.class, (String)"onContextMenuOpenFromComponent", (Class[])new Class[]{ContextMenuOpenedOnComponentEvent.class});

            public void onContextMenuOpenFromComponent(ContextMenuOpenedOnComponentEvent var1);
        }
    }

    public static interface ContextMenuItemClickListener
    extends EventListener {
        public static final Method ITEM_CLICK_METHOD = ReflectTools.findMethod(ContextMenuItemClickListener.class, (String)"contextMenuItemClicked", (Class[])new Class[]{ContextMenuItemClickEvent.class});

        public void contextMenuItemClicked(ContextMenuItemClickEvent var1);
    }

    public static class ContextMenuItemClickEvent
    extends EventObject {
        private static final long serialVersionUID = -3301204853129409248L;

        public ContextMenuItemClickEvent(Object component) {
            super(component);
        }
    }

    public class ContextMenuItem
    implements Serializable {
        private static final long serialVersionUID = -6514832427611690050L;
        final CmsContextMenuState.ContextMenuItemState m_state;
        private final List<ContextMenuItemClickListener> m_clickListeners;
        private Object m_data;
        private ContextMenuItem m_parent;

        protected ContextMenuItem(ContextMenuItem parent, CmsContextMenuState.ContextMenuItemState itemState) {
            this.m_parent = parent;
            if (itemState == null) {
                throw new NullPointerException("Context menu item state must not be null");
            }
            this.m_clickListeners = new ArrayList<ContextMenuItemClickListener>();
            this.m_state = itemState;
        }

        public ContextMenuItem addItem(Resource icon) {
            ContextMenuItem item = this.addItem("");
            item.setIcon(icon);
            return item;
        }

        public ContextMenuItem addItem(String caption) {
            CmsContextMenuState.ContextMenuItemState childItemState = this.m_state.addChild(caption, CmsContextMenu.this.getNextId());
            ContextMenuItem item = new ContextMenuItem(this, childItemState);
            CmsContextMenu.this.m_items.put(childItemState.getId(), item);
            CmsContextMenu.this.markAsDirty();
            return item;
        }

        public ContextMenuItem addItem(String caption, Resource icon) {
            ContextMenuItem item = this.addItem(caption);
            item.setIcon(icon);
            return item;
        }

        public void addItemClickListener(ContextMenuItemClickListener clickListener) {
            this.m_clickListeners.add(clickListener);
        }

        public void addStyleName(String style) {
            if (style == null || style.isEmpty()) {
                return;
            }
            if (style.contains(" ")) {
                StringTokenizer tokenizer = new StringTokenizer(style, " ");
                while (tokenizer.hasMoreTokens()) {
                    this.addStyleName(tokenizer.nextToken());
                }
                return;
            }
            this.m_state.getStyles().add(style);
            CmsContextMenu.this.markAsDirty();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof ContextMenuItem) {
                return this.m_state.getId().equals(((ContextMenuItem)other).m_state.getId());
            }
            return false;
        }

        public Object getData() {
            return this.m_data;
        }

        public String getDescription() {
            return this.m_state.getDescription();
        }

        public Resource getIcon() {
            return CmsContextMenu.this.getResource(this.m_state.getId());
        }

        public int hashCode() {
            return this.m_state.getId().hashCode();
        }

        public boolean hasSeparator() {
            return this.m_state.isSeparator();
        }

        public boolean hasSubMenu() {
            return this.m_state.getChildren().size() > 0;
        }

        public boolean isEnabled() {
            return this.m_state.isEnabled();
        }

        public boolean isRootItem() {
            return this.m_parent == null;
        }

        public void removeItemClickListener(ContextMenuItemClickListener clickListener) {
            this.m_clickListeners.remove(clickListener);
        }

        public void removeStyleName(String style) {
            if (this.m_state.getStyles().isEmpty()) {
                return;
            }
            StringTokenizer tokenizer = new StringTokenizer(style, " ");
            while (tokenizer.hasMoreTokens()) {
                this.m_state.getStyles().remove(tokenizer.nextToken());
            }
        }

        public void setCaption(String newCaption) {
            this.m_state.setCaption(newCaption);
            CmsContextMenu.this.markAsDirty();
        }

        public void setData(Object data) {
            this.m_data = data;
        }

        public void setDescription(String description) {
            this.m_state.setDescription(description);
            CmsContextMenu.this.markAsDirty();
        }

        public void setEnabled(boolean enabled) {
            this.m_state.setEnabled(enabled);
            CmsContextMenu.this.markAsDirty();
        }

        public void setIcon(Resource icon) {
            CmsContextMenu.this.setResource(this.m_state.getId(), icon);
        }

        public void setSeparatorVisible(boolean separatorVisible) {
            this.m_state.setSeparator(separatorVisible);
            CmsContextMenu.this.markAsDirty();
        }

        protected Set<ContextMenuItem> getAllChildren() {
            HashSet<ContextMenuItem> children = new HashSet<ContextMenuItem>();
            for (CmsContextMenuState.ContextMenuItemState childState : this.m_state.getChildren()) {
                ContextMenuItem child = CmsContextMenu.this.m_items.get(childState.getId());
                children.add(child);
                children.addAll(child.getAllChildren());
            }
            return children;
        }

        protected ContextMenuItem getParent() {
            return this.m_parent;
        }

        protected void notifyClickListeners() {
            for (ContextMenuItemClickListener clickListener : this.m_clickListeners) {
                clickListener.contextMenuItemClicked(new ContextMenuItemClickEvent(this));
            }
        }
    }

    public static interface ContextMenuClosedListener
    extends EventListener {
        public static final Method MENU_CLOSED = ReflectTools.findMethod(ContextMenuClosedListener.class, (String)"onContextMenuClosed", (Class[])new Class[]{ContextMenuClosedEvent.class});

        public void onContextMenuClosed(ContextMenuClosedEvent var1);
    }

    public static class ContextMenuClosedEvent
    extends EventObject {
        private static final long serialVersionUID = -5705205542849351984L;
        private final CmsContextMenu m_contextMenu;

        public ContextMenuClosedEvent(CmsContextMenu contextMenu) {
            super((Object)contextMenu);
            this.m_contextMenu = contextMenu;
        }

        public CmsContextMenu getContextMenu() {
            return this.m_contextMenu;
        }
    }
}

