/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.contextmenu;

import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.contextmenu.CmsContextMenu;
import org.opencms.ui.contextmenu.CmsContextMenuTreeBuilder;
import org.opencms.ui.contextmenu.I_CmsContextMenuBuilder;
import org.opencms.ui.contextmenu.I_CmsContextMenuItem;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsTreeNode;

public class CmsResourceContextMenuBuilder
implements I_CmsContextMenuBuilder {
    private CmsContextMenuTreeBuilder m_treeBuilder;

    @Override
    public void buildContextMenu(I_CmsDialogContext context, CmsContextMenu menu) {
        CmsContextMenuTreeBuilder treeBuilder;
        this.m_treeBuilder = treeBuilder = new CmsContextMenuTreeBuilder(context);
        CmsTreeNode<I_CmsContextMenuItem> tree = treeBuilder.buildAll(OpenCms.getWorkplaceAppManager().getMenuItemProvider().getMenuItems());
        I_CmsContextMenuItem defaultActionItem = treeBuilder.getDefaultActionItem();
        for (CmsTreeNode<I_CmsContextMenuItem> node : tree.getChildren()) {
            this.createItem((Object)menu, node, context, defaultActionItem);
        }
    }

    String getTitle(I_CmsContextMenuItem item) {
        return CmsVaadinUtils.localizeString(item.getTitle(A_CmsUI.get().getLocale()));
    }

    private CmsContextMenu.ContextMenuItem createItem(Object parent, CmsTreeNode<I_CmsContextMenuItem> node, final I_CmsDialogContext context, I_CmsContextMenuItem defaultAction) {
        final I_CmsContextMenuItem data = node.getData();
        CmsContextMenu.ContextMenuItem guiMenuItem = null;
        guiMenuItem = parent instanceof CmsContextMenu ? ((CmsContextMenu)((Object)parent)).addItem(this.getTitle(data)) : ((CmsContextMenu.ContextMenuItem)parent).addItem(this.getTitle(data));
        if (this.m_treeBuilder.getVisibility(data).isInActive()) {
            guiMenuItem.setEnabled(false);
            String key = this.m_treeBuilder.getVisibility(data).getMessageKey();
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(key)) {
                guiMenuItem.setDescription(CmsVaadinUtils.getMessageText(key, new Object[0]));
            }
        }
        if (node.getChildren().size() > 0) {
            for (CmsTreeNode<I_CmsContextMenuItem> childNode : node.getChildren()) {
                this.createItem(guiMenuItem, childNode, context, defaultAction);
            }
        } else {
            guiMenuItem.addItemClickListener(new CmsContextMenu.ContextMenuItemClickListener(){

                @Override
                public void contextMenuItemClicked(CmsContextMenu.ContextMenuItemClickEvent event) {
                    data.executeAction(context);
                }
            });
        }
        if (data.equals(defaultAction)) {
            guiMenuItem.addStyleName("bold");
        }
        return guiMenuItem;
    }
}

