/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dataview;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.IndexedContainer;
import com.vaadin.event.ShortcutListener;
import com.vaadin.server.ClientConnector;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Table;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.dataview.CmsColumnValueConverter;
import org.opencms.ui.dataview.CmsPagingControls;
import org.opencms.ui.util.CmsComponentField;
import org.opencms.widgets.dataview.CmsDataViewColumn;
import org.opencms.widgets.dataview.CmsDataViewFilter;
import org.opencms.widgets.dataview.CmsDataViewQuery;
import org.opencms.widgets.dataview.CmsDataViewResult;
import org.opencms.widgets.dataview.I_CmsDataView;
import org.opencms.widgets.dataview.I_CmsDataViewItem;

public class CmsDataViewPanel
extends VerticalLayout {
    private static final long serialVersionUID = 1L;
    public static final Object ID_COLUMN = new Object();
    private I_CmsDataView m_dataView;
    private Button m_searchButton;
    private IndexedContainer m_container;
    private CmsPagingControls m_pagingControls;
    private CssLayout m_tablePlaceholder;
    private HorizontalLayout m_filterContainer;
    private TextField m_fullTextSearch;
    protected Object m_sortCol;
    protected boolean m_ascending;
    private List<CmsDataViewFilter> m_filters = Lists.newArrayList();
    private Map<Object, CheckBox> m_checkBoxes = Maps.newHashMap();
    private Map<String, CmsDataViewFilter> m_filterMap = Maps.newLinkedHashMap();
    private CmsComponentField<Table> m_table = CmsComponentField.newInstance();
    private boolean m_recursiveValueChange;
    private Set<Object> m_realSelection = Sets.newHashSet();

    public CmsDataViewPanel(I_CmsDataView viewInstance, boolean multiselect) {
        this.m_dataView = viewInstance;
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_pagingControls.addCallback(new CmsPagingControls.I_PagingCallback(){

            @Override
            public void pageChanged(int page) {
                CmsDataViewPanel.this.refreshData(false, null);
            }
        });
        this.m_fullTextSearch.addShortcutListener(new ShortcutListener("Save", 13, null){
            private static final long serialVersionUID = 1L;

            public void handleAction(Object sender, Object target) {
                CmsDataViewPanel.this.refreshData(false, null);
            }
        });
        this.m_searchButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsDataViewPanel.this.refreshData(true, null);
            }
        });
        this.m_container = new IndexedContainer();
        for (CmsDataViewColumn column : this.m_dataView.getColumns()) {
            this.m_container.addContainerProperty((Object)column.getId(), CmsColumnValueConverter.getColumnClass(column.getType()), null);
        }
        this.m_container.addContainerProperty(ID_COLUMN, String.class, null);
        final PagedTable table = new PagedTable(this.m_container);
        table.addStyleName("o-table-cell-padding");
        table.setMultiSelect(multiselect);
        table.addGeneratedColumn("checked", new Table.ColumnGenerator(){
            private static final long serialVersionUID = 1L;

            public Object generateCell(final Table source, final Object itemId, Object columnId) {
                CheckBox cb = CmsDataViewPanel.this.getCheckBox(itemId);
                cb.setValue((Object)source.isSelected(itemId));
                cb.addValueChangeListener(new Property.ValueChangeListener(){
                    private static final long serialVersionUID = 1L;

                    public void valueChange(Property.ValueChangeEvent event) {
                        boolean val = (Boolean)event.getProperty().getValue();
                        if (val) {
                            source.select(itemId);
                        } else {
                            source.unselect(itemId);
                        }
                    }
                });
                return cb;
            }
        });
        table.addStyleName("o-wrap-table");
        Object[] visibleCols = new String[this.m_dataView.getColumns().size() + 1];
        visibleCols[0] = "checked";
        int i = 1;
        for (CmsDataViewColumn col : this.m_dataView.getColumns()) {
            visibleCols[i++] = col.getId();
        }
        table.setVisibleColumns(visibleCols);
        table.setColumnWidth("checked", 45);
        table.setColumnHeader("checked", "");
        for (CmsDataViewColumn col : this.m_dataView.getColumns()) {
            table.setColumnHeader(col.getId(), col.getNiceName());
            table.setColumnWidth(col.getId(), col.getPreferredWidth());
        }
        table.setPageLength(0);
        table.setWidth("100%");
        table.setHeight("100%");
        this.m_table.set(table);
        table.setSelectable(true);
        this.replaceComponent((Component)this.m_tablePlaceholder, (Component)table);
        this.setExpandRatio((Component)table, 1.0f);
        this.addAttachListener(new ClientConnector.AttachListener(){
            private static final long serialVersionUID = 1L;

            public void attach(ClientConnector.AttachEvent event) {
                CmsDataViewPanel.this.refreshData(true, null);
            }
        });
        table.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                if (table.isMultiSelect()) {
                    if (CmsDataViewPanel.this.m_recursiveValueChange) {
                        this.updateCheckboxesWithSelectedIds(CmsDataViewPanel.this.m_realSelection);
                    } else {
                        CmsDataViewPanel.this.updateRealSelection(this.getIdsFromSelection(event));
                        if (CmsDataViewPanel.this.m_realSelection.equals(event.getProperty().getValue())) {
                            this.updateCheckboxesWithSelectedIds(CmsDataViewPanel.this.m_realSelection);
                        } else {
                            try {
                                CmsDataViewPanel.this.m_recursiveValueChange = true;
                                ((Table)CmsDataViewPanel.this.m_table.get()).setValue((Object)CmsDataViewPanel.this.m_realSelection);
                            }
                            finally {
                                CmsDataViewPanel.this.m_recursiveValueChange = false;
                            }
                        }
                    }
                } else {
                    Set<Object> ids = this.getIdsFromSelection(event);
                    this.updateCheckboxesWithSelectedIds(ids);
                }
            }

            protected Set<Object> getIdsFromSelection(Property.ValueChangeEvent event) {
                HashSet ids = Sets.newHashSet();
                if (event != null) {
                    if (event.getProperty().getValue() instanceof Collection) {
                        ids.addAll((Collection)event.getProperty().getValue());
                    } else {
                        ids.add(event.getProperty().getValue());
                    }
                }
                return ids;
            }

            protected void updateCheckboxesWithSelectedIds(Set<Object> selectedIds) {
                for (Map.Entry entry : CmsDataViewPanel.this.m_checkBoxes.entrySet()) {
                    if (selectedIds.contains(entry.getKey())) continue;
                    ((CheckBox)entry.getValue()).setValue((Object)Boolean.FALSE);
                }
                for (Object id : selectedIds) {
                    CmsDataViewPanel.this.getCheckBox(id).setValue((Object)Boolean.TRUE);
                }
            }
        });
        ArrayList<CmsDataViewFilter> filters = new ArrayList<CmsDataViewFilter>(this.m_dataView.getFilters());
        this.updateFilters(filters);
    }

    public void fillItem(I_CmsDataViewItem item, Item target) {
        for (CmsDataViewColumn column : this.m_dataView.getColumns()) {
            String name = column.getId();
            Object value = CmsColumnValueConverter.getColumnValue(item.getColumnData(name), column.getType());
            target.getItemProperty((Object)name).setValue(value);
        }
        target.getItemProperty(ID_COLUMN).setValue((Object)item.getId());
    }

    public List<I_CmsDataViewItem> getSelection() {
        ArrayList result = Lists.newArrayList();
        Object val = this.m_table.get().getValue();
        if (val == null) {
            return result;
        }
        if (val instanceof Collection) {
            Collection results = (Collection)val;
            for (Object obj : results) {
                result.add(this.m_dataView.getItemById((String)obj));
            }
        } else {
            result.add(this.m_dataView.getItemById((String)val));
        }
        return result;
    }

    public Table getTable() {
        return this.m_table.get();
    }

    public void refreshData(boolean resetPaging, String textQuery) {
        String fullTextQuery = textQuery != null ? textQuery : (String)this.m_fullTextSearch.getValue();
        LinkedHashMap<String, String> filterValues = new LinkedHashMap<String, String>();
        for (Map.Entry<String, CmsDataViewFilter> entry : this.m_filterMap.entrySet()) {
            filterValues.put(entry.getKey(), entry.getValue().getValue());
        }
        CmsDataViewQuery query = new CmsDataViewQuery();
        String sortCol = (String)this.m_sortCol;
        boolean ascending = this.m_ascending;
        query.setFullTextQuery(fullTextQuery);
        query.setFilterValues(filterValues);
        query.setSortColumn(sortCol);
        query.setSortAscending(ascending);
        CmsDataViewResult result = this.m_dataView.getResults(query, resetPaging ? 0 : this.getOffset(), this.m_dataView.getPageSize());
        this.m_container.removeAllItems();
        for (I_CmsDataViewItem item : result.getItems()) {
            this.fillItem(item, this.m_container.addItem((Object)item.getId()));
        }
        if (resetPaging) {
            int total = result.getHitCount();
            this.m_pagingControls.reset(result.getHitCount(), this.m_dataView.getPageSize(), false);
        }
    }

    public void updateFilter(String id, String value) {
        CmsDataViewFilter oldFilter = this.m_filterMap.get(id);
        CmsDataViewFilter newFilter = oldFilter.copyWithValue(value);
        this.m_filterMap.put(id, newFilter);
        ArrayList<CmsDataViewFilter> filters = new ArrayList<CmsDataViewFilter>(this.m_filterMap.values());
        this.updateFilters(this.m_dataView.updateFilters(filters));
    }

    public void updateFilters(List<CmsDataViewFilter> newFilters) {
        if (newFilters.isEmpty()) {
            this.m_filterContainer.setVisible(false);
        }
        if (this.m_filters.equals(newFilters)) {
            return;
        }
        this.m_filterContainer.removeAllComponents();
        this.m_filters = newFilters;
        this.m_filterMap.clear();
        for (CmsDataViewFilter filter : newFilters) {
            this.m_filterMap.put(filter.getId(), filter);
            final CmsDataViewFilter finalFilter = filter;
            ComboBox select = new ComboBox(filter.getNiceName());
            select.setWidth("175px");
            select.setNullSelectionAllowed(false);
            select.setPageLength(0);
            Map<String, String> options = filter.getOptions();
            for (Map.Entry<String, String> entry : options.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                select.addItem((Object)key);
                select.setItemCaption((Object)key, value);
            }
            select.setValue((Object)filter.getValue());
            if (filter.getHelpText() != null) {
                select.setDescription(filter.getHelpText());
            }
            select.addValueChangeListener(new Property.ValueChangeListener(){
                private static final long serialVersionUID = 1L;

                public void valueChange(Property.ValueChangeEvent event) {
                    String newValue = (String)event.getProperty().getValue();
                    CmsDataViewPanel.this.updateFilter(finalFilter.getId(), newValue);
                }
            });
            this.m_filterContainer.addComponent((Component)select);
        }
    }

    protected void updateRealSelection(Set<Object> selectionEventIds) {
        HashSet pageItems = Sets.newHashSet((Iterable)this.m_table.get().getContainerDataSource().getItemIds());
        HashSet result = Sets.newHashSet(this.m_realSelection);
        result.removeAll(pageItems);
        result.addAll(selectionEventIds);
        this.m_realSelection = result;
    }

    private CheckBox getCheckBox(Object id) {
        if (!this.m_checkBoxes.containsKey(id)) {
            this.m_checkBoxes.put(id, new CheckBox());
        }
        return this.m_checkBoxes.get(id);
    }

    private int getOffset() {
        return this.m_pagingControls.getPage() * this.m_dataView.getPageSize();
    }

    public class PagedTable
    extends Table {
        private static final long serialVersionUID = 1L;

        public PagedTable(IndexedContainer container) {
            this.setContainerDataSource((Container)container);
        }

        public void sort(Object[] propertyId, boolean[] ascending) throws UnsupportedOperationException {
            CmsDataViewPanel.this.m_sortCol = propertyId[0];
            CmsDataViewPanel.this.m_ascending = ascending[0];
            CmsDataViewPanel.this.refreshData(true, null);
        }
    }
}

