/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dataview;

import com.google.common.collect.Lists;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import java.util.List;
import org.opencms.ui.CmsVaadinUtils;

public class CmsPagingControls
extends HorizontalLayout {
    private static final long serialVersionUID = 1L;
    private List<I_PagingCallback> m_callbacks = Lists.newArrayList();
    private int m_page;
    private Button m_forward = new Button((Resource)FontAwesome.FORWARD);
    private Button m_fastForward = new Button((Resource)FontAwesome.FAST_FORWARD);
    private Button m_back = new Button((Resource)FontAwesome.BACKWARD);
    private Button m_fastBack = new Button((Resource)FontAwesome.FAST_BACKWARD);
    private Label m_label = new Label();
    private Label m_resultsLabel = new Label();
    private int m_lastPage;
    private int m_pageSize;
    private int m_resultCount;

    public CmsPagingControls() {
        this.setMargin(true);
        this.addComponent((Component)this.m_label);
        this.addComponent((Component)this.m_fastBack);
        this.addComponent((Component)this.m_back);
        this.addComponent((Component)this.m_forward);
        this.addComponent((Component)this.m_fastForward);
        this.addComponent((Component)this.m_resultsLabel);
        this.m_resultsLabel.setWidthUndefined();
        this.m_label.setWidthUndefined();
        this.setExpandRatio((Component)this.m_resultsLabel, 1.0f);
        this.setComponentAlignment((Component)this.m_resultsLabel, Alignment.TOP_RIGHT);
        this.setSpacing(true);
        this.m_forward.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsPagingControls.this.setPage(Math.min(CmsPagingControls.this.m_lastPage, CmsPagingControls.this.m_page + 1), true);
                CmsPagingControls.this.updateButtons();
            }
        });
        this.m_fastForward.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsPagingControls.this.setPage(CmsPagingControls.this.m_lastPage, true);
                CmsPagingControls.this.updateButtons();
            }
        });
        this.m_back.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsPagingControls.this.setPage(Math.max(0, CmsPagingControls.this.m_page - 1), true);
                CmsPagingControls.this.updateButtons();
            }
        });
        this.m_fastBack.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsPagingControls.this.setPage(0, true);
                CmsPagingControls.this.updateButtons();
            }
        });
    }

    public void addCallback(I_PagingCallback callback) {
        this.m_callbacks.add(callback);
    }

    public void firePageChanged(int pageNum) {
        for (I_PagingCallback callback : this.m_callbacks) {
            callback.pageChanged(pageNum);
        }
    }

    public int getPage() {
        return this.m_page;
    }

    public void removeCallback(I_PagingCallback callback) {
        this.m_callbacks.remove(callback);
    }

    public void reset(int resultCount, int pageSize, boolean fireChanged) {
        this.m_lastPage = resultCount == 0 ? 0 : (resultCount - 1) / pageSize;
        this.m_resultCount = resultCount;
        this.m_pageSize = pageSize;
        this.setPage(0, false);
        this.updateButtons();
        if (fireChanged) {
            this.firePageChanged(0);
        }
    }

    public void setPage(int page, boolean fireChanged) {
        this.m_page = page;
        this.m_label.setValue("( " + (1 + this.m_page) + " / " + (this.m_lastPage + 1) + " )");
        int start = this.m_page * this.m_pageSize + 1;
        int end = Math.min(start + this.m_pageSize - 1, this.m_resultCount);
        String resultsMsg = CmsVaadinUtils.getMessageText("GUI_DATAVIEW_RESULTS_3", "" + start, "" + end, "" + this.m_resultCount);
        this.m_resultsLabel.setValue(start <= end ? resultsMsg : "");
        if (fireChanged) {
            this.firePageChanged(page);
        }
    }

    public void updateButtons() {
        for (Button button : new Button[]{this.m_forward, this.m_fastForward}) {
            button.setEnabled(this.m_page < this.m_lastPage);
        }
        for (Button button : new Button[]{this.m_back, this.m_fastBack}) {
            button.setEnabled(this.m_page > 0);
        }
    }

    public static interface I_PagingCallback {
        public void pageChanged(int var1);
    }
}

