/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsOkCancelActionHandler;

public class CmsCopyToProjectDialog
extends CmsBasicDialog {
    private static final Log LOG = CmsLog.getLog(CmsCopyToProjectDialog.class);
    private static final long serialVersionUID = -3016972948701432951L;
    private I_CmsDialogContext m_context;

    public CmsCopyToProjectDialog(I_CmsDialogContext context) {
        this.m_context = context;
        this.displayResourceInfo(this.m_context.getResources());
        String projectName = this.m_context.getCms().getRequestContext().getCurrentProject().getName();
        Panel resourceListPanel = null;
        try {
            List<String> projectRes = this.m_context.getCms().readProjectResources(this.m_context.getCms().getRequestContext().getCurrentProject());
            ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
            CmsObject rootCms = OpenCms.initCmsObject(this.m_context.getCms());
            rootCms.getRequestContext().setSiteRoot("/");
            for (String res : projectRes) {
                try {
                    CmsResource resource = rootCms.readResource(res, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                    resources.add(resource);
                }
                catch (CmsException ex) {
                    LOG.warn((Object)("Error reading project resource '" + res + "'."), (Throwable)ex);
                }
            }
            if (!resources.isEmpty()) {
                resourceListPanel = this.createResourceListPanel(CmsVaadinUtils.getMessageText("GUI_COPYTOPROJECT_PART_1", projectName), resources);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)("Error reading resources of the project '" + projectName + "'."), (Throwable)e);
        }
        VerticalLayout main = new VerticalLayout();
        if (resourceListPanel != null) {
            main.addComponent(resourceListPanel);
        }
        Label label = new Label(CmsVaadinUtils.getMessageText("GUI_COPYTOPROJECT_PROJECT_CONFIRMATION_2", this.m_context.getResources().get(0).getName(), projectName));
        main.addComponent((Component)label);
        main.setSpacing(true);
        this.setContent((Component)main);
        Button okButton = this.createButtonOK();
        okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsCopyToProjectDialog.this.submit();
            }
        });
        this.addButton((Component)okButton);
        Button cancelButton = this.createButtonCancel();
        cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsCopyToProjectDialog.this.cancel();
            }
        });
        this.addButton((Component)cancelButton);
        this.setActionHandler(new CmsOkCancelActionHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancel() {
                CmsCopyToProjectDialog.this.cancel();
            }

            @Override
            protected void ok() {
                CmsCopyToProjectDialog.this.submit();
            }
        });
    }

    void cancel() {
        this.m_context.finish(null);
    }

    void submit() {
        CmsResource target = this.m_context.getResources().get(0);
        String resPath = this.m_context.getCms().getSitePath(target);
        try {
            this.m_context.getCms().copyResourceToProject(resPath);
            this.m_context.finish(Collections.singletonList(target.getStructureId()));
        }
        catch (CmsException e) {
            this.m_context.error(e);
        }
    }
}

