/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs;

import com.google.common.collect.Lists;
import com.vaadin.data.Property;
import com.vaadin.data.util.IndexedContainer;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.gwt.CmsVfsService;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsOkCancelActionHandler;
import org.opencms.ui.components.CmsResourceInfo;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;

public class CmsRestoreDeletedDialog
extends CmsBasicDialog {
    private static final String PROP_SELECTED = "selected";
    private static final long serialVersionUID = 1L;
    private Button m_cancelButton;
    private AbstractOrderedLayout m_deletedResourceContainer;
    private I_CmsDialogContext m_dialogContext;
    private CheckBox m_includeSubfoldersField;
    private Button m_okButton;
    private CmsResource m_resource;
    private CheckBox m_selectAllField;
    private IndexedContainer m_selectionContainer;

    public CmsRestoreDeletedDialog(I_CmsDialogContext context) throws CmsException {
        this.m_dialogContext = context;
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_resource = context.getResources().get(0);
        CmsObject cms = context.getCms();
        List<I_CmsHistoryResource> deletedResources = cms.readDeletedResources(cms.getSitePath(this.m_resource), (Boolean)this.m_includeSubfoldersField.getValue());
        this.initDeletedResources(cms, deletedResources);
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsRestoreDeletedDialog.this.cancel();
            }
        });
        this.m_includeSubfoldersField.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsRestoreDeletedDialog.this.onSubFolderChange((Boolean)event.getProperty().getValue());
            }
        });
        this.m_selectAllField.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsRestoreDeletedDialog.this.onSelectAllChange((Boolean)event.getProperty().getValue());
            }
        });
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsRestoreDeletedDialog.this.submit();
            }
        });
        this.setActionHandler(new CmsOkCancelActionHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancel() {
                CmsRestoreDeletedDialog.this.cancel();
            }

            @Override
            protected void ok() {
                CmsRestoreDeletedDialog.this.submit();
            }
        });
    }

    public List<CmsUUID> getSelectedIds() {
        List itemIds = this.m_selectionContainer.getItemIds();
        ArrayList result = Lists.newArrayList();
        for (Object itemId : itemIds) {
            CmsUUID structureId = (CmsUUID)itemId;
            Boolean value = (Boolean)this.m_selectionContainer.getItem(itemId).getItemProperty((Object)PROP_SELECTED).getValue();
            if (!value.booleanValue()) continue;
            result.add(structureId);
        }
        return result;
    }

    void cancel() {
        this.m_dialogContext.finish(new ArrayList<CmsUUID>());
    }

    void onSelectAllChange(Boolean value) {
        for (Object id : this.m_selectionContainer.getItemIds()) {
            this.m_selectionContainer.getItem(id).getItemProperty((Object)PROP_SELECTED).setValue((Object)value);
        }
    }

    void onSubFolderChange(Boolean value) {
        try {
            CmsObject cms = this.m_dialogContext.getCms();
            List<I_CmsHistoryResource> historyResources = cms.readDeletedResources(cms.getSitePath(this.m_resource), value);
            this.initDeletedResources(cms, historyResources);
        }
        catch (CmsException e) {
            this.m_dialogContext.error(e);
        }
    }

    void submit() {
        List<CmsUUID> selectedIds = this.getSelectedIds();
        ArrayList updated = Lists.newArrayList();
        CmsObject cms = this.m_dialogContext.getCms();
        try {
            for (CmsUUID selectedId : selectedIds) {
                cms.restoreDeletedResource(selectedId);
                updated.add(selectedId);
            }
            this.m_dialogContext.finish(updated);
        }
        catch (CmsException e) {
            this.m_dialogContext.error(e);
        }
    }

    private void initDeletedResources(CmsObject cms, List<I_CmsHistoryResource> deletedResources) throws CmsException {
        Collections.sort(deletedResources, new Comparator<I_CmsHistoryResource>(){

            @Override
            public int compare(I_CmsHistoryResource first, I_CmsHistoryResource second) {
                return first.getRootPath().compareTo(second.getRootPath());
            }
        });
        this.m_deletedResourceContainer.removeAllComponents();
        this.m_selectionContainer = new IndexedContainer();
        this.m_selectionContainer.addContainerProperty((Object)PROP_SELECTED, Boolean.class, (Object)Boolean.FALSE);
        this.m_okButton.setEnabled(!deletedResources.isEmpty());
        if (deletedResources.isEmpty()) {
            this.m_deletedResourceContainer.addComponent((Component)new Label(CmsVaadinUtils.getMessageText("GUI_LIST_EMPTY_0", new Object[0])));
        }
        for (I_CmsHistoryResource deleted : deletedResources) {
            I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(deleted.getTypeId());
            String typeName = resType.getTypeName();
            CmsExplorerTypeSettings explorerType = OpenCms.getWorkplaceManager().getExplorerTypeSetting(typeName);
            String title = cms.getRequestContext().removeSiteRoot(deleted.getRootPath());
            String subtitle = CmsVaadinUtils.getMessageText("GUI_RESTOREDELETED_DATE_VERSION_2", CmsVfsService.formatDateTime(cms, deleted.getDateLastModified()), "" + deleted.getVersion());
            String iconPath = OpenCms.getWorkplaceManager().getExplorerTypeSetting(deleted.isFile() ? "unknown_file" : "unknown_folder").getBigIconIfAvailable();
            if (explorerType != null) {
                iconPath = "filetypes/" + explorerType.getBigIconIfAvailable();
            }
            CmsResourceInfo info = new CmsResourceInfo(title, subtitle, CmsWorkplace.getResourceUri(iconPath));
            info.setWidth("100%");
            HorizontalLayout hl = new HorizontalLayout();
            hl.setWidth("100%");
            CheckBox checkbox = new CheckBox();
            hl.addComponent((Component)checkbox);
            hl.addComponent((Component)info);
            hl.setExpandRatio((Component)info, 1.0f);
            hl.setComponentAlignment((Component)checkbox, Alignment.MIDDLE_LEFT);
            this.m_selectionContainer.addItem((Object)deleted.getStructureId());
            checkbox.setPropertyDataSource(this.m_selectionContainer.getItem((Object)deleted.getStructureId()).getItemProperty((Object)PROP_SELECTED));
            this.m_deletedResourceContainer.addComponent((Component)hl);
        }
    }
}

