/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs;

import com.vaadin.data.Property;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.OptionGroup;
import com.vaadin.ui.TextField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.lock.CmsLockActionRecord;
import org.opencms.lock.CmsLockException;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsOkCancelActionHandler;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplaceMessages;

public class CmsSecureExportDialog
extends CmsBasicDialog {
    private static final Log LOG = CmsLog.getLog(CmsSecureExportDialog.class);
    private static final long serialVersionUID = 1L;
    protected Button m_cancelButton;
    protected I_CmsDialogContext m_context;
    protected OptionGroup m_exportField;
    protected TextField m_exportNameField;
    protected CheckBox m_internalField;
    protected Button m_okButton;
    protected CmsResource m_resource;
    protected OptionGroup m_secureField;
    protected Label m_noSecureServerLabel;
    private Label m_linkField;

    public CmsSecureExportDialog(I_CmsDialogContext context) {
        this.m_context = context;
        CmsObject cms = context.getCms();
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, OpenCms.getWorkplaceManager().getMessages(A_CmsUI.get().getLocale()), null);
        this.m_resource = this.m_context.getResources().get(0);
        this.initOptionGroup(this.m_secureField);
        this.initOptionGroup(this.m_exportField);
        this.m_linkField.setValue(OpenCms.getLinkManager().getOnlineLink(cms, cms.getSitePath(this.m_resource)));
        this.loadData();
        CmsSite site = OpenCms.getSiteManager().getCurrentSite(context.getCms());
        this.m_noSecureServerLabel.setVisible(false);
        if (site != null && !site.hasSecureServer()) {
            this.m_secureField.setEnabled(false);
            this.m_secureField.setVisible(false);
            this.m_noSecureServerLabel.setVisible(true);
        }
        this.m_internalField.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                Boolean valueObj = (Boolean)event.getProperty().getValue();
                if (valueObj.booleanValue()) {
                    CmsSecureExportDialog.this.m_secureField.setEnabled(false);
                    CmsSecureExportDialog.this.m_exportField.setEnabled(false);
                } else {
                    CmsSecureExportDialog.this.m_secureField.setEnabled(true);
                    CmsSecureExportDialog.this.m_exportField.setEnabled(true);
                }
            }
        });
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsSecureExportDialog.this.cancel();
            }
        });
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsSecureExportDialog.this.submit();
            }
        });
        this.displayResourceInfo(this.m_context.getResources());
        this.setActionHandler(new CmsOkCancelActionHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancel() {
                CmsSecureExportDialog.this.cancel();
            }

            @Override
            protected void ok() {
                CmsSecureExportDialog.this.submit();
            }
        });
    }

    protected void loadData() {
        try {
            List<CmsProperty> propList = this.m_context.getCms().readPropertyObjects(this.m_resource, false);
            List<CmsProperty> inheritedPropList = this.m_context.getCms().readPropertyObjects(this.m_resource, true);
            Map<String, CmsProperty> propMap = CmsProperty.toObjectMap(propList);
            Map<String, CmsProperty> inheritedPropMap = CmsProperty.toObjectMap(inheritedPropList);
            String secureValue = this.convertPropertyToFieldValue(propMap.get("secure"));
            String inheritedSecureValue = this.convertPropertyToFieldValue(inheritedPropMap.get("secure"));
            String exportValue = this.convertPropertyToFieldValue(propMap.get("export"));
            CmsProperty exportnameProp = propMap.get("exportname");
            String exportnameValue = "";
            if (exportnameProp != null) {
                exportnameValue = exportnameProp.getValue();
            }
            this.m_exportField.setValue((Object)exportValue);
            this.m_secureField.setValue((Object)secureValue);
            if ("".equals(secureValue) && !"".equals(inheritedSecureValue)) {
                String origin = this.m_context.getCms().getRequestContext().removeSiteRoot(inheritedPropMap.get("secure").getOrigin());
                String inheritedValueCaption = CmsVaadinUtils.getMessageText("GUI_SECURE_INHERIT_FROM_2", inheritedSecureValue, origin);
                this.m_secureField.setItemCaption((Object)"", inheritedValueCaption);
            }
            this.m_exportNameField.setValue(exportnameValue);
            this.m_internalField.setValue((Object)this.m_resource.isInternal());
        }
        catch (CmsException e) {
            this.m_context.error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveData() throws CmsException {
        CmsObject cms = this.m_context.getCms();
        for (CmsResource resource : this.m_context.getResources()) {
            CmsLockActionRecord actionRecord = null;
            try {
                actionRecord = CmsLockUtil.ensureLock(this.m_context.getCms(), resource);
                String secureValue = (String)this.m_secureField.getValue();
                String exportValue = (String)this.m_exportField.getValue();
                String exportname = (String)this.m_exportNameField.getValue();
                CmsProperty secureProp = new CmsProperty("secure", secureValue, null);
                CmsProperty exportProp = new CmsProperty("export", exportValue, null);
                CmsProperty exportNameProp = new CmsProperty("exportname", exportname, null);
                boolean internal = (Boolean)this.m_internalField.getValue();
                cms.writePropertyObjects(resource, Arrays.asList(secureProp, exportProp, exportNameProp));
                resource.setInternal(internal);
                cms.writeResource(resource);
            }
            finally {
                if (actionRecord == null || actionRecord.getChange() != CmsLockActionRecord.LockChange.locked) continue;
                try {
                    cms.unlockResource(resource);
                }
                catch (CmsLockException e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    void cancel() {
        this.m_context.finish(new ArrayList<CmsUUID>());
    }

    void submit() {
        try {
            this.saveData();
            this.m_context.finish(null);
        }
        catch (Exception e) {
            this.m_context.error(e);
        }
    }

    private String convertPropertyToFieldValue(CmsProperty prop) {
        if (prop == null) {
            return "";
        }
        return "" + Boolean.valueOf(prop.getValue());
    }

    private void initOptionGroup(OptionGroup optGroup) {
        optGroup.addStyleName("horizontal");
        optGroup.setNullSelectionAllowed(false);
        optGroup.addItem((Object)"true");
        optGroup.addItem((Object)"false");
        optGroup.addItem((Object)"");
        CmsWorkplaceMessages wpMessages = OpenCms.getWorkplaceManager().getMessages(A_CmsUI.get().getLocale());
        optGroup.setItemCaption((Object)"true", wpMessages.key("GUI_LABEL_TRUE_0"));
        optGroup.setItemCaption((Object)"false", wpMessages.key("GUI_LABEL_FALSE_0"));
        optGroup.setItemCaption((Object)"", wpMessages.key("GUI_SECURE_NOT_SET_0"));
    }
}

