/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs;

import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.Validator;
import com.vaadin.data.fieldgroup.FieldGroup;
import com.vaadin.data.util.ObjectProperty;
import com.vaadin.data.util.PropertysetItem;
import com.vaadin.data.util.converter.Converter;
import com.vaadin.data.validator.AbstractStringValidator;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.util.Collections;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsMessages;
import org.opencms.i18n.CmsResourceBundleLoader;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.Messages;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsOkCancelActionHandler;
import org.opencms.ui.dialogs.I_CmsHasTitle;
import org.opencms.ui.util.CmsNullToEmptyConverter;
import org.opencms.workplace.CmsAccountInfo;

public class CmsUserDataDialog
extends CmsBasicDialog
implements I_CmsHasTitle {
    public static final String DIALOG_ID = "edituserdata";
    private static final long serialVersionUID = 8907786853232656944L;
    private static final Log LOG = CmsLog.getLog(CmsUserDataDialog.class);
    private FieldGroup m_binder;
    private Button m_cancelButton;
    private I_CmsDialogContext m_context;
    private FormLayout m_form;
    private PropertysetItem m_infos;
    private Button m_okButton;
    private CmsUser m_user;
    private Label m_userInfo;

    public CmsUserDataDialog(I_CmsDialogContext context) {
        this.m_context = context;
        CmsObject cms = context.getCms();
        this.m_user = cms.getRequestContext().getCurrentUser();
        if (this.m_user.isManaged()) {
            throw new CmsRuntimeException(Messages.get().container("ERR_USER_NOT_SELF_MANAGED_1", this.m_user.getName()));
        }
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, OpenCms.getWorkplaceManager().getMessages(A_CmsUI.get().getLocale()), null);
        this.m_userInfo.setContentMode(ContentMode.HTML);
        this.m_userInfo.setValue("<img src=\"" + OpenCms.getWorkplaceAppManager().getUserIconHelper().getSmallIconPath(cms, this.m_user) + "\" style=\"vertical-align:middle; margin: -4px 10px 0 0;\" />" + this.m_user.getName());
        this.initFields();
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsUserDataDialog.this.cancel();
            }
        });
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsUserDataDialog.this.submit();
            }
        });
        this.setActionHandler(new CmsOkCancelActionHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancel() {
                CmsUserDataDialog.this.cancel();
            }

            @Override
            protected void ok() {
                CmsUserDataDialog.this.submit();
            }
        });
    }

    public CmsUserDataDialog(I_CmsDialogContext context, boolean forcedCheck) {
        this(context);
        if (forcedCheck) {
            ((VerticalLayout)this.m_userInfo.getParent()).addComponent((Component)new Label(this.getUserDataCheckMessage()), 1);
            this.m_cancelButton.setVisible(false);
        }
    }

    @Override
    public String getTitle(Locale locale) {
        return org.opencms.ui.components.Messages.get().getBundle(locale).key("GUI_USER_EDIT_0");
    }

    protected String getUserDataCheckMessage() {
        ResourceBundle bundle = null;
        try {
            bundle = CmsResourceBundleLoader.getBundle("org.opencms.userdatacheck.custom", A_CmsUI.get().getLocale());
            return bundle.getString("userdatacheck.text");
        }
        catch (MissingResourceException e) {
            return CmsVaadinUtils.getMessageText("GUI_USER_DATA_CHECK_INFO_0", new Object[0]);
        }
    }

    void cancel() {
        this.m_context.finish(Collections.emptyList());
        this.m_context.updateUserInfo();
    }

    void submit() {
        try {
            this.m_user = this.m_context.getCms().readUser(this.m_user.getId());
            if (this.isValid()) {
                this.m_binder.commit();
                PropertyUtilsBean propUtils = new PropertyUtilsBean();
                for (CmsAccountInfo info : OpenCms.getWorkplaceManager().getAccountInfos()) {
                    if (!info.isEditable()) continue;
                    if (info.isAdditionalInfo()) {
                        this.m_user.setAdditionalInfo(info.getAddInfoKey(), this.m_infos.getItemProperty((Object)info).getValue());
                        continue;
                    }
                    propUtils.setProperty((Object)this.m_user, info.getField().name(), this.m_infos.getItemProperty((Object)info).getValue());
                }
                this.m_context.getCms().writeUser(this.m_user);
                this.m_context.finish(Collections.emptyList());
                this.m_context.updateUserInfo();
            }
        }
        catch (Exception e) {
            this.m_context.error(e);
        }
    }

    void updateUserInfo() {
        try {
            this.m_user = this.m_context.getCms().readUser(this.m_user.getId());
            this.m_userInfo.setValue("<img src=\"" + OpenCms.getWorkplaceAppManager().getUserIconHelper().getSmallIconPath(this.m_context.getCms(), this.m_user) + "\" style=\"vertical-align:middle; margin: -4px 10px 0 0;\" />" + this.m_user.getName());
        }
        catch (CmsException e) {
            LOG.error((Object)"Error updating user info.", (Throwable)e);
        }
    }

    private TextField buildField(String label, CmsAccountInfo info) {
        TextField field = (TextField)this.m_binder.buildAndBind(label, (Object)info);
        field.setConverter((Converter)new CmsNullToEmptyConverter());
        field.setWidth("100%");
        field.setEnabled(info.isEditable());
        if (info.isEditable()) {
            field.addValidator((Validator)new FieldValidator(info.getField()));
        }
        field.setImmediate(true);
        return field;
    }

    private String getLabel(CmsAccountInfo info) {
        if (info.isAdditionalInfo()) {
            String label = CmsVaadinUtils.getMessageText("GUI_USER_DATA_" + info.getAddInfoKey().toUpperCase() + "_0", new Object[0]);
            if (CmsMessages.isUnknownKey(label)) {
                return info.getAddInfoKey();
            }
            return label;
        }
        return CmsVaadinUtils.getMessageText("GUI_USER_DATA_" + info.getField().name().toUpperCase() + "_0", new Object[0]);
    }

    private void initFields() {
        this.m_infos = new PropertysetItem();
        for (CmsAccountInfo info : OpenCms.getWorkplaceManager().getAccountInfos()) {
            String value = info.getValue(this.m_user);
            if (value == null) {
                value = "";
            }
            this.m_infos.addItemProperty((Object)info, (Property)new ObjectProperty((Object)value));
        }
        this.m_binder = new FieldGroup((Item)this.m_infos);
        for (CmsAccountInfo info : OpenCms.getWorkplaceManager().getAccountInfos()) {
            this.m_form.addComponent((Component)this.buildField(this.getLabel(info), info));
        }
    }

    private boolean isValid() {
        boolean valid = true;
        for (Component comp : this.m_form) {
            if (!(comp instanceof TextField)) continue;
            valid = valid && ((TextField)comp).isValid();
        }
        return valid;
    }

    private static class FieldValidator
    extends AbstractStringValidator {
        private static final long serialVersionUID = 4432834072807177046L;
        private CmsAccountInfo.Field m_field;

        public FieldValidator(CmsAccountInfo.Field field) {
            super(null);
            this.m_field = field;
        }

        protected boolean isValidValue(String value) {
            boolean result = true;
            try {
                switch (this.m_field) {
                    case email: {
                        OpenCms.getValidationHandler().checkEmail(value);
                        break;
                    }
                    case firstname: {
                        OpenCms.getValidationHandler().checkFirstname(value);
                        break;
                    }
                    case lastname: {
                        OpenCms.getValidationHandler().checkLastname(value);
                        break;
                    }
                    case zipcode: {
                        OpenCms.getValidationHandler().checkZipCode(value);
                    }
                }
            }
            catch (CmsIllegalArgumentException e) {
                result = false;
                this.setErrorMessage(e.getLocalizedMessage(UI.getCurrent().getLocale()));
            }
            return result;
        }
    }
}

