/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs.embedded;

import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.gwt.shared.CmsDataViewParamEncoder;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.dataview.I_CmsDataView;
import org.opencms.widgets.dataview.I_CmsDataViewItem;

public class CmsDataViewParams {
    private static final Log LOG = CmsLog.getLog(CmsDataViewParams.class);
    private String m_callback;
    private String m_callbackArg;
    private String m_multiSelect;
    private String m_viewClass;
    private String m_viewArg;

    public CmsDataViewParams(URI uri) {
        Multimap<String, String> params = CmsRequestUtil.getParameters(uri);
        if (params.containsKey((Object)"config")) {
            String encodedConfig = (String)params.get((Object)"config").iterator().next();
            try {
                JSONObject json = new JSONObject(CmsDataViewParamEncoder.decodeString(encodedConfig));
                this.m_callback = json.optString("cb");
                this.m_callbackArg = json.optString("cbp");
                this.m_viewClass = json.optString("class");
                this.m_viewArg = json.optString("config");
                this.m_multiSelect = json.optString("multiselect");
            }
            catch (JSONException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public I_CmsDataView createViewInstance(CmsObject cms, Locale locale) {
        try {
            Class<?> cls = Class.forName(this.m_viewClass);
            Object viewObj = cls.newInstance();
            I_CmsDataView dataView = (I_CmsDataView)viewObj;
            dataView.initialize(cms, this.m_viewArg, locale);
            return dataView;
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean isMultiSelect() {
        return Boolean.parseBoolean(this.m_multiSelect);
    }

    public String prepareCallbackScript(List<I_CmsDataViewItem> result) {
        try {
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_callbackArg)) {
                this.m_callbackArg = "{}";
            }
            JSONObject obj = new JSONObject(this.m_callbackArg);
            JSONArray selection = new JSONArray();
            for (I_CmsDataViewItem item : result) {
                JSONObject singleResult = new JSONObject();
                singleResult.put("id", item.getId());
                singleResult.put("title", item.getTitle());
                singleResult.put("description", item.getDescription());
                singleResult.put("data", item.getData());
                selection.put(singleResult);
            }
            obj.put("result", selection);
            String jsonString = obj.toString();
            return "parent." + this.m_callback + "(" + jsonString + ")";
        }
        catch (Exception e) {
            return null;
        }
    }
}

