/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs.history.diff;

import com.google.common.base.Optional;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeBinary;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.CmsResourceTypePointer;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.gwt.shared.CmsHistoryResourceBean;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.extractors.CmsExtractorMsOfficeOLE2;
import org.opencms.search.extractors.CmsExtractorPdf;
import org.opencms.search.extractors.CmsExtractorRtf;
import org.opencms.search.extractors.I_CmsTextExtractor;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.dialogs.history.diff.A_CmsAttributeDiff;
import org.opencms.ui.dialogs.history.diff.CmsTextDiffPanel;
import org.opencms.ui.dialogs.history.diff.I_CmsDiffProvider;

public class CmsTextDiff
implements I_CmsDiffProvider {
    private static final Log LOG = CmsLog.getLog(CmsTextDiff.class);

    @Override
    public Optional<Component> diff(CmsObject cms, CmsHistoryResourceBean v1, CmsHistoryResourceBean v2) throws CmsException {
        CmsResource resource1 = A_CmsAttributeDiff.readResource(cms, v1);
        String encoding = CmsLocaleManager.getResourceEncoding(cms, resource1);
        I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(resource1);
        if (type instanceof CmsResourceTypeXmlContent || type instanceof CmsResourceTypePlain || type instanceof CmsResourceTypeJsp || type instanceof CmsResourceTypeXmlPage || type instanceof CmsResourceTypePointer || type instanceof CmsResourceTypeBinary) {
            CmsResource resource2 = A_CmsAttributeDiff.readResource(cms, v2);
            String path1 = resource1.getRootPath();
            String path2 = resource2.getRootPath();
            CmsFile file1 = cms.readFile(resource1);
            CmsFile file2 = cms.readFile(resource2);
            byte[] content1 = file1.getContents();
            byte[] content2 = file2.getContents();
            String originalSource = null;
            String copySource = null;
            I_CmsTextExtractor textExtractor = null;
            if (content1.length > 0 && content2.length > 0) {
                if (path1.endsWith(".pdf") && path2.endsWith(".pdf")) {
                    textExtractor = CmsExtractorPdf.getExtractor();
                } else if (path1.endsWith(".doc") && path2.endsWith(".doc")) {
                    textExtractor = CmsExtractorMsOfficeOLE2.getExtractor();
                } else if (path1.endsWith(".xls") && path2.endsWith(".xls")) {
                    textExtractor = CmsExtractorMsOfficeOLE2.getExtractor();
                } else if (path1.endsWith(".rtf") && path2.endsWith(".rtf")) {
                    textExtractor = CmsExtractorRtf.getExtractor();
                } else if (path1.endsWith(".ppt") && path2.endsWith(".ppt")) {
                    textExtractor = CmsExtractorMsOfficeOLE2.getExtractor();
                }
            }
            if (textExtractor != null) {
                try {
                    originalSource = textExtractor.extractText(content1).getContent();
                    copySource = textExtractor.extractText(content2).getContent();
                }
                catch (Exception e) {
                    originalSource = null;
                    copySource = null;
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            } else if (type instanceof CmsResourceTypePlain || type instanceof CmsResourceTypeJsp || type instanceof CmsResourceTypePointer) {
                try {
                    originalSource = new String(content1, encoding);
                    copySource = new String(content2, encoding);
                }
                catch (UnsupportedEncodingException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (copySource == null || originalSource == null) {
                return Optional.absent();
            }
            try {
                CmsTextDiffPanel diffPanel = new CmsTextDiffPanel(originalSource, copySource, false, true);
                diffPanel.setWidth("100%");
                Panel panel = new Panel(CmsVaadinUtils.getMessageText("GUI_HISTORY_DIALOG_TEXT_COMPARISON_CAPTION_0", new Object[0]));
                panel.setWidth("100%");
                VerticalLayout vl = new VerticalLayout();
                vl.setMargin(true);
                vl.addComponent((Component)diffPanel);
                panel.setContent((Component)vl);
                return Optional.fromNullable((Object)panel);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return Optional.absent();
            }
        }
        return Optional.absent();
    }

    protected String wrapLinesWithUnchangedStyle(String diff) throws IOException {
        String line;
        StringBuffer result = new StringBuffer();
        BufferedReader br = new BufferedReader(new StringReader(diff));
        while ((line = br.readLine()) != null) {
            if ("".equals(line.trim())) {
                line = "&nbsp;";
            }
            result.append("<div class=\"df-unc\"><span class=\"df-unc\">").append(line).append("</span></div>\n");
        }
        return result.toString();
    }
}

