/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs.permissions;

import com.vaadin.data.Buffered;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.Validator;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.BrowserFrame;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.Field;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.TextField;
import com.vaadin.ui.Window;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.dialogs.permissions.CmsPrincipalSelectExtension;

public class CmsPrincipalSelect
extends CustomComponent
implements Field<String> {
    private static final long serialVersionUID = 6944968889428174262L;
    private Button m_addPermissionSetButton;
    private TextField m_principalName;
    private ComboBox m_principalTypeSelect;
    private PrincipalSelectHandler m_selectHandler;
    private Button m_selectPrincipalButton;
    private WidgetType m_widgetType;
    private Window m_window;
    private HorizontalLayout m_main = new HorizontalLayout();
    private boolean m_realOnly;

    public CmsPrincipalSelect() {
        this.m_main.setSpacing(true);
        this.m_main.setWidth("100%");
        this.setCompositionRoot((Component)this.m_main);
        this.m_widgetType = WidgetType.principalwidget;
        this.m_principalTypeSelect = new ComboBox();
        this.m_principalTypeSelect.setWidth("150px");
        LinkedHashMap<String, String> principalTypes = new LinkedHashMap<String, String>();
        principalTypes.put("USER", CmsVaadinUtils.getMessageText("GUI_LABEL_USER_0", new Object[0]));
        principalTypes.put("GROUP", CmsVaadinUtils.getMessageText("GUI_LABEL_GROUP_0", new Object[0]));
        CmsVaadinUtils.prepareComboBox(this.m_principalTypeSelect, principalTypes);
        this.m_principalTypeSelect.setNewItemsAllowed(false);
        this.m_principalTypeSelect.setNullSelectionAllowed(false);
        this.m_principalTypeSelect.select((Object)"USER");
        this.m_main.addComponent((Component)this.m_principalTypeSelect);
        this.m_principalName = new TextField();
        this.m_principalName.setWidth("100%");
        this.m_main.addComponent((Component)this.m_principalName);
        this.m_main.setExpandRatio((Component)this.m_principalName, 2.0f);
        this.m_selectPrincipalButton = new Button((Resource)FontAwesome.USER);
        this.m_selectPrincipalButton.addStyleName("o-button-icon");
        this.m_selectPrincipalButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsPrincipalSelect.this.openPrincipalSelect();
            }
        });
        this.m_main.addComponent((Component)this.m_selectPrincipalButton);
    }

    public void addListener(Property.ValueChangeListener listener) {
        this.m_principalName.addListener(listener);
    }

    public void addValidator(Validator validator) {
        this.m_principalName.addValidator(validator);
    }

    public void addValueChangeListener(Property.ValueChangeListener listener) {
        this.m_principalName.addValueChangeListener(listener);
    }

    public void clear() {
        this.m_principalName.clear();
    }

    public void commit() throws Buffered.SourceException, Validator.InvalidValueException {
        this.m_principalName.commit();
    }

    public void discard() throws Buffered.SourceException {
        this.m_principalName.discard();
    }

    public void focus() {
        this.m_principalName.focus();
    }

    public Property getPropertyDataSource() {
        return this.m_principalName.getPropertyDataSource();
    }

    public String getRequiredError() {
        return this.m_principalName.getRequiredError();
    }

    public int getTabIndex() {
        return this.m_principalName.getTabIndex();
    }

    public Class<? extends String> getType() {
        return this.m_principalName.getType();
    }

    public Collection<Validator> getValidators() {
        return this.m_principalName.getValidators();
    }

    public String getValue() {
        return (String)this.m_principalName.getValue();
    }

    public boolean isBuffered() {
        return this.m_principalName.isBuffered();
    }

    public boolean isEmpty() {
        return this.m_principalName.isEmpty();
    }

    public boolean isInvalidAllowed() {
        return this.m_principalName.isInvalidAllowed();
    }

    public boolean isInvalidCommitted() {
        return this.m_principalName.isInvalidCommitted();
    }

    public boolean isModified() {
        return this.m_principalName.isModified();
    }

    public boolean isRequired() {
        return this.m_principalName.isRequired();
    }

    public boolean isValid() {
        return this.m_principalName.isValid();
    }

    public void removeAllValidators() {
        this.m_principalName.removeAllValidators();
    }

    public void removeListener(Property.ValueChangeListener listener) {
        this.m_principalName.removeListener(listener);
    }

    public void removeValidator(Validator validator) {
        this.m_principalName.removeValidator(validator);
    }

    public void removeValueChangeListener(Property.ValueChangeListener listener) {
        this.m_principalName.removeValueChangeListener(listener);
    }

    public void setBuffered(boolean buffered) {
        this.m_principalName.setBuffered(buffered);
    }

    public void setInvalidAllowed(boolean invalidValueAllowed) throws UnsupportedOperationException {
        this.m_principalName.setInvalidAllowed(invalidValueAllowed);
    }

    public void setInvalidCommitted(boolean isCommitted) {
        this.m_principalName.setInvalidCommitted(isCommitted);
    }

    public void setMargin(boolean enabled) {
        ((HorizontalLayout)this.getCompositionRoot()).setMargin(enabled);
    }

    public void setPrincipalType(String type) {
        this.m_principalName.setValue("");
        this.m_principalTypeSelect.setValue((Object)type);
    }

    public void setPropertyDataSource(Property newDataSource) {
        this.m_principalName.setPropertyDataSource(newDataSource);
    }

    public void setRealPrincipalsOnly(boolean realOnly) {
        this.m_realOnly = realOnly;
    }

    public void setRequired(boolean required) {
        this.m_principalName.setRequired(required);
    }

    public void setRequiredError(String requiredMessage) {
        this.m_principalName.setRequiredError(requiredMessage);
    }

    public void setRoleSelectionAllowed(boolean editRoles) {
        this.m_principalTypeSelect.removeItem((Object)"ROLE");
        if (editRoles) {
            Item item = this.m_principalTypeSelect.addItem((Object)"ROLE");
            String roleText = CmsVaadinUtils.getMessageText("GUI_LABEL_ROLE_0", new Object[0]);
            item.getItemProperty((Object)"label").setValue((Object)roleText);
        }
        this.m_principalTypeSelect.setNewItemsAllowed(!editRoles);
    }

    public void setSelectHandler(PrincipalSelectHandler selectHandler) {
        this.m_selectHandler = selectHandler;
        this.enableSetButton(this.m_selectHandler != null);
    }

    public void setTabIndex(int tabIndex) {
        this.m_principalName.setTabIndex(tabIndex);
    }

    public void setValue(String newValue) throws Property.ReadOnlyException {
        this.m_principalName.setValue(newValue);
    }

    public void setWidgetType(WidgetType type) {
        this.m_widgetType = type;
        this.m_principalTypeSelect.setVisible(this.m_widgetType.equals((Object)WidgetType.principalwidget));
    }

    public void validate() throws Validator.InvalidValueException {
        this.m_principalName.validate();
    }

    public void valueChange(Property.ValueChangeEvent event) {
        this.m_principalName.valueChange(event);
    }

    protected void closeWindow() {
        if (this.m_window != null) {
            this.m_window.close();
            this.m_window = null;
        }
    }

    protected void setPrincipal(int type, String principalName) {
        this.m_principalName.setValue(principalName);
        String typeName = null;
        switch (type) {
            case 0: {
                typeName = "GROUP";
                break;
            }
            case 1: {
                typeName = "USER";
            }
        }
        if (typeName != null) {
            this.m_principalTypeSelect.setValue((Object)typeName);
        }
    }

    void onSelect() {
        if (this.m_selectHandler != null) {
            String principalType = (String)this.m_principalTypeSelect.getValue();
            if (CmsVaadinUtils.getMessageText("GUI_LABEL_ROLE_0", new Object[0]).equals(principalType)) {
                principalType = "ROLE";
            }
            this.m_selectHandler.onPrincipalSelect(principalType, (String)this.m_principalName.getValue());
        }
    }

    void openPrincipalSelect() {
        String parameters = "?type=" + this.m_widgetType.name() + "&realonly=" + this.m_realOnly + "&flags=null&action=listindependentaction&useparent=true&listaction=";
        parameters = this.m_widgetType.equals((Object)WidgetType.principalwidget) && "GROUP".equals(this.m_principalTypeSelect.getValue()) || this.m_widgetType.equals((Object)WidgetType.groupwidget) ? parameters + "iag" : parameters + "iau";
        BrowserFrame selectFrame = new BrowserFrame("Select principal", (Resource)new ExternalResource(OpenCms.getLinkManager().substituteLinkForUnknownTarget(A_CmsUI.getCmsObject(), "/system/workplace/commons/principal_selection.jsp") + parameters));
        selectFrame.setWidth("100%");
        selectFrame.setHeight("500px");
        CmsBasicDialog dialog = new CmsBasicDialog();
        dialog.setContent((Component)selectFrame);
        this.m_window = CmsBasicDialog.prepareWindow();
        this.m_window.setCaption(CmsVaadinUtils.getMessageText("GUI_PRINCIPALSELECTION_LIST_ACTION_SELECT_NAME_0", new Object[0]));
        this.m_window.setContent((Component)dialog);
        A_CmsUI.get().addWindow(this.m_window);
        CmsPrincipalSelectExtension.getInstance().setCurrentSelect(this);
    }

    private void enableSetButton(boolean enabled) {
        if (enabled) {
            if (this.m_addPermissionSetButton == null) {
                this.m_addPermissionSetButton = new Button((Resource)FontAwesome.PLUS);
                this.m_addPermissionSetButton.addStyleName("o-button-icon");
                this.m_addPermissionSetButton.addClickListener(new Button.ClickListener(){
                    private static final long serialVersionUID = 1L;

                    public void buttonClick(Button.ClickEvent event) {
                        CmsPrincipalSelect.this.onSelect();
                    }
                });
                this.m_main.addComponent((Component)this.m_addPermissionSetButton);
            }
        } else if (this.m_addPermissionSetButton != null) {
            this.m_main.removeComponent((Component)this.m_addPermissionSetButton);
            this.m_addPermissionSetButton = null;
        }
    }

    public static enum WidgetType {
        groupwidget,
        principalwidget,
        userwidget;

    }

    public static interface PrincipalSelectHandler {
        public void onPrincipalSelect(String var1, String var2);
    }
}

