/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.editors;

import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Component;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.I_CmsAppUIContext;
import org.opencms.ui.components.CmsBrowserFrame;
import org.opencms.ui.components.CmsConfirmationDialog;
import org.opencms.ui.editors.CmsEditorStateExtension;
import org.opencms.ui.editors.I_CmsEditor;

public abstract class A_CmsFrameEditor
implements I_CmsEditor,
ViewChangeListener {
    private static final Log LOG = CmsLog.getLog(A_CmsFrameEditor.class);
    private static final long serialVersionUID = 6944345583913510988L;
    protected CmsEditorStateExtension m_editorState;
    boolean m_leaving;
    CmsResource m_resource;
    private CmsBrowserFrame m_frame;

    public void afterViewChange(ViewChangeListener.ViewChangeEvent event) {
    }

    public boolean beforeViewChange(final ViewChangeListener.ViewChangeEvent event) {
        if (!this.m_leaving && this.m_editorState.hasChanges()) {
            final String target = event.getViewName();
            CmsConfirmationDialog.show(CmsVaadinUtils.getMessageText("GUI_EDITOR_CLOSE_CAPTION_0", new Object[0]), CmsVaadinUtils.getMessageText("GUI_EDITOR_CLOSE_TEXT_0", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    A_CmsFrameEditor.this.leaveEditor(event.getNavigator(), target);
                }
            });
            return false;
        }
        if (!this.m_leaving) {
            this.tryUnlock();
        }
        return true;
    }

    @Override
    public void initUI(I_CmsAppUIContext context, CmsResource resource, String backLink) {
        this.m_resource = resource;
        CmsObject cms = A_CmsUI.getCmsObject();
        String sitepath = cms.getSitePath(this.m_resource);
        String link = OpenCms.getLinkManager().substituteLinkForRootPath(cms, this.getEditorUri());
        this.m_frame = new CmsBrowserFrame();
        this.m_frame.setDescription("Editor");
        this.m_frame.setName("edit");
        this.m_frame.setSource((Resource)new ExternalResource(link + "?resource=" + sitepath + "&backlink=" + backLink));
        this.m_frame.setSizeFull();
        context.showInfoArea(false);
        context.hideToolbar();
        this.m_frame.addStyleName("o-editor-frame");
        context.setAppContent((Component)this.m_frame);
        context.setAppTitle(CmsVaadinUtils.getMessageText("GUI_CONTENT_EDITOR_TITLE_2", resource.getName(), CmsResource.getParentFolder(sitepath)));
        this.m_editorState = new CmsEditorStateExtension((AbstractComponent)this.m_frame);
    }

    protected abstract String getEditorUri();

    void leaveEditor(Navigator navigator, String target) {
        this.m_leaving = true;
        this.tryUnlock();
        navigator.navigateTo(target);
    }

    private void tryUnlock() {
        if (this.m_resource != null) {
            try {
                A_CmsUI.getCmsObject().unlockResource(this.m_resource);
            }
            catch (CmsException e) {
                LOG.debug((Object)("Unlocking resource " + this.m_resource.getRootPath() + " failed"), (Throwable)e);
            }
        }
    }
}

