/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.editors;

import org.apache.commons.logging.Log;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.editors.A_CmsFrameEditor;
import org.opencms.ui.editors.I_CmsEditor;
import org.opencms.workplace.editors.CmsWorkplaceEditorManager;

public class CmsAcaciaEditor
extends A_CmsFrameEditor {
    private static final long serialVersionUID = -5498365579090634771L;
    private static final Log LOG = CmsLog.getLog(CmsAcaciaEditor.class);

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public boolean matchesResource(CmsResource resource, boolean plainText) {
        I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(resource);
        boolean result = false;
        if (!plainText && type instanceof CmsResourceTypeXmlContent) {
            try {
                result = CmsWorkplaceEditorManager.checkAcaciaEditorAvailable(A_CmsUI.getCmsObject(), resource);
            }
            catch (CmsException e) {
                LOG.error((Object)"Error evaluating XML schema for acacia editor.", (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public I_CmsEditor newInstance() {
        return new CmsAcaciaEditor();
    }

    @Override
    protected String getEditorUri() {
        return "/system/workplace/editors/acacia/editor.jsp";
    }
}

