/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.editors.messagebundle;

import com.vaadin.annotations.Theme;
import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.IndexedContainer;
import com.vaadin.event.Action;
import com.vaadin.event.ContextClickEvent;
import com.vaadin.event.ShortcutAction;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.Resource;
import com.vaadin.server.VaadinServlet;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomTable;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TableFieldFactory;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsUIServlet;
import org.opencms.main.OpenCms;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.CmsEditor;
import org.opencms.ui.apps.I_CmsAppUIContext;
import org.opencms.ui.apps.I_CmsHasShortcutActions;
import org.opencms.ui.components.CmsConfirmationDialog;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.CmsToolBar;
import org.opencms.ui.components.I_CmsWindowCloseListener;
import org.opencms.ui.contextmenu.CmsContextMenu;
import org.opencms.ui.editors.I_CmsEditor;
import org.opencms.ui.editors.messagebundle.CmsMessageBundleEditorFilterDecorator;
import org.opencms.ui.editors.messagebundle.CmsMessageBundleEditorModel;
import org.opencms.ui.editors.messagebundle.CmsMessageBundleEditorOptions;
import org.opencms.ui.editors.messagebundle.CmsMessageBundleEditorTypes;
import org.opencms.ui.editors.messagebundle.Messages;
import org.tepi.filtertable.FilterDecorator;
import org.tepi.filtertable.FilterTable;

@Theme(value="opencms")
public class CmsMessageBundleEditor
implements I_CmsEditor,
I_CmsWindowCloseListener,
ViewChangeListener,
CmsMessageBundleEditorTypes.I_EntryChangeListener,
CmsMessageBundleEditorTypes.I_ItemDeletionListener,
CmsMessageBundleEditorTypes.I_OptionListener,
I_CmsHasShortcutActions {
    private static final long serialVersionUID = 5366955716462191580L;
    private static final Log LOG = CmsLog.getLog(CmsMessageBundleEditor.class);
    private static final Action ACTION_SAVE = new ShortcutAction("Ctrl+S", 83, new int[]{17});
    private static final Action ACTION_SAVE_AND_EXIT = new ShortcutAction("Ctrl+Shift+S", 83, new int[]{17, 16});
    private static final Action ACTION_EXIT = new ShortcutAction("Ctrl+X", 88, new int[]{17, 16});
    Map<Action, Runnable> m_shortcutActions;
    CmsMessages m_messages;
    CmsMessageBundleEditorModel.ConfigurableMessages m_configurableMessages;
    private final Map<CmsMessageBundleEditorTypes.EditMode, CmsMessageBundleEditorTypes.TranslateTableFieldFactory> m_fieldFactories = new HashMap<CmsMessageBundleEditorTypes.EditMode, CmsMessageBundleEditorTypes.TranslateTableFieldFactory>(2);
    private final Map<CmsMessageBundleEditorTypes.EditMode, CmsMessageBundleEditorTypes.TranslateTableCellStyleGenerator> m_styleGenerators = new HashMap<CmsMessageBundleEditorTypes.EditMode, CmsMessageBundleEditorTypes.TranslateTableCellStyleGenerator>(2);
    boolean m_leaving;
    I_CmsAppUIContext m_context;
    CmsMessageBundleEditorModel m_model;
    CmsObject m_cms;
    CmsResource m_resource;
    FilterTable m_table;
    Button m_saveBtn;
    Button m_saveExitBtn;
    CmsMessageBundleEditorTypes.OptionColumnGenerator m_optionsColumn;
    private String m_backLink;
    private CmsMessageBundleEditorOptions m_options;

    public CmsMessageBundleEditor() {
        this.m_shortcutActions = new HashMap<Action, Runnable>();
        this.m_shortcutActions.put(ACTION_SAVE, new Runnable(){

            @Override
            public void run() {
                CmsMessageBundleEditor.this.saveAction();
            }
        });
        this.m_shortcutActions.put(ACTION_SAVE_AND_EXIT, new Runnable(){

            @Override
            public void run() {
                CmsMessageBundleEditor.this.saveAction();
                CmsMessageBundleEditor.this.closeAction();
            }
        });
        this.m_shortcutActions.put(ACTION_EXIT, new Runnable(){

            @Override
            public void run() {
                CmsMessageBundleEditor.this.closeAction();
            }
        });
    }

    public void afterViewChange(ViewChangeListener.ViewChangeEvent event) {
    }

    public boolean beforeViewChange(final ViewChangeListener.ViewChangeEvent event) {
        if (!this.m_leaving && this.m_model.hasChanges()) {
            CmsConfirmationDialog.show(CmsVaadinUtils.getMessageText("GUI_EDITOR_CLOSE_CAPTION_0", new Object[0]), CmsVaadinUtils.getMessageText("GUI_EDITOR_CLOSE_TEXT_0", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    CmsMessageBundleEditor.this.m_leaving = true;
                    event.getNavigator().navigateTo(event.getViewName());
                }
            });
            return false;
        }
        this.cleanUpAction();
        return true;
    }

    @Override
    public int getPriority() {
        return 200;
    }

    @Override
    public Map<Action, Runnable> getShortcutActions() {
        return this.m_shortcutActions;
    }

    @Override
    public boolean handleAddKey(String newKey) {
        boolean canAdd;
        Map<Object, Object> filters = this.getFilters();
        this.m_table.clearFilters();
        boolean bl = canAdd = !this.keyAlreadyExists(newKey);
        if (canAdd) {
            Object copyEntryId = this.m_table.addItem();
            Item copyEntry = this.m_table.getItem(copyEntryId);
            copyEntry.getItemProperty((Object)CmsMessageBundleEditorTypes.TableProperty.KEY).setValue((Object)newKey);
        }
        this.setFilters(filters);
        if (this.m_model.hasDescriptor() | this.m_model.getBundleType().equals((Object)CmsMessageBundleEditorTypes.BundleType.DESCRIPTOR)) {
            this.handleChange((Object)CmsMessageBundleEditorTypes.TableProperty.KEY);
            this.handleChange((Object)CmsMessageBundleEditorTypes.TableProperty.DESCRIPTION);
        }
        return canAdd;
    }

    @Override
    public void handleEntryChange(CmsMessageBundleEditorTypes.EntryChangeEvent event) {
        if (event.getPropertyId().equals((Object)CmsMessageBundleEditorTypes.TableProperty.KEY)) {
            CmsMessageBundleEditorModel.KeyChangeResult result = this.m_model.handleKeyChange(event, true);
            String captionKey = null;
            String descriptionKey = null;
            switch (result) {
                case SUCCESS: {
                    this.handleChange(event.getPropertyId());
                    return;
                }
                case FAILED_DUPLICATED_KEY: {
                    captionKey = "GUI_NOTIFICATION_MESSAGEBUNDLEEDITOR_KEY_ALREADY_EXISTS_CAPTION_0";
                    descriptionKey = "GUI_NOTIFICATION_MESSAGEBUNDLEEDITOR_KEY_ALREADY_EXISTS_DESCRIPTION_0";
                    break;
                }
                case FAILED_FOR_OTHER_LANGUAGE: {
                    captionKey = "GUI_NOTIFICATION_MESSAGEBUNDLEEDITOR_KEY_RENAMING_FAILED_CAPTION_0";
                    descriptionKey = "GUI_NOTIFICATION_MESSAGEBUNDLEEDITOR_KEY_RENAMING_FAILED_DESCRIPTION_0";
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            CmsMessageBundleEditorTypes.showWarning(this.m_messages.key(captionKey), this.m_messages.key(descriptionKey));
            event.getSource().focus();
        }
        this.handleChange(event.getPropertyId());
    }

    @Override
    public boolean handleItemDeletion(CmsMessageBundleEditorTypes.ItemDeletionEvent e) {
        Item it = this.m_table.getItem(e.getItemId());
        Property keyProp = it.getItemProperty((Object)CmsMessageBundleEditorTypes.TableProperty.KEY);
        String key = (String)keyProp.getValue();
        if (this.m_model.handleKeyDeletion(key)) {
            if (this.m_model.hasDescriptor() | this.m_model.getBundleType().equals((Object)CmsMessageBundleEditorTypes.BundleType.DESCRIPTOR)) {
                this.handleChange((Object)CmsMessageBundleEditorTypes.TableProperty.DESCRIPTION);
            }
            this.handleChange((Object)CmsMessageBundleEditorTypes.TableProperty.KEY);
            return true;
        }
        CmsMessageBundleEditorTypes.showWarning(this.m_messages.key("GUI_NOTIFICATION_MESSAGEBUNDLEEDITOR_REMOVE_ENTRY_FAILED_CAPTION_0"), this.m_messages.key("GUI_NOTIFICATION_MESSAGEBUNDLEEDITOR_REMOVE_ENTRY_FAILED_DESCRIPTION_0"));
        return false;
    }

    @Override
    public void handleLanguageChange(Locale locale) {
        if (!locale.equals(this.m_model.getLocale())) {
            Object sortProperty = this.m_table.getSortContainerPropertyId();
            boolean isAcending = this.m_table.isSortAscending();
            Map<Object, Object> filters = this.getFilters();
            this.m_table.clearFilters();
            if (this.m_model.setLocale(locale)) {
                this.m_options.setEditedFilePath(this.m_model.getEditedFilePath());
                this.m_table.sort(new Object[]{sortProperty}, new boolean[]{isAcending});
            } else {
                String caption = this.m_messages.key("GUI_NOTIFICATION_MESSAGEBUNDLEEDITOR_LOCALE_SWITCHING_FAILED_CAPTION_0");
                String description = this.m_messages.key("GUI_NOTIFICATION_MESSAGEBUNDLEEDITOR_LOCALE_SWITCHING_FAILED_DESCRIPTION_0");
                Notification warning = new Notification(caption, description, Notification.Type.WARNING_MESSAGE, true);
                warning.setDelayMsec(-1);
                warning.show(UI.getCurrent().getPage());
                this.m_options.setLanguage(this.m_model.getLocale());
            }
            this.setFilters(filters);
            this.m_table.select(this.m_table.getCurrentPageFirstItemId());
        }
    }

    @Override
    public void handleModeChange(CmsMessageBundleEditorTypes.EditMode mode) {
        this.setEditMode(mode);
    }

    @Override
    public void initUI(I_CmsAppUIContext context, CmsResource resource, String backLink) {
        this.m_cms = ((CmsUIServlet)VaadinServlet.getCurrent()).getCmsObject();
        this.m_messages = Messages.get().getBundle(UI.getCurrent().getLocale());
        this.m_resource = resource;
        this.m_backLink = backLink;
        this.m_context = context;
        try {
            this.m_model = new CmsMessageBundleEditorModel(this.m_cms, this.m_resource);
            this.m_options = new CmsMessageBundleEditorOptions(this.m_model.getLocales(), this.m_model.getLocale(), this.m_model.getEditMode(), this);
            this.m_options.setEditedFilePath(this.m_model.getEditedFilePath());
            this.m_configurableMessages = this.m_model.getConfigurableMessages(this.m_messages, UI.getCurrent().getLocale());
            this.fillToolBar(context);
            context.showInfoArea(false);
            Component main = this.createMainComponent();
            this.initFieldFactories();
            this.initStyleGenerators();
            this.m_table.setTableFieldFactory((TableFieldFactory)this.m_fieldFactories.get((Object)this.m_model.getEditMode()));
            this.m_table.setCellStyleGenerator((CustomTable.CellStyleGenerator)this.m_styleGenerators.get((Object)this.m_model.getEditMode()));
            this.m_optionsColumn.registerItemDeletionListener(this);
            this.adjustVisibleColumns();
            context.setAppContent(main);
            this.adjustFocus();
            if (this.m_model.getSwitchedLocaleOnOpening()) {
                CmsMessageBundleEditorTypes.showWarning(this.m_messages.key("GUI_NOTIFICATION_MESSAGEBUNDLEEDITOR_SWITCHED_LOCALE_CAPTION_0"), this.m_messages.key("GUI_NOTIFICATION_MESSAGEBUNDLEEDITOR_SWITCHED_LOCALE_DESCRIPTION_0"));
            }
        }
        catch (IOException | CmsException e) {
            LOG.error((Object)this.m_messages.key("ERR_LOADING_RESOURCES_0"), (Throwable)e);
            Notification.show((String)this.m_messages.key("ERR_LOADING_RESOURCES_0"), (Notification.Type)Notification.Type.ERROR_MESSAGE);
            this.closeAction();
        }
    }

    @Override
    public boolean matchesResource(CmsResource resource, boolean plainText) {
        if (plainText) {
            return false;
        }
        String resourceTypeName = OpenCms.getResourceManager().getResourceType(resource).getTypeName();
        return CmsMessageBundleEditorTypes.BundleType.toBundleType(resourceTypeName) != null;
    }

    @Override
    public I_CmsEditor newInstance() {
        return new CmsMessageBundleEditor();
    }

    @Override
    public void onWindowClose() {
        this.cleanUpAction();
    }

    void closeAction() {
        CmsEditor.openBackLink(this.m_backLink);
    }

    Map<Object, Object> getFilters() {
        HashMap<Object, Object> result = new HashMap<Object, Object>(4);
        result.put((Object)CmsMessageBundleEditorTypes.TableProperty.KEY, this.m_table.getFilterFieldValue((Object)CmsMessageBundleEditorTypes.TableProperty.KEY));
        result.put((Object)CmsMessageBundleEditorTypes.TableProperty.DEFAULT, this.m_table.getFilterFieldValue((Object)CmsMessageBundleEditorTypes.TableProperty.DEFAULT));
        result.put((Object)CmsMessageBundleEditorTypes.TableProperty.DESCRIPTION, this.m_table.getFilterFieldValue((Object)CmsMessageBundleEditorTypes.TableProperty.DESCRIPTION));
        result.put((Object)CmsMessageBundleEditorTypes.TableProperty.TRANSLATION, this.m_table.getFilterFieldValue((Object)CmsMessageBundleEditorTypes.TableProperty.TRANSLATION));
        return result;
    }

    void publishAction() {
        this.saveAction();
        this.m_model.publish();
    }

    void saveAction() {
        Map<Object, Object> filters = this.getFilters();
        this.m_table.clearFilters();
        try {
            this.m_model.save();
            this.disableSaveButtons();
        }
        catch (CmsException e) {
            LOG.error((Object)this.m_messages.key("ERR_SAVING_CHANGES_0"), (Throwable)e);
            CmsErrorDialog.showErrorDialog(this.m_messages.key("ERR_SAVING_CHANGES_0"), e);
        }
        this.setFilters(filters);
    }

    boolean setEditMode(CmsMessageBundleEditorTypes.EditMode newMode) {
        CmsMessageBundleEditorTypes.EditMode oldMode = this.m_model.getEditMode();
        boolean success = false;
        if (!newMode.equals((Object)oldMode)) {
            Map<Object, Object> filters = this.getFilters();
            this.m_table.clearFilters();
            if (this.m_model.setEditMode(newMode)) {
                this.m_table.setTableFieldFactory((TableFieldFactory)this.m_fieldFactories.get((Object)newMode));
                this.m_table.setCellStyleGenerator((CustomTable.CellStyleGenerator)this.m_styleGenerators.get((Object)newMode));
                this.adjustOptionsColumn(oldMode, newMode);
                this.m_options.updateShownOptions(this.m_model.hasMasterMode(), this.m_model.canAddKeys());
                this.m_options.setEditMode(newMode);
                success = true;
            } else {
                Notification.show((String)this.m_messages.key("ERR_MODE_CHANGE_NOT_POSSIBLE_0"), (Notification.Type)Notification.Type.ERROR_MESSAGE);
            }
            this.setFilters(filters);
            this.adjustFocus();
        }
        return success;
    }

    void setFilters(Map<Object, Object> filters) {
        for (Object column : filters.keySet()) {
            Object filterValue = filters.get(column);
            if (filterValue == null || filterValue.toString().isEmpty() || this.m_table.isColumnCollapsed(column)) continue;
            this.m_table.setFilterFieldValue(column, filterValue);
        }
    }

    private void adjustFocus() {
        ((Component.Focusable)this.m_table.getFilterField((Object)CmsMessageBundleEditorTypes.TableProperty.KEY)).focus();
    }

    private void adjustOptionsColumn(CmsMessageBundleEditorTypes.EditMode oldMode, CmsMessageBundleEditorTypes.EditMode newMode) {
        if (this.m_model.isShowOptionsColumn(oldMode) != this.m_model.isShowOptionsColumn(newMode)) {
            this.m_table.removeGeneratedColumn((Object)CmsMessageBundleEditorTypes.TableProperty.OPTIONS);
            if (this.m_model.isShowOptionsColumn(newMode)) {
                this.m_table.setFilterFieldVisible((Object)CmsMessageBundleEditorTypes.TableProperty.OPTIONS, false);
                this.m_table.addGeneratedColumn((Object)CmsMessageBundleEditorTypes.TableProperty.OPTIONS, (CustomTable.ColumnGenerator)this.m_optionsColumn);
            }
        }
    }

    private void adjustVisibleColumns() {
        if (this.m_table.isColumnCollapsingAllowed()) {
            if (this.m_model.hasDefaultValues() || this.m_model.getBundleType().equals((Object)CmsMessageBundleEditorTypes.BundleType.DESCRIPTOR)) {
                this.m_table.setColumnCollapsed((Object)CmsMessageBundleEditorTypes.TableProperty.DEFAULT, false);
            } else {
                this.m_table.setColumnCollapsed((Object)CmsMessageBundleEditorTypes.TableProperty.DEFAULT, true);
            }
            if (this.m_model.getEditMode().equals((Object)CmsMessageBundleEditorTypes.EditMode.MASTER) || this.m_model.hasDescriptionValues() || this.m_model.getBundleType().equals((Object)CmsMessageBundleEditorTypes.BundleType.DESCRIPTOR)) {
                this.m_table.setColumnCollapsed((Object)CmsMessageBundleEditorTypes.TableProperty.DESCRIPTION, false);
            } else {
                this.m_table.setColumnCollapsed((Object)CmsMessageBundleEditorTypes.TableProperty.DESCRIPTION, true);
            }
        }
    }

    private void cleanUpAction() {
        try {
            this.m_model.deleteDescriptorIfNecessary();
        }
        catch (CmsException e) {
            LOG.error((Object)this.m_messages.key("ERR_DELETING_DESCRIPTOR_0"), (Throwable)e);
        }
        try {
            this.m_model.unlock();
        }
        catch (CmsException e) {
            LOG.error((Object)this.m_messages.key("ERR_UNLOCKING_RESOURCES_0"), (Throwable)e);
        }
    }

    private Component createAddDescriptorButton() {
        Button addDescriptorButton = CmsToolBar.createButton((Resource)FontOpenCms.COPY_LOCALE, this.m_messages.key("GUI_ADD_DESCRIPTOR_0"));
        addDescriptorButton.setDisableOnClick(true);
        addDescriptorButton.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                Map<Object, Object> filters = CmsMessageBundleEditor.this.getFilters();
                CmsMessageBundleEditor.this.m_table.clearFilters();
                if (!CmsMessageBundleEditor.this.m_model.addDescriptor()) {
                    CmsVaadinUtils.showAlert(CmsMessageBundleEditor.this.m_messages.key("ERR_BUNDLE_DESCRIPTOR_CREATION_FAILED_0"), CmsMessageBundleEditor.this.m_messages.key("ERR_BUNDLE_DESCRIPTOR_CREATION_FAILED_DESCRIPTION_0"), null);
                } else {
                    IndexedContainer newContainer = null;
                    try {
                        newContainer = CmsMessageBundleEditor.this.m_model.getContainerForCurrentLocale();
                        CmsMessageBundleEditor.this.m_table.setContainerDataSource((Container)newContainer);
                        CmsMessageBundleEditor.this.initFieldFactories();
                        CmsMessageBundleEditor.this.initStyleGenerators();
                        CmsMessageBundleEditor.this.setEditMode(CmsMessageBundleEditorTypes.EditMode.MASTER);
                        CmsMessageBundleEditor.this.m_table.setColumnCollapsingAllowed(true);
                        CmsMessageBundleEditor.this.adjustVisibleColumns();
                        CmsMessageBundleEditor.this.m_options.updateShownOptions(CmsMessageBundleEditor.this.m_model.hasMasterMode(), CmsMessageBundleEditor.this.m_model.canAddKeys());
                        CmsMessageBundleEditor.this.m_options.setEditMode(CmsMessageBundleEditor.this.m_model.getEditMode());
                    }
                    catch (IOException | CmsException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                CmsMessageBundleEditor.this.setFilters(filters);
            }
        });
        return addDescriptorButton;
    }

    private Component createCloseButton() {
        Button closeBtn = CmsToolBar.createButton((Resource)FontOpenCms.CIRCLE_INV_CANCEL, this.m_messages.key("GUI_BUTTON_CANCEL_0"));
        closeBtn.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                CmsMessageBundleEditor.this.closeAction();
            }
        });
        return closeBtn;
    }

    private Component createConvertToPropertyBundleButton() {
        Button addDescriptorButton = CmsToolBar.createButton((Resource)FontOpenCms.SETTINGS, this.m_messages.key("GUI_CONVERT_TO_PROPERTY_BUNDLE_0"));
        addDescriptorButton.setDisableOnClick(true);
        addDescriptorButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                try {
                    CmsMessageBundleEditor.this.m_model.saveAsPropertyBundle();
                    Notification.show((String)"Conversion successful.");
                }
                catch (IOException | CmsException e) {
                    CmsVaadinUtils.showAlert("Conversion failed", e.getLocalizedMessage(), null);
                }
            }
        });
        addDescriptorButton.setDisableOnClick(true);
        return addDescriptorButton;
    }

    private Component createMainComponent() throws IOException, CmsException {
        VerticalLayout mainComponent = new VerticalLayout();
        mainComponent.setSizeFull();
        mainComponent.addStyleName("o-message-bundle-editor");
        this.m_table = this.createTable();
        Panel navigator = new Panel();
        navigator.setSizeFull();
        navigator.setContent((Component)this.m_table);
        navigator.addActionHandler((Action.Handler)new CmsMessageBundleEditorTypes.TableKeyboardHandler(this.m_table));
        navigator.addStyleName("v-panel-borderless");
        mainComponent.addComponent(this.m_options.getOptionsComponent());
        mainComponent.addComponent((Component)navigator);
        mainComponent.setExpandRatio((Component)navigator, 1.0f);
        this.m_options.updateShownOptions(this.m_model.hasMasterMode(), this.m_model.canAddKeys());
        return mainComponent;
    }

    private Component createPublishButton() {
        Button publishBtn = CmsToolBar.createButton((Resource)FontOpenCms.PUBLISH, this.m_messages.key("GUI_BUTTON_PUBLISH_0"));
        publishBtn.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                CmsMessageBundleEditor.this.publishAction();
            }
        });
        return publishBtn;
    }

    private Button createSaveButton() {
        Button saveBtn = CmsToolBar.createButton((Resource)FontOpenCms.SAVE, this.m_messages.key("GUI_BUTTON_SAVE_0"));
        saveBtn.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                CmsMessageBundleEditor.this.saveAction();
            }
        });
        saveBtn.setEnabled(false);
        return saveBtn;
    }

    private Button createSaveExitButton() {
        Button saveExitBtn = CmsToolBar.createButton((Resource)FontOpenCms.SAVE_EXIT, this.m_messages.key("GUI_BUTTON_SAVE_AND_EXIT_0"));
        saveExitBtn.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                CmsMessageBundleEditor.this.saveAction();
                CmsMessageBundleEditor.this.closeAction();
            }
        });
        saveExitBtn.setEnabled(false);
        return saveExitBtn;
    }

    private FilterTable createTable() throws IOException, CmsException {
        FilterTable table = new FilterTable();
        table.setSizeFull();
        table.setContainerDataSource((Container)this.m_model.getContainerForCurrentLocale());
        table.setColumnHeader((Object)CmsMessageBundleEditorTypes.TableProperty.KEY, this.m_configurableMessages.getColumnHeader(CmsMessageBundleEditorTypes.TableProperty.KEY));
        table.setColumnCollapsible((Object)CmsMessageBundleEditorTypes.TableProperty.KEY, false);
        table.setColumnHeader((Object)CmsMessageBundleEditorTypes.TableProperty.DEFAULT, this.m_configurableMessages.getColumnHeader(CmsMessageBundleEditorTypes.TableProperty.DEFAULT));
        table.setColumnCollapsible((Object)CmsMessageBundleEditorTypes.TableProperty.DEFAULT, true);
        table.setColumnHeader((Object)CmsMessageBundleEditorTypes.TableProperty.DESCRIPTION, this.m_configurableMessages.getColumnHeader(CmsMessageBundleEditorTypes.TableProperty.DESCRIPTION));
        table.setColumnCollapsible((Object)CmsMessageBundleEditorTypes.TableProperty.DESCRIPTION, true);
        table.setColumnHeader((Object)CmsMessageBundleEditorTypes.TableProperty.TRANSLATION, this.m_configurableMessages.getColumnHeader(CmsMessageBundleEditorTypes.TableProperty.TRANSLATION));
        table.setColumnCollapsible((Object)CmsMessageBundleEditorTypes.TableProperty.TRANSLATION, false);
        table.setColumnHeader((Object)CmsMessageBundleEditorTypes.TableProperty.OPTIONS, this.m_configurableMessages.getColumnHeader(CmsMessageBundleEditorTypes.TableProperty.OPTIONS));
        table.setFilterDecorator((FilterDecorator)new CmsMessageBundleEditorFilterDecorator());
        table.setFilterBarVisible(true);
        table.setColumnCollapsible((Object)CmsMessageBundleEditorTypes.TableProperty.OPTIONS, false);
        table.setSortEnabled(true);
        table.setEditable(true);
        table.setSelectable(true);
        table.setImmediate(true);
        table.setMultiSelect(false);
        table.setColumnCollapsingAllowed(this.m_model.hasDescriptor());
        table.setColumnReorderingAllowed(false);
        this.m_optionsColumn = this.generateOptionsColumn((CustomTable)table);
        if (this.m_model.isShowOptionsColumn(this.m_model.getEditMode())) {
            table.setFilterFieldVisible((Object)CmsMessageBundleEditorTypes.TableProperty.OPTIONS, false);
            table.addGeneratedColumn((Object)CmsMessageBundleEditorTypes.TableProperty.OPTIONS, (CustomTable.ColumnGenerator)this.m_optionsColumn);
        }
        table.setColumnWidth((Object)CmsMessageBundleEditorTypes.TableProperty.OPTIONS, 42);
        table.setColumnExpandRatio((Object)CmsMessageBundleEditorTypes.TableProperty.KEY, 1.0f);
        table.setColumnExpandRatio((Object)CmsMessageBundleEditorTypes.TableProperty.DESCRIPTION, 1.0f);
        table.setColumnExpandRatio((Object)CmsMessageBundleEditorTypes.TableProperty.DEFAULT, 1.0f);
        table.setColumnExpandRatio((Object)CmsMessageBundleEditorTypes.TableProperty.TRANSLATION, 1.0f);
        table.setPageLength(30);
        table.setCacheRate(1.0);
        table.sort(new Object[]{CmsMessageBundleEditorTypes.TableProperty.KEY}, new boolean[]{true});
        table.addContextClickListener(new ContextClickEvent.ContextClickListener(){
            private static final long serialVersionUID = 1L;

            public void contextClick(ContextClickEvent event) {
                Object itemId = CmsMessageBundleEditor.this.m_table.getValue();
                CmsContextMenu contextMenu = CmsMessageBundleEditor.this.m_model.getContextMenuForItem(itemId);
                if (null != contextMenu) {
                    contextMenu.setAsContextMenuOf((AbstractClientConnector)CmsMessageBundleEditor.this.m_table);
                    contextMenu.setOpenAutomatically(false);
                    contextMenu.open(event.getClientX(), event.getClientY());
                }
            }
        });
        table.setNullSelectionAllowed(false);
        table.select(table.getCurrentPageFirstItemId());
        return table;
    }

    private void disableSaveButtons() {
        if (this.m_saveBtn.isEnabled()) {
            this.m_saveBtn.setEnabled(false);
            this.m_saveExitBtn.setEnabled(false);
        }
    }

    private void fillToolBar(I_CmsAppUIContext context) {
        context.setAppTitle(this.m_messages.key("GUI_APP_TITLE_0"));
        Component publishBtn = this.createPublishButton();
        this.m_saveBtn = this.createSaveButton();
        this.m_saveExitBtn = this.createSaveExitButton();
        Component closeBtn = this.createCloseButton();
        context.enableDefaultToolbarButtons(false);
        context.addToolbarButtonRight(closeBtn);
        context.addToolbarButton(publishBtn);
        context.addToolbarButton((Component)this.m_saveExitBtn);
        context.addToolbarButton((Component)this.m_saveBtn);
        Component addDescriptorBtn = this.createAddDescriptorButton();
        if (this.m_model.hasDescriptor() || this.m_model.getBundleType().equals((Object)CmsMessageBundleEditorTypes.BundleType.DESCRIPTOR)) {
            addDescriptorBtn.setEnabled(false);
        }
        context.addToolbarButton(addDescriptorBtn);
        if (this.m_model.getBundleType().equals((Object)CmsMessageBundleEditorTypes.BundleType.XML)) {
            Component convertToPropertyBundleBtn = this.createConvertToPropertyBundleButton();
            context.addToolbarButton(convertToPropertyBundleBtn);
        }
    }

    private CmsMessageBundleEditorTypes.OptionColumnGenerator generateOptionsColumn(CustomTable table) {
        return new CmsMessageBundleEditorTypes.OptionColumnGenerator(table);
    }

    private void handleChange(Object propertyId) {
        if (!this.m_saveBtn.isEnabled()) {
            this.m_saveBtn.setEnabled(true);
            this.m_saveExitBtn.setEnabled(true);
        }
        this.m_model.handleChange(propertyId);
    }

    private void initFieldFactories() {
        if (this.m_model.hasMasterMode()) {
            CmsMessageBundleEditorTypes.TranslateTableFieldFactory masterFieldFactory = new CmsMessageBundleEditorTypes.TranslateTableFieldFactory((CustomTable)this.m_table, this.m_model.getEditableColumns(CmsMessageBundleEditorTypes.EditMode.MASTER));
            masterFieldFactory.registerKeyChangeListener(this);
            this.m_fieldFactories.put(CmsMessageBundleEditorTypes.EditMode.MASTER, masterFieldFactory);
        }
        CmsMessageBundleEditorTypes.TranslateTableFieldFactory defaultFieldFactory = new CmsMessageBundleEditorTypes.TranslateTableFieldFactory((CustomTable)this.m_table, this.m_model.getEditableColumns(CmsMessageBundleEditorTypes.EditMode.DEFAULT));
        defaultFieldFactory.registerKeyChangeListener(this);
        this.m_fieldFactories.put(CmsMessageBundleEditorTypes.EditMode.DEFAULT, defaultFieldFactory);
    }

    private void initStyleGenerators() {
        if (this.m_model.hasMasterMode()) {
            this.m_styleGenerators.put(CmsMessageBundleEditorTypes.EditMode.MASTER, new CmsMessageBundleEditorTypes.TranslateTableCellStyleGenerator(this.m_model.getEditableColumns(CmsMessageBundleEditorTypes.EditMode.MASTER)));
        }
        this.m_styleGenerators.put(CmsMessageBundleEditorTypes.EditMode.DEFAULT, new CmsMessageBundleEditorTypes.TranslateTableCellStyleGenerator(this.m_model.getEditableColumns(CmsMessageBundleEditorTypes.EditMode.DEFAULT)));
    }

    private boolean keyAlreadyExists(String newKey) {
        Collection itemIds = this.m_table.getItemIds();
        for (Object itemId : itemIds) {
            if (!this.m_table.getItem(itemId).getItemProperty((Object)CmsMessageBundleEditorTypes.TableProperty.KEY).getValue().equals(newKey)) continue;
            return true;
        }
        return false;
    }
}

