/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.editors.messagebundle;

import com.vaadin.data.Property;
import com.vaadin.event.FieldEvents;
import com.vaadin.event.ShortcutListener;
import com.vaadin.server.Resource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import java.util.Collection;
import java.util.Locale;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessages;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.editors.messagebundle.CmsMessageBundleEditorTypes;
import org.opencms.ui.editors.messagebundle.Messages;

public class CmsMessageBundleEditorOptions {
    CmsMessages m_messages = Messages.get().getBundle(UI.getCurrent().getLocale());
    private GridLayout m_optionsComponent;
    private HorizontalLayout m_upperLeftComponent;
    private Component m_lowerLeftComponent;
    private Component m_lowerRightComponent;
    private ComboBox m_languageSelect;
    private Component m_languageSwitch;
    private Component m_modeSwitch;
    private ComboBox m_modeSelect;
    private Component m_filePathLabel;
    private TextField m_filePathField;
    TextField m_addKeyInput;
    private boolean m_showModeSwitch;
    private boolean m_showAddKeyOption;
    CmsMessageBundleEditorTypes.I_OptionListener m_listener;

    public CmsMessageBundleEditorOptions(Collection<Locale> locales, Locale currentLocale, CmsMessageBundleEditorTypes.EditMode currentMode, CmsMessageBundleEditorTypes.I_OptionListener optionListener) {
        this.m_listener = optionListener;
        this.initLanguageSwitch(locales, currentLocale);
        this.initModeSwitch(currentMode);
        this.initFilePathLabel();
        this.initUpperLeftComponent();
        this.initLowerLeftComponent();
        this.initLowerRightComponent();
        this.initOptionsComponent();
    }

    public boolean focusAddKey() {
        if (this.m_showAddKeyOption) {
            this.m_addKeyInput.focus();
        }
        return this.m_showAddKeyOption;
    }

    public Component getOptionsComponent() {
        return this.m_optionsComponent;
    }

    public void setEditedFilePath(String editedFilePath) {
        this.m_filePathField.setReadOnly(false);
        this.m_filePathField.setValue(editedFilePath);
        this.m_filePathField.setReadOnly(true);
    }

    public void setEditMode(CmsMessageBundleEditorTypes.EditMode mode) {
        if (!this.m_modeSelect.getValue().equals((Object)mode)) {
            this.m_modeSelect.setValue((Object)mode);
        }
    }

    public void updateShownOptions(boolean showModeSwitch, boolean showAddKeyOption) {
        if (showModeSwitch != this.m_showModeSwitch) {
            this.m_upperLeftComponent.removeAllComponents();
            this.m_upperLeftComponent.addComponent(this.m_languageSwitch);
            if (showModeSwitch) {
                this.m_upperLeftComponent.addComponent(this.m_modeSwitch);
            }
            this.m_upperLeftComponent.addComponent(this.m_filePathLabel);
            this.m_showModeSwitch = showModeSwitch;
        }
        if (showAddKeyOption != this.m_showAddKeyOption) {
            if (showAddKeyOption) {
                this.m_optionsComponent.addComponent(this.m_lowerLeftComponent, 0, 1);
                this.m_optionsComponent.addComponent(this.m_lowerRightComponent, 1, 1);
            } else {
                this.m_optionsComponent.removeComponent(0, 1);
                this.m_optionsComponent.removeComponent(1, 1);
            }
            this.m_showAddKeyOption = showAddKeyOption;
        }
    }

    void handleAddKey() {
        String key = (String)this.m_addKeyInput.getValue();
        if (this.m_listener.handleAddKey(key)) {
            Notification.show((String)(key.isEmpty() ? this.m_messages.key("GUI_NOTIFICATION_MESSAGEBUNDLEEDITOR_EMPTY_KEY_SUCCESSFULLY_ADDED_0") : this.m_messages.key("GUI_NOTIFICATION_MESSAGEBUNDLEEDITOR_KEY_SUCCESSFULLY_ADDED_1", key)));
        } else {
            CmsMessageBundleEditorTypes.showWarning(this.m_messages.key("GUI_NOTIFICATION_MESSAGEBUNDLEEDITOR_KEY_ALREADEY_EXISTS_CAPTION_0"), this.m_messages.key("GUI_NOTIFICATION_MESSAGEBUNDLEEDITOR_KEY_ALREADEY_EXISTS_DESCRIPTION_1", key));
        }
        this.m_addKeyInput.focus();
        this.m_addKeyInput.selectAll();
    }

    void setLanguage(Locale locale) {
        if (!this.m_languageSelect.getValue().equals(locale)) {
            this.m_languageSelect.setValue((Object)locale);
        }
    }

    private Component createAddKeyButton() {
        Button addKeyButton = new Button();
        addKeyButton.addStyleName("icon-only");
        addKeyButton.addStyleName("borderless-colored");
        addKeyButton.setDescription(this.m_messages.key("GUI_ADD_KEY_0"));
        addKeyButton.setIcon((Resource)FontOpenCms.CIRCLE_PLUS, this.m_messages.key("GUI_ADD_KEY_0"));
        addKeyButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsMessageBundleEditorOptions.this.handleAddKey();
            }
        });
        return addKeyButton;
    }

    private Component createUpperRightComponent() {
        HorizontalLayout upperRight = new HorizontalLayout();
        upperRight.setSizeFull();
        FormLayout fileNameDisplay = new FormLayout();
        fileNameDisplay.setDefaultComponentAlignment(Alignment.MIDDLE_LEFT);
        fileNameDisplay.setSizeFull();
        this.m_filePathField = new TextField();
        this.m_filePathField.setWidth("100%");
        this.m_filePathField.setEnabled(true);
        this.m_filePathField.setReadOnly(true);
        fileNameDisplay.addComponent((Component)this.m_filePathField);
        fileNameDisplay.setSpacing(true);
        FormLayout filePathDisplay = new FormLayout();
        filePathDisplay.setDefaultComponentAlignment(Alignment.MIDDLE_LEFT);
        filePathDisplay.setSizeFull();
        filePathDisplay.addComponent((Component)this.m_filePathField);
        filePathDisplay.setSpacing(true);
        upperRight.addComponent((Component)filePathDisplay);
        upperRight.setExpandRatio((Component)filePathDisplay, 2.0f);
        HorizontalLayout placeHolder = new HorizontalLayout();
        placeHolder.setWidth("42px");
        upperRight.addComponent((Component)placeHolder);
        return upperRight;
    }

    private void initAddKeyInput() {
        this.m_addKeyInput = new TextField();
        this.m_addKeyInput.setWidth("100%");
        this.m_addKeyInput.setInputPrompt(this.m_messages.key("GUI_INPUT_PROMPT_ADD_KEY_0"));
        final ShortcutListener shortCutListener = new ShortcutListener("Add key via ENTER", 13, null){
            private static final long serialVersionUID = 1L;

            public void handleAction(Object sender, Object target) {
                CmsMessageBundleEditorOptions.this.handleAddKey();
            }
        };
        this.m_addKeyInput.addFocusListener(new FieldEvents.FocusListener(){
            private static final long serialVersionUID = 1L;

            public void focus(FieldEvents.FocusEvent event) {
                CmsMessageBundleEditorOptions.this.m_addKeyInput.addShortcutListener(shortCutListener);
            }
        });
        this.m_addKeyInput.addBlurListener(new FieldEvents.BlurListener(){
            private static final long serialVersionUID = 1L;

            public void blur(FieldEvents.BlurEvent event) {
                CmsMessageBundleEditorOptions.this.m_addKeyInput.removeShortcutListener(shortCutListener);
            }
        });
    }

    private void initFilePathLabel() {
        this.m_filePathLabel = new TextField();
        this.m_filePathLabel.setWidth("100%");
        this.m_filePathLabel.setEnabled(true);
        this.m_filePathLabel.setReadOnly(true);
        this.m_filePathLabel = new Label(this.m_messages.key("GUI_FILENAME_LABEL_0"));
    }

    private void initLanguageSwitch(Collection<Locale> locales, Locale current) {
        FormLayout languages = new FormLayout();
        languages.setHeight("100%");
        languages.setDefaultComponentAlignment(Alignment.MIDDLE_LEFT);
        ComboBox languageSelect = new ComboBox();
        languageSelect.setCaption(this.m_messages.key("GUI_LANGUAGE_SWITCHER_LABEL_0"));
        languageSelect.setNullSelectionAllowed(false);
        for (Locale locale : locales) {
            languageSelect.addItem((Object)locale);
            String caption = locale.getDisplayName(UI.getCurrent().getLocale());
            if (CmsLocaleManager.getDefaultLocale().equals(locale)) {
                caption = caption + " (" + Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_DEFAULT_LOCALE_0") + ")";
            }
            languageSelect.setItemCaption((Object)locale, caption);
        }
        languageSelect.setValue((Object)current);
        languageSelect.setNewItemsAllowed(false);
        languageSelect.setTextInputAllowed(false);
        languageSelect.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsMessageBundleEditorOptions.this.m_listener.handleLanguageChange((Locale)event.getProperty().getValue());
            }
        });
        if (locales.size() == 1) {
            languageSelect.setEnabled(false);
        }
        languages.addComponent((Component)languageSelect);
        this.m_languageSwitch = languages;
    }

    private void initLowerLeftComponent() {
        HorizontalLayout placeHolderLowerLeft = new HorizontalLayout();
        placeHolderLowerLeft.setWidth("100%");
        Label newKeyLabel = new Label(this.m_messages.key("GUI_CAPTION_ADD_KEY_0"));
        newKeyLabel.setWidthUndefined();
        HorizontalLayout lowerLeft = new HorizontalLayout(new Component[]{placeHolderLowerLeft, newKeyLabel});
        lowerLeft.setWidth("100%");
        lowerLeft.setExpandRatio((Component)placeHolderLowerLeft, 1.0f);
        this.m_lowerLeftComponent = lowerLeft;
    }

    private void initLowerRightComponent() {
        this.initAddKeyInput();
        Component addKeyButton = this.createAddKeyButton();
        HorizontalLayout addKeyWrapper = new HorizontalLayout(new Component[]{addKeyButton});
        addKeyWrapper.setComponentAlignment(addKeyButton, Alignment.MIDDLE_CENTER);
        addKeyWrapper.setHeight("100%");
        addKeyWrapper.setWidth("42px");
        FormLayout inputForm = new FormLayout(new Component[]{this.m_addKeyInput});
        inputForm.setWidth("100%");
        HorizontalLayout lowerRight = new HorizontalLayout();
        lowerRight.setWidth("100%");
        lowerRight.addComponent((Component)inputForm);
        lowerRight.addComponent((Component)addKeyWrapper);
        lowerRight.setExpandRatio((Component)inputForm, 1.0f);
        this.m_lowerRightComponent = lowerRight;
    }

    private void initModeSwitch(CmsMessageBundleEditorTypes.EditMode current) {
        FormLayout modes = new FormLayout();
        modes.setHeight("100%");
        modes.setDefaultComponentAlignment(Alignment.MIDDLE_LEFT);
        this.m_modeSelect = new ComboBox();
        this.m_modeSelect.setCaption(this.m_messages.key("GUI_VIEW_SWITCHER_LABEL_0"));
        this.m_modeSelect.addItem((Object)CmsMessageBundleEditorTypes.EditMode.DEFAULT);
        this.m_modeSelect.setItemCaption((Object)CmsMessageBundleEditorTypes.EditMode.DEFAULT, this.m_messages.key("GUI_VIEW_SWITCHER_EDITMODE_DEFAULT_0"));
        this.m_modeSelect.addItem((Object)CmsMessageBundleEditorTypes.EditMode.MASTER);
        this.m_modeSelect.setItemCaption((Object)CmsMessageBundleEditorTypes.EditMode.MASTER, this.m_messages.key("GUI_VIEW_SWITCHER_EDITMODE_MASTER_0"));
        this.m_modeSelect.setValue((Object)current);
        this.m_modeSelect.setNewItemsAllowed(false);
        this.m_modeSelect.setTextInputAllowed(false);
        this.m_modeSelect.setNullSelectionAllowed(false);
        this.m_modeSelect.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsMessageBundleEditorOptions.this.m_listener.handleModeChange((CmsMessageBundleEditorTypes.EditMode)((Object)event.getProperty().getValue()));
            }
        });
        modes.addComponent((Component)this.m_modeSelect);
        this.m_modeSwitch = modes;
    }

    private void initOptionsComponent() {
        this.m_optionsComponent = new GridLayout(2, 2);
        this.m_optionsComponent.setHideEmptyRowsAndColumns(true);
        this.m_optionsComponent.setDefaultComponentAlignment(Alignment.MIDDLE_RIGHT);
        this.m_optionsComponent.setWidth("100%");
        this.m_optionsComponent.setColumnExpandRatio(1, 1.0f);
        this.m_optionsComponent.setStyleName("v-options");
        this.m_optionsComponent.addComponent((Component)this.m_upperLeftComponent, 0, 0);
        Component upperRight = this.createUpperRightComponent();
        this.m_optionsComponent.addComponent(upperRight, 1, 0);
    }

    private void initUpperLeftComponent() {
        this.m_upperLeftComponent = new HorizontalLayout();
        this.m_upperLeftComponent.setHeight("100%");
        this.m_upperLeftComponent.setSpacing(true);
        this.m_upperLeftComponent.setDefaultComponentAlignment(Alignment.MIDDLE_RIGHT);
        this.m_upperLeftComponent.addComponent(this.m_languageSwitch);
        this.m_upperLeftComponent.addComponent(this.m_filePathLabel);
    }
}

