/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.sitemap;

import com.google.common.base.Predicate;
import com.vaadin.data.Item;
import com.vaadin.data.util.IndexedContainer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsLocaleGroup;
import org.opencms.i18n.CmsLocaleGroupService;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.components.fileselect.CmsResourceSelectDialog;
import org.opencms.ui.components.fileselect.I_CmsSelectionHandler;
import org.opencms.ui.sitemap.I_CmsLocaleCompareContext;
import org.opencms.util.CmsUUID;

public class CmsLocaleLinkTargetSelectionDialog
extends CmsResourceSelectDialog {
    private static final Log LOG = CmsLog.getLog(CmsLocaleLinkTargetSelectionDialog.class);
    private static final long serialVersionUID = 1L;
    I_CmsDialogContext m_context;
    private I_CmsLocaleCompareContext m_localeContext;

    public CmsLocaleLinkTargetSelectionDialog(I_CmsDialogContext context, I_CmsLocaleCompareContext localeContext) throws CmsException {
        super(CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireFolder());
        CmsResource defaultFile;
        CmsResource contextResource;
        this.m_localeContext = localeContext;
        CmsResource realFile = contextResource = context.getResources().get(0);
        if (realFile.isFolder() && (defaultFile = context.getCms().readDefaultFile(realFile, CmsResourceFilter.IGNORE_EXPIRATION)) != null) {
            realFile = defaultFile;
        }
        this.getContents().displayResourceInfo(Collections.singletonList(realFile));
        IndexedContainer siteData = (IndexedContainer)this.getContents().getSiteSelector().getContainerDataSource();
        this.m_context = context;
        CmsLocaleGroup localeGroup = localeContext.getLocaleGroup();
        Map<Locale, CmsResource> resourcesByLocale = localeGroup.getResourcesByLocale();
        int index = 0;
        for (Map.Entry<Locale, CmsResource> entry : resourcesByLocale.entrySet()) {
            Locale localeKey = entry.getKey();
            CmsResource resourceValue = entry.getValue();
            String folderPath = null;
            folderPath = resourceValue.isFile() ? CmsResource.getParentFolder(resourceValue.getRootPath()) : resourceValue.getRootPath();
            Item item = siteData.addItemAt(index, (Object)folderPath);
            ++index;
            item.getItemProperty(this.getContents().getSiteSelector().getItemCaptionPropertyId()).setValue((Object)CmsVaadinUtils.getMessageText("GUI_LOCALECOMPARE_LOCALE_LABEL_1", localeKey.getDisplayLanguage()));
        }
        this.addSelectionHandler(new I_CmsSelectionHandler<CmsResource>(){

            @Override
            public void onSelection(CmsResource selected) {
                CmsLocaleLinkTargetSelectionDialog.this.onClickOk(selected);
            }
        });
        this.getFileTree().setSelectionFilter(new Predicate<Item>(){

            public boolean apply(Item item) {
                CmsResource resource = (CmsResource)item.getItemProperty((Object)"RESOURCE").getValue();
                CmsResource srcResource = CmsLocaleLinkTargetSelectionDialog.this.m_context.getResources().get(0);
                switch (A_CmsUI.getCmsObject().getLocaleGroupService().checkLinkable(srcResource, resource)) {
                    case linkable: {
                        return true;
                    }
                }
                return false;
            }
        });
        Locale secondaryLocale = this.m_localeContext.getComparisonLocale();
        CmsLocaleGroup group = this.m_localeContext.getLocaleGroup();
        CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(this.m_localeContext.getRoot().getRootPath());
        if (group.hasLocale(secondaryLocale)) {
            CmsResource res = group.getResourcesByLocale().get(secondaryLocale);
            String folder = res.getRootPath();
            if (res.isFile()) {
                folder = CmsResource.getParentFolder(folder);
            }
            this.getContents().getSiteSelector().setValue((Object)folder);
        } else if (site != null) {
            this.getContents().getSiteSelector().setValue((Object)site.getSiteRoot());
        }
    }

    public void onClickCancel() {
        this.m_context.finish(Arrays.asList(new CmsUUID[0]));
    }

    public void onClickOk(CmsResource selected) {
        try {
            CmsResource target = selected;
            CmsResource source = this.m_context.getResources().get(0);
            CmsLocaleGroupService service = A_CmsUI.getCmsObject().getLocaleGroupService();
            service.attachLocaleGroupIndirect(source, target);
            this.m_context.finish(Arrays.asList(source.getStructureId()));
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            this.m_context.error(e);
        }
    }
}

