/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.vaadin.data.Property;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import java.util.IdentityHashMap;
import java.util.List;

public class CmsLogicalCheckboxGroup {
    private List<CheckBox> m_checkboxes = Lists.newArrayList();
    private I_ChangeListener m_listener;
    private IdentityHashMap<Component, Property.ValueChangeListener> m_listeners = Maps.newIdentityHashMap();
    private boolean m_runningEvent;
    private CheckBox m_selected;

    public void add(final CheckBox checkBox) {
        checkBox.setValue((Object)Boolean.FALSE);
        this.m_checkboxes.add(checkBox);
        Property.ValueChangeListener listener = new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                if (CmsLogicalCheckboxGroup.this.m_runningEvent) {
                    return;
                }
                try {
                    CmsLogicalCheckboxGroup.this.m_runningEvent = true;
                    if (((Boolean)event.getProperty().getValue()).booleanValue()) {
                        if (CmsLogicalCheckboxGroup.this.m_selected != null && CmsLogicalCheckboxGroup.this.m_selected != checkBox) {
                            CmsLogicalCheckboxGroup.this.m_selected.setValue((Object)Boolean.FALSE);
                        }
                        CmsLogicalCheckboxGroup.this.setActiveCheckBox(checkBox);
                    } else {
                        CmsLogicalCheckboxGroup.this.setActiveCheckBox(null);
                        CmsLogicalCheckboxGroup.this.m_selected = null;
                    }
                }
                finally {
                    CmsLogicalCheckboxGroup.this.m_runningEvent = false;
                }
            }
        };
        checkBox.addValueChangeListener(listener);
        this.m_listeners.put((Component)checkBox, listener);
    }

    public CheckBox getSelected() {
        return this.m_selected;
    }

    public void remove(CheckBox checkBox) {
        Property.ValueChangeListener listener;
        this.m_checkboxes.remove(checkBox);
        if (this.m_selected == checkBox) {
            this.m_selected = null;
        }
        if ((listener = this.m_listeners.get(checkBox)) != null) {
            checkBox.removeValueChangeListener(this.m_listeners.get(checkBox));
        }
    }

    public void setChangeListener(I_ChangeListener listener) {
        this.m_listener = listener;
    }

    protected void setActiveCheckBox(CheckBox box) {
        this.m_selected = box;
        if (this.m_listener != null) {
            this.m_listener.onSelect(box);
        }
    }

    public static interface I_ChangeListener {
        public void onSelect(CheckBox var1);
    }
}

