/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.opencms.i18n.CmsLocaleManager;

public final class CmsDateUtil {
    protected static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT");
    protected static final DateFormat HEADER_DEFAULT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    protected static final DateFormat OLD_COOKIE = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.US);

    private CmsDateUtil() {
    }

    public static String getDate(Date date, int format, Locale locale) {
        DateFormat df = DateFormat.getDateInstance(format, locale);
        return df.format(date);
    }

    public static String getDateShort(long time) {
        return CmsDateUtil.getDate(new Date(time), 3, CmsLocaleManager.getDefaultLocale());
    }

    public static String getDateTime(Date date, int format, Locale locale) {
        DateFormat df = DateFormat.getDateInstance(format, locale);
        DateFormat tf = DateFormat.getTimeInstance(format, locale);
        StringBuffer buf = new StringBuffer();
        buf.append(df.format(date));
        buf.append(" ");
        buf.append(tf.format(date));
        return buf.toString();
    }

    public static String getDateTimeShort(long time) {
        return CmsDateUtil.getDateTime(new Date(time), 3, CmsLocaleManager.getDefaultLocale());
    }

    public static int getDaysPassedSince(Date dateLastModified) {
        GregorianCalendar now = new GregorianCalendar();
        GregorianCalendar lastModified = (GregorianCalendar)now.clone();
        lastModified.setTimeInMillis(dateLastModified.getTime());
        return now.get(6) - lastModified.get(6) + (now.get(1) - lastModified.get(1)) * 365;
    }

    public static synchronized String getHeaderDate(long time) {
        if (HEADER_DEFAULT.getTimeZone() != GMT_TIMEZONE) {
            HEADER_DEFAULT.setTimeZone(GMT_TIMEZONE);
        }
        return HEADER_DEFAULT.format(new Date(time));
    }

    public static synchronized String getOldCookieDate(long time) {
        if (OLD_COOKIE.getTimeZone() != GMT_TIMEZONE) {
            OLD_COOKIE.setTimeZone(GMT_TIMEZONE);
        }
        try {
            return OLD_COOKIE.format(new Date(time));
        }
        catch (Throwable t) {
            return OLD_COOKIE.format(new Date());
        }
    }

    public static long parseDate(int year, int month, int date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, date);
        return calendar.getTime().getTime();
    }

    public static synchronized long parseHeaderDate(String timestamp) throws ParseException {
        return HEADER_DEFAULT.parse(timestamp).getTime();
    }
}

