/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessages;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsADEWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.workplace.CmsDialog;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.types.A_CmsXmlContentValue;

public abstract class A_CmsSelectWidget
extends A_CmsWidget
implements I_CmsADEWidget {
    public static final String CONFIGURATION_HEIGHT = "height";
    private String m_height;
    private List<CmsSelectWidgetOption> m_selectOptions;

    public A_CmsSelectWidget() {
    }

    public A_CmsSelectWidget(List<CmsSelectWidgetOption> configuration) {
        this.m_selectOptions = configuration;
    }

    public A_CmsSelectWidget(String configuration) {
        super(configuration);
    }

    public void addSelectOption(CmsSelectWidgetOption option) {
        if (this.m_selectOptions == null) {
            this.m_selectOptions = new ArrayList<CmsSelectWidgetOption>();
        }
        this.m_selectOptions.add(option);
    }

    @Override
    public String getConfiguration() {
        if (super.getConfiguration() != null) {
            return super.getConfiguration();
        }
        return CmsSelectWidgetOption.createConfigurationString(this.m_selectOptions);
    }

    @Override
    public String getConfiguration(CmsObject cms, A_CmsXmlContentValue schemaType, CmsMessages messages, CmsResource resource, Locale contentLocale) {
        A_CmsWidget.CmsDummyWidgetDialog widgetDialog = new A_CmsWidget.CmsDummyWidgetDialog(messages.getLocale(), messages);
        widgetDialog.setResource(resource);
        List<CmsSelectWidgetOption> options = this.parseSelectOptions(cms, widgetDialog, schemaType);
        String result = this.optionsToConfigurationString(options);
        return result;
    }

    @Override
    public List<String> getCssResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public I_CmsXmlContentHandler.DisplayType getDefaultDisplayType() {
        return I_CmsXmlContentHandler.DisplayType.singleline;
    }

    @Override
    public String getInitCall() {
        return null;
    }

    @Override
    public List<String> getJavaScriptResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public String getWidgetName() {
        return A_CmsSelectWidget.class.getName();
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    @Override
    public void setConfiguration(String configuration) {
        int heightIndex;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(configuration) && (heightIndex = configuration.indexOf(CONFIGURATION_HEIGHT)) != -1) {
            String height = configuration.substring(heightIndex + CONFIGURATION_HEIGHT.length() + 1);
            if (height.indexOf(124) != -1) {
                height = height.substring(0, height.indexOf(124));
            }
            this.m_height = height;
        }
        super.setConfiguration(configuration);
    }

    protected String getHeight() {
        return this.m_height;
    }

    protected String getResourcePath(CmsObject cms, I_CmsWidgetDialog dialog) {
        String result = null;
        if (dialog instanceof A_CmsWidget.CmsDummyWidgetDialog) {
            result = ((A_CmsWidget.CmsDummyWidgetDialog)dialog).getResource().getRootPath();
        } else if (dialog instanceof CmsDialog && (result = ((CmsDialog)((Object)dialog)).getParamResource()) != null) {
            result = cms.getRequestContext().addSiteRoot(result);
        }
        return result;
    }

    protected String getSelectedValue(CmsObject cms, I_CmsWidgetParameter param) {
        CmsSelectWidgetOption option;
        String paramValue = param.getStringValue(cms);
        if (CmsStringUtil.isEmpty(paramValue) && (option = CmsSelectWidgetOption.getDefaultOption(this.m_selectOptions)) != null) {
            paramValue = option.getValue();
        }
        return paramValue;
    }

    protected List<String> getSelectedValues(CmsObject cms, I_CmsWidgetParameter param) {
        ArrayList<String> values = new ArrayList<String>();
        String paramValue = param.getStringValue(cms);
        if (CmsStringUtil.isEmpty(paramValue)) {
            for (CmsSelectWidgetOption option : CmsSelectWidgetOption.getDefaultOptions(this.m_selectOptions)) {
                values.add(option.getValue());
            }
        } else {
            values.addAll(CmsStringUtil.splitAsList(paramValue, ',', true));
        }
        return values;
    }

    protected List<CmsSelectWidgetOption> getSelectOptions() {
        return this.m_selectOptions;
    }

    protected List<CmsSelectWidgetOption> parseSelectOptions(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        if (this.m_selectOptions == null) {
            String configuration = this.getConfiguration();
            if (configuration == null) {
                configuration = param.getDefault(cms);
            }
            configuration = CmsMacroResolver.resolveMacros(configuration, cms, widgetDialog.getMessages());
            this.m_selectOptions = CmsSelectWidgetOption.parseOptions(configuration);
            if (this.m_selectOptions == Collections.EMPTY_LIST) {
                this.m_selectOptions = new ArrayList<CmsSelectWidgetOption>();
            }
        }
        return this.m_selectOptions;
    }

    protected void setSelectOptions(List<CmsSelectWidgetOption> selectOptions) {
        this.m_selectOptions = new ArrayList<CmsSelectWidgetOption>();
        this.m_selectOptions.addAll(selectOptions);
    }

    String optionsToConfigurationString(List<CmsSelectWidgetOption> options) {
        String result = "";
        Iterator<CmsSelectWidgetOption> it = options.iterator();
        int i = 0;
        while (it.hasNext()) {
            CmsSelectWidgetOption option = it.next();
            if (i > 0) {
                result = result + "|";
            }
            result = result + option.toString();
            ++i;
        }
        return result;
    }
}

