/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.widgets.CmsSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.xml.containerpage.I_CmsFormatterBean;

public class CmsDisplayTypeSelectWidget
extends CmsSelectWidget {
    @Override
    public I_CmsWidget newInstance() {
        return new CmsDisplayTypeSelectWidget();
    }

    @Override
    protected List<CmsSelectWidgetOption> parseSelectOptions(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        ArrayList<CmsSelectWidgetOption> result = new ArrayList<CmsSelectWidgetOption>();
        ArrayList<FormatterOption> options = new ArrayList<FormatterOption>();
        CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, this.getResourcePath(cms, widgetDialog));
        if (config != null) {
            for (I_CmsFormatterBean formatter : config.getDisplayFormatters(cms)) {
                for (String typeName : formatter.getResourceTypeNames()) {
                    String label = formatter.getNiceName(wpLocale) + " (" + CmsWorkplaceMessages.getResourceTypeName(wpLocale, typeName) + ")";
                    options.add(new FormatterOption(typeName + ":" + formatter.getId(), typeName, label, formatter.getRank()));
                }
            }
        }
        Collections.sort(options, new FormatterComparator());
        for (FormatterOption option : options) {
            result.add(new CmsSelectWidgetOption(option.m_key, false, option.m_label));
        }
        return result;
    }

    class FormatterOption {
        String m_key;
        String m_label;
        int m_rank;
        String m_typeName;

        FormatterOption(String key, String typeName, String label, int rank) {
            this.m_key = key;
            this.m_typeName = typeName;
            this.m_label = label;
            this.m_rank = rank;
        }
    }

    class FormatterComparator
    implements Comparator<FormatterOption> {
        FormatterComparator() {
        }

        @Override
        public int compare(FormatterOption o1, FormatterOption o2) {
            return o1.m_typeName.equals(o2.m_typeName) ? o2.m_rank - o1.m_rank : o1.m_typeName.compareTo(o2.m_typeName);
        }
    }
}

