/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.CmsMultiSelectWidget;
import org.opencms.widgets.CmsSelectGroupWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.widgets.Messages;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.xml.types.A_CmsXmlContentValue;

public class CmsMultiSelectGroupWidget
extends CmsSelectGroupWidget {
    public static final String CONFIGURATION_DEFAULT_ALL = "defaultall";
    private static final Log LOG = CmsLog.getLog(CmsMultiSelectGroupWidget.class);
    private boolean m_asCheckBoxes;
    private boolean m_defaultAllAvailable;
    private boolean m_includeSubOus;
    private String m_ouFqn;
    private boolean m_requiresActivation;

    public CmsMultiSelectGroupWidget() {
    }

    public CmsMultiSelectGroupWidget(String configuration) {
        super(configuration);
    }

    public CmsMultiSelectGroupWidget(String configuration, boolean asCheckboxes) {
        super(configuration);
        this.m_asCheckBoxes = asCheckboxes;
    }

    @Override
    public String getConfiguration(CmsObject cms, A_CmsXmlContentValue schemaType, CmsMessages messages, CmsResource resource, Locale contentLocale) {
        String result = "";
        A_CmsWidget.CmsDummyWidgetDialog widgetDialog = new A_CmsWidget.CmsDummyWidgetDialog(schemaType.getLocale(), messages);
        widgetDialog.setResource(resource);
        List<CmsSelectWidgetOption> options = this.parseSelectOptions(cms, widgetDialog, (I_CmsWidgetParameter)schemaType);
        Iterator<CmsSelectWidgetOption> it = options.iterator();
        int i = 0;
        while (it.hasNext()) {
            CmsSelectWidgetOption option = it.next();
            if (i > 0) {
                result = result + "|";
            }
            result = result + option.toString();
            ++i;
        }
        if (this.m_requiresActivation) {
            result = result + "|requiresactivation";
        }
        return result;
    }

    @Override
    public String getDialogIncludes(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        return this.getJSIncludeFile(CmsWorkplace.getSkinUri() + "components/widgets/multiselector.js");
    }

    @Override
    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String id = param.getId();
        StringBuffer result = new StringBuffer(16);
        String height = this.getHeight();
        List<CmsSelectWidgetOption> options = this.parseSelectOptions(cms, widgetDialog.getMessages(), param);
        result.append("<td class=\"xmlTd\">");
        if (this.m_asCheckBoxes && CmsStringUtil.isNotEmptyOrWhitespaceOnly(height)) {
            result.append("<div style=\"height: " + height + "; overflow: auto;\">");
        }
        if (!this.m_asCheckBoxes) {
            if (this.m_requiresActivation) {
                result.append("<input style=\"vertical-align:middle;\" type=\"checkbox\" id=\"check" + id + "\" name=\"check" + id + "\"onclick=toggleMultiSelectWidget(this); />");
                result.append("&nbsp;<label style=\"vertical-align:middle;\" for=\"check" + id + "\">");
                result.append(widgetDialog.getMessages().key("GUI_MULTISELECT_ACTIVATE_0"));
                result.append("</label>&nbsp;");
                result.append("<input type='hidden' name='").append(id).append("' id='").append(id).append("' value='");
                List<String> values = this.getSelectedValues(cms, param);
                if (values.size() > 0) {
                    result.append(values.get(0));
                    for (int i = 1; i < values.size(); ++i) {
                        result.append(",").append(values.get(i));
                    }
                }
                result.append("' />");
                id = "display" + id;
            }
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(height)) {
                result.append("<select style=\"height: " + height + ";\" multiple size='");
            } else {
                result.append("<select multiple size='");
            }
            result.append(options.size());
            result.append("' style=\"vertical-align:middle;\" class=\"xmlInput");
            if (param.hasError()) {
                result.append(" xmlInputError");
            }
            result.append("\" ");
            if (this.m_requiresActivation) {
                result.append("disabled=\"true\" ");
            }
            result.append("name=\"");
            result.append(id);
            result.append("\" id=\"");
            result.append(id);
            result.append("\">");
        }
        List<String> selected = this.getSelectedValues(cms, param);
        for (CmsSelectWidgetOption option : options) {
            if (!this.m_asCheckBoxes) {
                result.append("<option value=\"");
                result.append(option.getValue());
                result.append("\"");
                if (selected.contains(option.getValue())) {
                    result.append(" selected=\"selected\"");
                }
                result.append(">");
                result.append(option.getOption());
                result.append("</option>");
                continue;
            }
            result.append("<input type='checkbox' name='");
            result.append(id);
            result.append("' value='");
            result.append(option.getValue());
            result.append("'");
            if (selected.contains(option.getValue())) {
                result.append(" checked");
            }
            result.append(">");
            result.append(option.getOption());
            result.append("<br>");
        }
        if (!this.m_asCheckBoxes) {
            result.append("</select>");
        }
        if (this.m_asCheckBoxes && CmsStringUtil.isNotEmptyOrWhitespaceOnly(height)) {
            result.append("</div>");
        }
        result.append("</td>");
        return result.toString();
    }

    @Override
    public String getWidgetName() {
        return CmsMultiSelectGroupWidget.class.getName();
    }

    @Override
    public I_CmsWidget newInstance() {
        return new CmsMultiSelectGroupWidget(this.getConfiguration());
    }

    @Override
    public void setConfiguration(String configuration) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(configuration)) {
            int reqiresActivationIndex;
            int asCheckBoxesIndex = configuration.indexOf("ascheckboxes");
            if (asCheckBoxesIndex != -1) {
                String asCheckBoxes = configuration.substring(asCheckBoxesIndex + "ascheckboxes".length() + 1);
                if (asCheckBoxes.indexOf(124) != -1) {
                    asCheckBoxes = asCheckBoxes.substring(0, asCheckBoxes.indexOf(124));
                }
                this.m_asCheckBoxes = Boolean.parseBoolean(asCheckBoxes);
            }
            if ((reqiresActivationIndex = configuration.indexOf("requiresactivation")) != -1) {
                String requiresActivation = configuration.substring(reqiresActivationIndex + "requiresactivation".length() + 1);
                if (requiresActivation.indexOf(124) != -1) {
                    requiresActivation = requiresActivation.substring(0, requiresActivation.indexOf(124));
                }
                this.m_requiresActivation = Boolean.parseBoolean(requiresActivation);
            }
        }
        super.setConfiguration(configuration);
    }

    @Override
    public void setEditorValue(CmsObject cms, Map<String, String[]> formParameters, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        CmsMultiSelectWidget.setMultiSelectEditorValue(cms, formParameters, widgetDialog, param);
    }

    @Override
    protected List<CmsSelectWidgetOption> parseSelectOptions(CmsObject cms, CmsMessages messages, I_CmsWidgetParameter param) {
        if (this.getSelectOptions() == null) {
            this.parseConfiguration(cms, messages);
            ArrayList<CmsSelectWidgetOption> result = new ArrayList<CmsSelectWidgetOption>();
            if (this.isUseGroupNames()) {
                for (String groupName : this.getGroupNames()) {
                    try {
                        CmsGroup group = cms.readGroup(this.getOuFqn() + groupName);
                        result.add(new CmsSelectWidgetOption(group.getName(), this.m_defaultAllAvailable, group.getSimpleName()));
                    }
                    catch (CmsException group) {}
                }
            } else {
                try {
                    List<CmsGroup> groups = OpenCms.getOrgUnitManager().getGroups(cms, this.getOuFqn(), this.isIncludeSubOus());
                    for (CmsGroup group : groups) {
                        if (this.isUseGroupFilter() && !this.getGroupFilter().matcher(group.getSimpleName()).matches()) continue;
                        result.add(new CmsSelectWidgetOption(group.getName(), this.m_defaultAllAvailable, group.getSimpleName()));
                    }
                }
                catch (CmsException cmsException) {
                    // empty catch block
                }
            }
            this.setSelectOptions(result);
        }
        return this.getSelectOptions();
    }

    @Override
    protected List<CmsSelectWidgetOption> parseSelectOptions(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        return this.parseSelectOptions(cms, widgetDialog.getMessages(), param);
    }

    private Pattern getGroupFilter() {
        return this.m_groupFilter;
    }

    private List<String> getGroupNames() {
        return this.m_groupNames;
    }

    private String getOuFqn() {
        return this.m_ouFqn;
    }

    private boolean isIncludeSubOus() {
        return this.m_includeSubOus;
    }

    private boolean isUseGroupFilter() {
        return this.getGroupFilter() != null;
    }

    private boolean isUseGroupNames() {
        return this.getGroupNames() != null;
    }

    private void parseConfiguration(CmsObject cms, CmsMessages widgetDialog) {
        String filter;
        String configString = CmsMacroResolver.resolveMacros(this.getConfiguration(), cms, widgetDialog);
        Map<String, String> config = CmsStringUtil.splitAsMap(configString, "|", "=");
        String groups = config.get("groups");
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(groups)) {
            this.m_groupNames = CmsStringUtil.splitAsList(groups, ',', true);
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(filter = config.get("groupfilter"))) {
            try {
                this.m_groupFilter = Pattern.compile(filter);
            }
            catch (PatternSyntaxException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_ERR_WIDGET_SELECTGROUP_PATTERN_1", filter));
            }
        }
        this.m_ouFqn = config.get("oufqn");
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_ouFqn)) {
            this.m_ouFqn = "";
        } else if (!this.m_ouFqn.endsWith("/")) {
            this.m_ouFqn = this.m_ouFqn + "/";
        }
        this.m_includeSubOus = Boolean.parseBoolean(config.get("includesubous"));
        this.m_defaultAllAvailable = Boolean.parseBoolean(config.get(CONFIGURATION_DEFAULT_ALL));
    }
}

