/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workflow;

import java.util.List;
import org.apache.commons.mail.EmailException;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.notification.A_CmsNotification;
import org.opencms.util.CmsStringUtil;
import org.opencms.workflow.Messages;

public class CmsWorkflowNotification
extends A_CmsNotification {
    private CmsObject m_adminCms;
    private String m_link;
    private String m_notificationContent;
    private CmsProject m_project;
    private List<CmsResource> m_resources;
    private CmsObject m_userCms;

    public CmsWorkflowNotification(CmsObject adminCms, CmsObject userCms, CmsUser receiver, String notificationContent, CmsProject project, List<CmsResource> resources, String link) throws EmailException {
        super(userCms, receiver);
        this.m_notificationContent = notificationContent;
        this.m_adminCms = adminCms;
        this.m_userCms = userCms;
        this.m_project = project;
        this.m_resources = resources;
        this.m_link = link;
        String userAddress = userCms.getRequestContext().getCurrentUser().getEmail();
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(userAddress)) {
            this.setFrom(userAddress);
        }
        this.addMacro("release.project", this.m_project.getName());
    }

    public String[] getResourceInfo(CmsResource resource) {
        String rootPath = resource.getRootPath();
        String title = "-";
        try {
            CmsProperty titleProp = this.m_adminCms.readPropertyObject(resource, "Title", false);
            if (!titleProp.isNullProperty()) {
                title = titleProp.getValue();
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        return new String[]{rootPath, title};
    }

    public String[] getResourceInfoHeaders() {
        return new String[]{"Resource", "Title"};
    }

    @Override
    protected String generateHtmlMsg() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("    <div class=\"publish_link\">");
        buffer.append(this.getMessage("GUI_MAIL_PUBLISH_LINK_1", this.m_link));
        buffer.append("</div>\r\n");
        buffer.append("    <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"resource_table\">\r\n");
        String[] tableHeaders = this.getResourceInfoHeaders();
        buffer.append("      <tr>\r\n");
        boolean first = true;
        for (String header : tableHeaders) {
            if (first) {
                buffer.append("<th align=\"left\" class=\"rescol\">");
                first = false;
            } else {
                buffer.append("<th align=\"left\" class=\"titlecol\">");
            }
            buffer.append(header);
            buffer.append("</th>");
        }
        buffer.append("</tr>\n");
        first = true;
        for (CmsResource resource : this.m_resources) {
            String[] resourceInfos = this.getResourceInfo(resource);
            buffer.append("      <tr>\r\n");
            for (String resourceInfo : resourceInfos) {
                if (first) {
                    buffer.append("<td class=\"rescol\">");
                    first = false;
                } else {
                    buffer.append("<td class=\"titlecol\">");
                    first = true;
                }
                buffer.append(resourceInfo);
                buffer.append("</td>");
            }
            buffer.append("</tr>\n");
        }
        buffer.append("</table>");
        buffer.append("    <div class=\"publish_link\">");
        buffer.append(this.getMessage("GUI_MAIL_PUBLISH_LINK_1", this.m_link));
        buffer.append("</div>\r\n");
        return buffer.toString();
    }

    protected String getMessage(String key, String ... args) {
        return Messages.get().getBundle(this.getLocale()).key(key, args);
    }

    @Override
    protected String getNotificationContent() {
        return this.m_notificationContent;
    }
}

