/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.comparison;

import java.util.Locale;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.commons.Messages;

public final class CmsHistoryListUtil {
    private CmsHistoryListUtil() {
    }

    public static String getDisplayVersion(String version, Locale locale) {
        int ver = Integer.parseInt(version);
        if (ver == Integer.MAX_VALUE) {
            return Messages.get().getBundle(locale).key("GUI_PROJECT_OFFLINE_0");
        }
        if (ver < 0) {
            ver *= -1;
            if (locale != null) {
                return Messages.get().getBundle(locale).key("GUI_PROJECT_ONLINE_1", new Integer(ver));
            }
        }
        return "" + ver;
    }

    public static String getHistoryLink(CmsObject cms, CmsUUID structureId, String version) {
        String resourcePath;
        try {
            CmsResource resource = cms.readResource(structureId, CmsResourceFilter.ALL);
            resourcePath = resource.getRootPath();
        }
        catch (CmsException e) {
            throw new CmsRuntimeException(e.getMessageContainer(), (Throwable)e);
        }
        StringBuffer link = new StringBuffer();
        link.append("/system/shared/showversion");
        link.append(resourcePath);
        link.append('?');
        link.append("version");
        link.append('=');
        link.append(CmsHistoryListUtil.getVersion("" + version));
        return link.toString();
    }

    public static int getVersion(String version) {
        int ver = Integer.parseInt(version);
        return Math.abs(ver);
    }
}

