/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.explorer;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.workplace.explorer.CmsExplorerContextMenuItem;
import org.opencms.workplace.explorer.Messages;

public class CmsExplorerContextMenu {
    private static final Log LOG = CmsLog.getLog(CmsExplorerContextMenu.class);
    private List<CmsExplorerContextMenuItem> m_allEntries = new ArrayList<CmsExplorerContextMenuItem>();
    private boolean m_multiMenu;

    public void addContextMenuEntry(CmsExplorerContextMenuItem item) {
        item.setType("entry");
        this.m_allEntries.add(item);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_ADD_MENU_ENTRY_2", item.getKey(), item.getUri()));
        }
    }

    public void addContextMenuSeparator(CmsExplorerContextMenuItem item) {
        item.setType("sep");
        this.m_allEntries.add(item);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_ADD_MENU_SEPARATOR_1", item.getType()));
        }
    }

    public void addEntries(List<CmsExplorerContextMenuItem> entries) {
        this.m_allEntries.addAll(entries);
    }

    public Object clone() {
        CmsExplorerContextMenu objectClone = new CmsExplorerContextMenu();
        objectClone.setMultiMenu(this.m_multiMenu);
        objectClone.setAllEntries(this.m_allEntries);
        return objectClone;
    }

    public List<CmsExplorerContextMenuItem> getAllEntries() {
        return this.m_allEntries;
    }

    public boolean isEmpty() {
        return this.m_allEntries.isEmpty();
    }

    public boolean isMultiMenu() {
        return this.m_multiMenu;
    }

    public void setAllEntries(List<CmsExplorerContextMenuItem> entries) {
        this.m_allEntries = entries;
    }

    public void setMultiMenu(boolean multiMenu) {
        this.m_multiMenu = multiMenu;
    }
}

