/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.threads;

import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.report.A_CmsReportThread;
import org.opencms.report.I_CmsReport;
import org.opencms.synchronize.CmsSynchronize;
import org.opencms.synchronize.CmsSynchronizeSettings;
import org.opencms.workplace.threads.Messages;

public class CmsSynchronizeThread
extends A_CmsReportThread {
    private Throwable m_error;
    private CmsSynchronizeSettings m_settings;

    public CmsSynchronizeThread(CmsObject cms) {
        super(cms, Messages.get().getBundle().key("GUI_SYNCHRONIZE_THREAD_NAME_1", cms.getRequestContext().getCurrentProject().getName()));
        this.initHtmlReport(cms.getRequestContext().getLocale());
        this.m_settings = new CmsUserSettings(cms).getSynchronizeSettings();
    }

    @Override
    public Throwable getError() {
        return this.m_error;
    }

    @Override
    public String getReportUpdate() {
        return this.getReport().getReportUpdate();
    }

    @Override
    public void run() {
        I_CmsReport report = this.getReport();
        report.println(Messages.get().container("RPT_SYNCHRONIZE_BEGIN_0"), 2);
        try {
            new CmsSynchronize(this.getCms(), this.m_settings, this.getReport());
        }
        catch (Throwable e) {
            this.m_error = e;
            report.println(e);
        }
        report.println(Messages.get().container("RPT_SYNCHRONIZE_END_0"), 2);
    }
}

