/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationType;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlComplexTypeSequence;
import org.opencms.xml.CmsXmlContentTypeManager;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlGenericWrapper;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.Messages;
import org.opencms.xml.content.CmsDefaultXmlContentHandler;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.types.CmsXmlNestedContentDefinition;
import org.opencms.xml.types.CmsXmlStringValue;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CmsXmlContentDefinition
implements Cloneable {
    public static final String XSD_ATTRIBUTE_DEFAULT = "default";
    public static final String XSD_ATTRIBUTE_ELEMENT_FORM_DEFAULT = "elementFormDefault";
    public static final String XSD_ATTRIBUTE_MAX_OCCURS = "maxOccurs";
    public static final String XSD_ATTRIBUTE_MIN_OCCURS = "minOccurs";
    public static final String XSD_ATTRIBUTE_NAME = "name";
    public static final String XSD_ATTRIBUTE_SCHEMA_LOCATION = "schemaLocation";
    public static final String XSD_ATTRIBUTE_TYPE = "type";
    public static final String XSD_ATTRIBUTE_USE = "use";
    public static final String XSD_ATTRIBUTE_VALUE_LANGUAGE = "language";
    public static final String XSD_ATTRIBUTE_VALUE_ONE = "1";
    public static final String XSD_ATTRIBUTE_VALUE_OPTIONAL = "optional";
    public static final String XSD_ATTRIBUTE_VALUE_QUALIFIED = "qualified";
    public static final String XSD_ATTRIBUTE_VALUE_REQUIRED = "required";
    public static final String XSD_ATTRIBUTE_VALUE_UNBOUNDED = "unbounded";
    public static final String XSD_ATTRIBUTE_VALUE_ZERO = "0";
    public static final String XSD_INCLUDE_OPENCMS = "opencms://opencms-xmlcontent.xsd";
    public static final Namespace XSD_NAMESPACE = Namespace.get((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema");
    public static final QName XSD_NODE_ANNOTATION = QName.get((String)"annotation", (Namespace)XSD_NAMESPACE);
    public static final QName XSD_NODE_APPINFO = QName.get((String)"appinfo", (Namespace)XSD_NAMESPACE);
    public static final QName XSD_NODE_ATTRIBUTE = QName.get((String)"attribute", (Namespace)XSD_NAMESPACE);
    public static final QName XSD_NODE_CHOICE = QName.get((String)"choice", (Namespace)XSD_NAMESPACE);
    public static final QName XSD_NODE_COMPLEXTYPE = QName.get((String)"complexType", (Namespace)XSD_NAMESPACE);
    public static final QName XSD_NODE_ELEMENT = QName.get((String)"element", (Namespace)XSD_NAMESPACE);
    public static final QName XSD_NODE_INCLUDE = QName.get((String)"include", (Namespace)XSD_NAMESPACE);
    public static final QName XSD_NODE_SCHEMA = QName.get((String)"schema", (Namespace)XSD_NAMESPACE);
    public static final QName XSD_NODE_SEQUENCE = QName.get((String)"sequence", (Namespace)XSD_NAMESPACE);
    private static final Log LOG = CmsLog.getLog(CmsXmlContentDefinition.class);
    private static final I_CmsXmlSchemaType NULL_SCHEMA_TYPE = new CmsXmlStringValue("NULL", "0", "0");
    private int m_choiceMaxOccurs;
    private I_CmsXmlContentHandler m_contentHandler;
    private Map<String, I_CmsXmlSchemaType> m_elementTypes;
    private Set<CmsXmlContentDefinition> m_includes;
    private String m_innerName;
    private String m_outerName;
    private Document m_schemaDocument;
    private String m_schemaLocation;
    private SequenceType m_sequenceType;
    private String m_typeName;
    private Map<String, I_CmsXmlSchemaType> m_types;
    private List<I_CmsXmlSchemaType> m_typeSequence;

    public CmsXmlContentDefinition(String innerName, String schemaLocation) {
        this(innerName + "s", innerName, schemaLocation);
    }

    public CmsXmlContentDefinition(String outerName, String innerName, String schemaLocation) {
        this.m_outerName = outerName;
        this.m_innerName = innerName;
        this.setInnerName(innerName);
        this.m_typeSequence = new ArrayList<I_CmsXmlSchemaType>();
        this.m_types = new HashMap<String, I_CmsXmlSchemaType>();
        this.m_includes = new HashSet<CmsXmlContentDefinition>();
        this.m_schemaLocation = schemaLocation;
        this.m_contentHandler = new CmsDefaultXmlContentHandler();
        this.m_sequenceType = SequenceType.SEQUENCE;
        this.m_elementTypes = new ConcurrentHashMap<String, I_CmsXmlSchemaType>();
    }

    protected CmsXmlContentDefinition() {
    }

    public static CmsXmlContentDefinition getContentDefinitionForResource(CmsObject cms, CmsResource resource) throws CmsException {
        List<CmsRelation> relations;
        CmsXmlContentDefinition contentDef = null;
        I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(resource.getTypeId());
        String schema = resType.getConfiguration().get("schema");
        if (schema != null) {
            try {
                contentDef = CmsXmlContentDefinition.unmarshal(cms, schema);
            }
            catch (CmsException e) {
                if (!LOG.isDebugEnabled()) {
                    LOG.warn((Object)e);
                }
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (contentDef == null && (relations = cms.getRelationsForResource(resource, CmsRelationFilter.TARGETS.filterType(CmsRelationType.XSD))) != null && !relations.isEmpty()) {
            CmsXmlEntityResolver entityResolver = new CmsXmlEntityResolver(cms);
            String xsd = cms.getSitePath(relations.get(0).getTarget(cms, CmsResourceFilter.ALL));
            contentDef = entityResolver.getCachedContentDefinition(xsd);
        }
        if (contentDef == null) {
            CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, cms.readFile(resource));
            contentDef = content.getContentDefinition();
        }
        return contentDef;
    }

    public static CmsXmlContentDefinition getContentDefinitionForType(CmsObject cms, String typeName) throws CmsException {
        I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(typeName);
        String schema = resType.getConfiguration().get("schema");
        CmsXmlContentDefinition contentDef = null;
        if (schema == null) {
            return null;
        }
        contentDef = CmsXmlContentDefinition.unmarshal(cms, schema);
        return contentDef;
    }

    public static I_CmsXmlContentHandler getContentHandlerForResource(CmsObject cms, CmsResource resource) throws CmsException {
        return CmsXmlContentDefinition.getContentDefinitionForResource(cms, resource).getContentHandler();
    }

    public static CmsXmlContentDefinition unmarshal(byte[] xmlData, String schemaLocation, EntityResolver resolver) throws CmsXmlException {
        CmsXmlContentDefinition result = CmsXmlContentDefinition.getCachedContentDefinition(schemaLocation = CmsXmlContentDefinition.translateSchema(schemaLocation), resolver);
        if (result == null) {
            result = CmsXmlContentDefinition.unmarshalInternal(CmsXmlUtils.unmarshalHelper(xmlData, resolver), schemaLocation, resolver);
        }
        return result;
    }

    public static CmsXmlContentDefinition unmarshal(CmsObject cms, String resourcename) throws CmsXmlException {
        CmsXmlEntityResolver resolver = new CmsXmlEntityResolver(cms);
        String schemaLocation = "opencms://".concat(resourcename.substring(1));
        CmsXmlContentDefinition result = CmsXmlContentDefinition.getCachedContentDefinition(schemaLocation = CmsXmlContentDefinition.translateSchema(schemaLocation), resolver);
        if (result == null) {
            InputSource source = resolver.resolveEntity(null, schemaLocation);
            result = CmsXmlContentDefinition.unmarshalInternal(CmsXmlUtils.unmarshalHelper(source, (EntityResolver)resolver), schemaLocation, resolver);
        }
        return result;
    }

    public static CmsXmlContentDefinition unmarshal(Document document, String schemaLocation) throws CmsXmlException {
        EntityResolver resolver;
        CmsXmlContentDefinition result = CmsXmlContentDefinition.getCachedContentDefinition(schemaLocation = CmsXmlContentDefinition.translateSchema(schemaLocation), resolver = document.getEntityResolver());
        if (result == null) {
            result = CmsXmlContentDefinition.unmarshalInternal(document, schemaLocation, resolver);
        }
        return result;
    }

    public static CmsXmlContentDefinition unmarshal(InputSource source, String schemaLocation, EntityResolver resolver) throws CmsXmlException {
        CmsXmlContentDefinition result = CmsXmlContentDefinition.getCachedContentDefinition(schemaLocation = CmsXmlContentDefinition.translateSchema(schemaLocation), resolver);
        if (result == null) {
            result = CmsXmlContentDefinition.unmarshalInternal(CmsXmlUtils.unmarshalHelper(source, resolver), schemaLocation, resolver);
        }
        return result;
    }

    public static CmsXmlContentDefinition unmarshal(String schemaLocation, EntityResolver resolver) throws CmsXmlException, SAXException, IOException {
        CmsXmlContentDefinition result = CmsXmlContentDefinition.getCachedContentDefinition(schemaLocation = CmsXmlContentDefinition.translateSchema(schemaLocation), resolver);
        if (result == null) {
            InputSource source = resolver.resolveEntity(null, schemaLocation);
            result = CmsXmlContentDefinition.unmarshalInternal(CmsXmlUtils.unmarshalHelper(source, resolver), schemaLocation, resolver);
        }
        return result;
    }

    public static CmsXmlContentDefinition unmarshal(String xmlData, String schemaLocation, EntityResolver resolver) throws CmsXmlException {
        CmsXmlContentDefinition result = CmsXmlContentDefinition.getCachedContentDefinition(schemaLocation = CmsXmlContentDefinition.translateSchema(schemaLocation), resolver);
        if (result == null) {
            result = CmsXmlContentDefinition.unmarshalInternal(CmsXmlUtils.unmarshalHelper(xmlData, resolver), schemaLocation, resolver);
        }
        return result;
    }

    protected static String createTypeName(String name) {
        StringBuffer result = new StringBuffer(32);
        result.append("OpenCms");
        result.append(name.substring(0, 1).toUpperCase());
        if (name.length() > 1) {
            result.append(name.substring(1));
        }
        return result.toString();
    }

    protected static String validateAttribute(Element element, String attributeName, String requiredValue) throws CmsXmlException {
        Attribute attribute = element.attribute(attributeName);
        if (attribute == null) {
            throw new CmsXmlException(Messages.get().container("ERR_EL_MISSING_ATTRIBUTE_2", element.getUniquePath(), attributeName));
        }
        String value = attribute.getValue();
        if (requiredValue == null) {
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(value) || !value.equals(value.trim())) {
                throw new CmsXmlException(Messages.get().container("ERR_EL_BAD_ATTRIBUTE_WS_3", element.getUniquePath(), attributeName, value));
            }
        } else if (!requiredValue.equals(value)) {
            throw new CmsXmlException(Messages.get().container("ERR_EL_BAD_ATTRIBUTE_VALUE_4", new Object[]{element.getUniquePath(), attributeName, requiredValue, value}));
        }
        return value;
    }

    protected static void validateAttributesExists(Element element, String[] requiredAttributes, String[] optionalAttributes) throws CmsXmlException {
        if (element.attributeCount() < requiredAttributes.length) {
            throw new CmsXmlException(Messages.get().container("ERR_EL_ATTRIBUTE_TOOFEW_3", element.getUniquePath(), new Integer(requiredAttributes.length), new Integer(element.attributeCount())));
        }
        if (element.attributeCount() > requiredAttributes.length + optionalAttributes.length) {
            throw new CmsXmlException(Messages.get().container("ERR_EL_ATTRIBUTE_TOOMANY_3", element.getUniquePath(), new Integer(requiredAttributes.length + optionalAttributes.length), new Integer(element.attributeCount())));
        }
        for (int i = 0; i < requiredAttributes.length; ++i) {
            String attributeName = requiredAttributes[i];
            if (element.attribute(attributeName) != null) continue;
            throw new CmsXmlException(Messages.get().container("ERR_EL_MISSING_ATTRIBUTE_2", element.getUniquePath(), attributeName));
        }
        List<String> rA = Arrays.asList(requiredAttributes);
        List<String> oA = Arrays.asList(optionalAttributes);
        for (int i = 0; i < element.attributes().size(); ++i) {
            String attributeName = element.attribute(i).getName();
            if (rA.contains(attributeName) || oA.contains(attributeName)) continue;
            throw new CmsXmlException(Messages.get().container("ERR_EL_INVALID_ATTRIBUTE_2", element.getUniquePath(), attributeName));
        }
    }

    protected static CmsXmlComplexTypeSequence validateComplexTypeSequence(Element element, Set<CmsXmlContentDefinition> includes) throws CmsXmlException {
        SequenceType sequenceType;
        CmsXmlContentDefinition.validateAttributesExists(element, new String[]{XSD_ATTRIBUTE_NAME}, new String[0]);
        String name = CmsXmlContentDefinition.validateAttribute(element, XSD_ATTRIBUTE_NAME, null);
        List<Element> mainElements = CmsXmlGenericWrapper.elements(element);
        if (mainElements.size() != 1 && mainElements.size() != 2) {
            throw new CmsXmlException(Messages.get().container("ERR_TS_SUBELEMENT_COUNT_2", element.getUniquePath(), new Integer(mainElements.size())));
        }
        boolean hasLanguageAttribute = false;
        if (mainElements.size() == 2) {
            Element typeAttribute = mainElements.get(1);
            if (!XSD_NODE_ATTRIBUTE.equals((Object)typeAttribute.getQName())) {
                throw new CmsXmlException(Messages.get().container("ERR_CD_ELEMENT_NAME_3", typeAttribute.getUniquePath(), XSD_NODE_ATTRIBUTE.getQualifiedName(), typeAttribute.getQName().getQualifiedName()));
            }
            CmsXmlContentDefinition.validateAttribute(typeAttribute, XSD_ATTRIBUTE_NAME, XSD_ATTRIBUTE_VALUE_LANGUAGE);
            CmsXmlContentDefinition.validateAttribute(typeAttribute, XSD_ATTRIBUTE_TYPE, "OpenCmsLocale");
            try {
                CmsXmlContentDefinition.validateAttribute(typeAttribute, XSD_ATTRIBUTE_USE, XSD_ATTRIBUTE_VALUE_REQUIRED);
            }
            catch (CmsXmlException e) {
                CmsXmlContentDefinition.validateAttribute(typeAttribute, XSD_ATTRIBUTE_USE, XSD_ATTRIBUTE_VALUE_OPTIONAL);
            }
            hasLanguageAttribute = true;
        }
        int choiceMaxOccurs = 0;
        Element typeSequenceElement = mainElements.get(0);
        if (!XSD_NODE_SEQUENCE.equals((Object)typeSequenceElement.getQName())) {
            if (!XSD_NODE_CHOICE.equals((Object)typeSequenceElement.getQName())) {
                throw new CmsXmlException(Messages.get().container("ERR_CD_ELEMENT_NAME_4", new Object[]{typeSequenceElement.getUniquePath(), XSD_NODE_SEQUENCE.getQualifiedName(), XSD_NODE_CHOICE.getQualifiedName(), typeSequenceElement.getQName().getQualifiedName()}));
            }
            String minOccursStr = typeSequenceElement.attributeValue(XSD_ATTRIBUTE_MIN_OCCURS);
            int minOccurs = 1;
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(minOccursStr)) {
                try {
                    minOccurs = Integer.parseInt(minOccursStr.trim());
                }
                catch (NumberFormatException e) {
                    throw new CmsXmlException(Messages.get().container("ERR_EL_BAD_ATTRIBUTE_3", element.getUniquePath(), XSD_ATTRIBUTE_MIN_OCCURS, minOccursStr == null ? XSD_ATTRIBUTE_VALUE_ONE : minOccursStr));
                }
            }
            String maxOccursStr = typeSequenceElement.attributeValue(XSD_ATTRIBUTE_MAX_OCCURS);
            choiceMaxOccurs = 1;
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(maxOccursStr)) {
                if (XSD_ATTRIBUTE_VALUE_UNBOUNDED.equals(maxOccursStr.trim())) {
                    choiceMaxOccurs = Integer.MAX_VALUE;
                } else {
                    try {
                        choiceMaxOccurs = Integer.parseInt(maxOccursStr.trim());
                    }
                    catch (NumberFormatException e) {
                        throw new CmsXmlException(Messages.get().container("ERR_EL_BAD_ATTRIBUTE_3", element.getUniquePath(), XSD_ATTRIBUTE_MAX_OCCURS, maxOccursStr));
                    }
                }
            }
            if (minOccurs == 0 && choiceMaxOccurs == 1) {
                sequenceType = SequenceType.SINGLE_CHOICE;
            } else {
                if (minOccurs > choiceMaxOccurs) {
                    throw new CmsXmlException(Messages.get().container("ERR_EL_BAD_ATTRIBUTE_3", element.getUniquePath(), XSD_ATTRIBUTE_MIN_OCCURS, minOccursStr == null ? XSD_ATTRIBUTE_VALUE_ONE : minOccursStr));
                }
                sequenceType = SequenceType.MULTIPLE_CHOICE;
            }
        } else {
            sequenceType = SequenceType.SEQUENCE;
        }
        List<Element> typeSequenceElements = CmsXmlGenericWrapper.elements(typeSequenceElement);
        if (typeSequenceElements.size() < 1) {
            throw new CmsXmlException(Messages.get().container("ERR_TS_SUBELEMENT_TOOFEW_3", typeSequenceElement.getUniquePath(), new Integer(1), new Integer(typeSequenceElements.size())));
        }
        ArrayList<I_CmsXmlSchemaType> sequence = new ArrayList<I_CmsXmlSchemaType>();
        if (hasLanguageAttribute) {
            CmsXmlContentTypeManager typeManager = OpenCms.getXmlContentTypeManager();
            for (Element typeElement : typeSequenceElements) {
                I_CmsXmlSchemaType type;
                if (sequenceType != SequenceType.SEQUENCE) {
                    String minOccursStr = typeElement.attributeValue(XSD_ATTRIBUTE_MIN_OCCURS);
                    int minOccurs = 1;
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(minOccursStr)) {
                        try {
                            minOccurs = Integer.parseInt(minOccursStr.trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (minOccurs != 0) {
                        throw new CmsXmlException(Messages.get().container("ERR_EL_BAD_ATTRIBUTE_3", typeElement.getUniquePath(), XSD_ATTRIBUTE_MIN_OCCURS, minOccursStr == null ? XSD_ATTRIBUTE_VALUE_ONE : minOccursStr));
                    }
                }
                if ((type = typeManager.getContentType(typeElement, includes)).getTypeName().equals("OpenCmsDynamicCategory") && (type.getMaxOccurs() != 1 || type.getMinOccurs() != 1)) {
                    throw new CmsXmlException(Messages.get().container("ERR_EL_OF_TYPE_MUST_OCCUR_EXACTLY_ONCE_2", typeElement.getUniquePath(), type.getTypeName()));
                }
                if (sequenceType == SequenceType.MULTIPLE_CHOICE && (type.getMinOccurs() < 0 || type.getMinOccurs() > 1 || type.getMaxOccurs() != 1)) {
                    throw new CmsXmlException(Messages.get().container("ERR_EL_BAD_ATTRIBUTE_3", typeElement.getUniquePath(), XSD_ATTRIBUTE_MAX_OCCURS, typeElement.attributeValue(XSD_ATTRIBUTE_MAX_OCCURS)));
                }
                sequence.add(type);
            }
        } else {
            Element e = typeSequenceElements.get(0);
            String typeName = CmsXmlContentDefinition.validateAttribute(e, XSD_ATTRIBUTE_NAME, null);
            String minOccurs = CmsXmlContentDefinition.validateAttribute(e, XSD_ATTRIBUTE_MIN_OCCURS, XSD_ATTRIBUTE_VALUE_ZERO);
            String maxOccurs = CmsXmlContentDefinition.validateAttribute(e, XSD_ATTRIBUTE_MAX_OCCURS, XSD_ATTRIBUTE_VALUE_UNBOUNDED);
            CmsXmlContentDefinition.validateAttribute(e, XSD_ATTRIBUTE_TYPE, CmsXmlContentDefinition.createTypeName(typeName));
            CmsXmlNestedContentDefinition cd = new CmsXmlNestedContentDefinition(null, typeName, minOccurs, maxOccurs);
            sequence.add(cd);
        }
        return new CmsXmlComplexTypeSequence(name, sequence, hasLanguageAttribute, sequenceType, choiceMaxOccurs);
    }

    private static CmsXmlContentDefinition getCachedContentDefinition(String schemaLocation, EntityResolver resolver) {
        if (resolver instanceof CmsXmlEntityResolver) {
            CmsXmlEntityResolver cmsResolver = (CmsXmlEntityResolver)resolver;
            return cmsResolver.getCachedContentDefinition(schemaLocation);
        }
        return null;
    }

    private static String translateSchema(String schemaLocation) {
        if (OpenCms.getRepositoryManager() != null) {
            return OpenCms.getResourceManager().getXsdTranslator().translateResource(schemaLocation);
        }
        return schemaLocation;
    }

    private static CmsXmlContentDefinition unmarshalInternal(Document document, String schemaLocation, EntityResolver resolver) throws CmsXmlException {
        String className;
        Element handlerElement;
        List<Element> appinfos;
        List<Element> elements;
        Element root = document.getRootElement();
        if (!XSD_NODE_SCHEMA.equals((Object)root.getQName())) {
            throw new CmsXmlException(Messages.get().container("ERR_CD_NO_SCHEMA_NODE_0"));
        }
        List<Element> includes = CmsXmlGenericWrapper.elements(root, XSD_NODE_INCLUDE);
        if (includes.size() < 1) {
            throw new CmsXmlException(Messages.get().container("ERR_CD_ONE_INCLUDE_REQUIRED_0"));
        }
        Element include = includes.get(0);
        String target = CmsXmlContentDefinition.validateAttribute(include, XSD_ATTRIBUTE_SCHEMA_LOCATION, null);
        if (!XSD_INCLUDE_OPENCMS.equals(target)) {
            throw new CmsXmlException(Messages.get().container("ERR_CD_FIRST_INCLUDE_2", XSD_INCLUDE_OPENCMS, target));
        }
        boolean recursive = false;
        HashSet<CmsXmlContentDefinition> nestedDefinitions = new HashSet<CmsXmlContentDefinition>();
        if (includes.size() > 1) {
            for (int i = 1; i < includes.size(); ++i) {
                Element inc = includes.get(i);
                String schemaLoc = CmsXmlContentDefinition.validateAttribute(inc, XSD_ATTRIBUTE_SCHEMA_LOCATION, null);
                if (!schemaLoc.equals(schemaLocation)) {
                    InputSource source = null;
                    try {
                        source = resolver.resolveEntity(null, schemaLoc);
                    }
                    catch (Exception e) {
                        throw new CmsXmlException(Messages.get().container("ERR_CD_BAD_INCLUDE_1", schemaLoc));
                    }
                    CmsXmlContentDefinition xmlContentDefinition = CmsXmlContentDefinition.unmarshal(source, schemaLoc, resolver);
                    nestedDefinitions.add(xmlContentDefinition);
                    continue;
                }
                recursive = true;
            }
        }
        if ((elements = CmsXmlGenericWrapper.elements(root, XSD_NODE_ELEMENT)).size() != 1) {
            throw new CmsXmlException(Messages.get().container("ERR_CD_ROOT_ELEMENT_COUNT_1", XSD_INCLUDE_OPENCMS, new Integer(elements.size())));
        }
        Element main = elements.get(0);
        String name = CmsXmlContentDefinition.validateAttribute(main, XSD_ATTRIBUTE_NAME, null);
        List<Element> complexTypes = CmsXmlGenericWrapper.elements(root, XSD_NODE_COMPLEXTYPE);
        if (complexTypes.size() != 2) {
            throw new CmsXmlException(Messages.get().container("ERR_CD_COMPLEX_TYPE_COUNT_1", new Integer(complexTypes.size())));
        }
        CmsXmlComplexTypeSequence outerSequence = CmsXmlContentDefinition.validateComplexTypeSequence(complexTypes.get(0), nestedDefinitions);
        CmsXmlNestedContentDefinition outer = (CmsXmlNestedContentDefinition)outerSequence.getSequence().get(0);
        String outerTypeName = CmsXmlContentDefinition.createTypeName(name);
        String innerTypeName = CmsXmlContentDefinition.createTypeName(outer.getName());
        CmsXmlContentDefinition.validateAttribute(complexTypes.get(0), XSD_ATTRIBUTE_NAME, outerTypeName);
        CmsXmlContentDefinition.validateAttribute(complexTypes.get(1), XSD_ATTRIBUTE_NAME, innerTypeName);
        CmsXmlContentDefinition.validateAttribute(main, XSD_ATTRIBUTE_TYPE, outerTypeName);
        CmsXmlContentDefinition result = new CmsXmlContentDefinition(name, null, schemaLocation);
        result.m_includes = nestedDefinitions;
        result.m_schemaDocument = document;
        result.setInnerName(outer.getName());
        if (recursive) {
            nestedDefinitions.add(result);
        }
        CmsXmlComplexTypeSequence innerSequence = CmsXmlContentDefinition.validateComplexTypeSequence(complexTypes.get(1), nestedDefinitions);
        Iterator<I_CmsXmlSchemaType> it = innerSequence.getSequence().iterator();
        while (it.hasNext()) {
            result.addType(it.next());
        }
        result.m_sequenceType = innerSequence.getSequenceType();
        result.m_choiceMaxOccurs = innerSequence.getChoiceMaxOccurs();
        List<Element> annotations = CmsXmlGenericWrapper.elements(root, XSD_NODE_ANNOTATION);
        I_CmsXmlContentHandler contentHandler = null;
        Element appInfoElement = null;
        if (annotations.size() > 0 && (appinfos = CmsXmlGenericWrapper.elements(annotations.get(0), XSD_NODE_APPINFO)).size() > 0 && (handlerElement = (appInfoElement = appinfos.get(0)).element("handler")) != null && (className = handlerElement.attributeValue("class")) != null) {
            contentHandler = OpenCms.getXmlContentTypeManager().getFreshContentHandler(className);
        }
        if (contentHandler == null) {
            contentHandler = OpenCms.getXmlContentTypeManager().getFreshContentHandler(CmsDefaultXmlContentHandler.class.getName());
        }
        contentHandler.initialize(appInfoElement, result);
        result.m_contentHandler = contentHandler;
        result.freeze();
        if (resolver instanceof CmsXmlEntityResolver) {
            ((CmsXmlEntityResolver)resolver).cacheContentDefinition(schemaLocation, result);
        }
        return result;
    }

    public Element addDefaultXml(CmsObject cms, I_CmsXmlDocument document, Element root, Locale locale) {
        Iterator<I_CmsXmlSchemaType> i = this.m_typeSequence.iterator();
        int currentPos = 0;
        List<Element> allElements = CmsXmlGenericWrapper.elements(root);
        while (i.hasNext()) {
            I_CmsXmlSchemaType type = i.next();
            String elementName = type.getName();
            List<Element> elements = CmsXmlGenericWrapper.elements(root, elementName);
            currentPos += elements.size();
            for (int j = elements.size(); j < type.getMinOccurs(); ++j) {
                Element typeElement = type.generateXml(cms, document, root, locale);
                I_CmsXmlContentValue value = type.createValue(document, typeElement, locale);
                String defaultValue = document.getHandler().getDefault(cms, value, locale);
                if (defaultValue != null) {
                    value.setStringValue(cms, defaultValue);
                }
                typeElement.detach();
                allElements.add(currentPos, typeElement);
                ++currentPos;
            }
        }
        return root;
    }

    public void addInclude(CmsXmlContentDefinition nestedSchema) {
        this.m_includes.add(nestedSchema);
    }

    public void addType(I_CmsXmlSchemaType type) throws CmsXmlException {
        CmsXmlContentTypeManager typeManager = OpenCms.getXmlContentTypeManager();
        if (type.isSimpleType() && typeManager.getContentType(type.getTypeName()) == null) {
            throw new CmsXmlException(Messages.get().container("ERR_UNREGISTERED_TYPE_1", type.getTypeName()));
        }
        this.m_typeSequence.add(type);
        this.m_types.put(type.getName(), type);
        type.setContentDefinition(this);
    }

    public Object clone() {
        CmsXmlContentDefinition result = new CmsXmlContentDefinition();
        result.m_innerName = this.m_innerName;
        result.m_schemaLocation = this.m_schemaLocation;
        result.m_typeSequence = this.m_typeSequence;
        result.m_types = this.m_types;
        result.m_contentHandler = this.m_contentHandler;
        result.m_typeName = this.m_typeName;
        result.m_includes = this.m_includes;
        result.m_sequenceType = this.m_sequenceType;
        result.m_choiceMaxOccurs = this.m_choiceMaxOccurs;
        result.m_elementTypes = this.m_elementTypes;
        return result;
    }

    public Element createDefaultXml(CmsObject cms, I_CmsXmlDocument document, Element root, Locale locale) {
        for (I_CmsXmlSchemaType type : this.m_typeSequence) {
            for (int j = 0; j < type.getMinOccurs(); ++j) {
                Element typeElement = type.generateXml(cms, document, root, locale);
                I_CmsXmlContentValue value = type.createValue(document, typeElement, locale);
                String defaultValue = document.getHandler().getDefault(cms, value, locale);
                if (defaultValue == null) continue;
                value.setStringValue(cms, defaultValue);
            }
        }
        return root;
    }

    public Document createDocument(CmsObject cms, I_CmsXmlDocument document, Locale locale) {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement(this.getOuterName());
        root.add(I_CmsXmlSchemaType.XSI_NAMESPACE);
        root.addAttribute(I_CmsXmlSchemaType.XSI_NAMESPACE_ATTRIBUTE_NO_SCHEMA_LOCATION, this.getSchemaLocation());
        this.createLocale(cms, document, root, locale);
        return doc;
    }

    public Element createLocale(CmsObject cms, I_CmsXmlDocument document, Element root, Locale locale) {
        Element element = root.addElement(this.getInnerName());
        element.addAttribute(XSD_ATTRIBUTE_VALUE_LANGUAGE, locale.toString());
        return this.createDefaultXml(cms, document, element, locale);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CmsXmlContentDefinition)) {
            return false;
        }
        CmsXmlContentDefinition other = (CmsXmlContentDefinition)obj;
        if (!this.getInnerName().equals(other.getInnerName())) {
            return false;
        }
        if (!this.getOuterName().equals(other.getOuterName())) {
            return false;
        }
        return this.m_typeSequence.equals(other.m_typeSequence);
    }

    public void freeze() {
        this.m_types = Collections.unmodifiableMap(this.m_types);
        this.m_typeSequence = Collections.unmodifiableList(this.m_typeSequence);
    }

    public int getChoiceMaxOccurs() {
        return this.m_choiceMaxOccurs;
    }

    public I_CmsXmlContentHandler getContentHandler() {
        return this.m_contentHandler;
    }

    public Set<CmsXmlContentDefinition> getIncludes() {
        return this.m_includes;
    }

    public String getInnerName() {
        return this.m_innerName;
    }

    public String getOuterName() {
        return this.m_outerName;
    }

    public Document getSchema() {
        Document result;
        if (this.m_schemaDocument == null) {
            Element mainSequence;
            result = DocumentHelper.createDocument();
            Element root = result.addElement(XSD_NODE_SCHEMA);
            root.addAttribute(XSD_ATTRIBUTE_ELEMENT_FORM_DEFAULT, XSD_ATTRIBUTE_VALUE_QUALIFIED);
            Element include = root.addElement(XSD_NODE_INCLUDE);
            include.addAttribute(XSD_ATTRIBUTE_SCHEMA_LOCATION, XSD_INCLUDE_OPENCMS);
            if (this.m_includes.size() > 0) {
                for (CmsXmlContentDefinition definition : this.m_includes) {
                    root.addElement(XSD_NODE_INCLUDE).addAttribute(XSD_ATTRIBUTE_SCHEMA_LOCATION, definition.m_schemaLocation);
                }
            }
            String outerTypeName = CmsXmlContentDefinition.createTypeName(this.getOuterName());
            String innerTypeName = CmsXmlContentDefinition.createTypeName(this.getInnerName());
            Element content = root.addElement(XSD_NODE_ELEMENT);
            content.addAttribute(XSD_ATTRIBUTE_NAME, this.getOuterName());
            content.addAttribute(XSD_ATTRIBUTE_TYPE, outerTypeName);
            Element list = root.addElement(XSD_NODE_COMPLEXTYPE);
            list.addAttribute(XSD_ATTRIBUTE_NAME, outerTypeName);
            Element listSequence = list.addElement(XSD_NODE_SEQUENCE);
            Element listElement = listSequence.addElement(XSD_NODE_ELEMENT);
            listElement.addAttribute(XSD_ATTRIBUTE_NAME, this.getInnerName());
            listElement.addAttribute(XSD_ATTRIBUTE_TYPE, innerTypeName);
            listElement.addAttribute(XSD_ATTRIBUTE_MIN_OCCURS, XSD_ATTRIBUTE_VALUE_ZERO);
            listElement.addAttribute(XSD_ATTRIBUTE_MAX_OCCURS, XSD_ATTRIBUTE_VALUE_UNBOUNDED);
            Element main = root.addElement(XSD_NODE_COMPLEXTYPE);
            main.addAttribute(XSD_ATTRIBUTE_NAME, innerTypeName);
            if (this.m_sequenceType == SequenceType.SEQUENCE) {
                mainSequence = main.addElement(XSD_NODE_SEQUENCE);
            } else {
                mainSequence = main.addElement(XSD_NODE_CHOICE);
                if (this.getChoiceMaxOccurs() > 1) {
                    mainSequence.addAttribute(XSD_ATTRIBUTE_MAX_OCCURS, String.valueOf(this.getChoiceMaxOccurs()));
                } else {
                    mainSequence.addAttribute(XSD_ATTRIBUTE_MIN_OCCURS, XSD_ATTRIBUTE_VALUE_ZERO);
                    mainSequence.addAttribute(XSD_ATTRIBUTE_MAX_OCCURS, XSD_ATTRIBUTE_VALUE_ONE);
                }
            }
            for (I_CmsXmlSchemaType schemaType : this.m_typeSequence) {
                schemaType.appendXmlSchema(mainSequence);
            }
            Element language = main.addElement(XSD_NODE_ATTRIBUTE);
            language.addAttribute(XSD_ATTRIBUTE_NAME, XSD_ATTRIBUTE_VALUE_LANGUAGE);
            language.addAttribute(XSD_ATTRIBUTE_TYPE, "OpenCmsLocale");
            language.addAttribute(XSD_ATTRIBUTE_USE, XSD_ATTRIBUTE_VALUE_OPTIONAL);
        } else {
            result = (Document)this.m_schemaDocument.clone();
        }
        return result;
    }

    public String getSchemaLocation() {
        return this.m_schemaLocation;
    }

    public I_CmsXmlSchemaType getSchemaType(String elementPath) {
        String path = CmsXmlUtils.removeXpath(elementPath);
        I_CmsXmlSchemaType result = this.m_elementTypes.get(path);
        if (result == null) {
            result = this.getSchemaTypeRecusive(path);
            if (result != null) {
                this.m_elementTypes.put(path, result);
            } else {
                this.m_elementTypes.put(path, NULL_SCHEMA_TYPE);
            }
        } else if (result == NULL_SCHEMA_TYPE) {
            result = null;
        }
        return result;
    }

    public Set<String> getSchemaTypes() {
        return this.m_types.keySet();
    }

    public SequenceType getSequenceType() {
        return this.m_sequenceType;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public List<I_CmsXmlSchemaType> getTypeSequence() {
        return this.m_typeSequence;
    }

    public int hashCode() {
        return this.getInnerName().hashCode();
    }

    protected void setInnerName(String innerName) {
        this.m_innerName = innerName;
        if (this.m_innerName != null) {
            this.m_typeName = CmsXmlContentDefinition.createTypeName(innerName);
        }
    }

    protected void setOuterName(String outerName) {
        this.m_outerName = outerName;
    }

    private I_CmsXmlSchemaType getSchemaTypeRecusive(String elementPath) {
        String path = CmsXmlUtils.getFirstXpathElement(elementPath);
        I_CmsXmlSchemaType type = this.m_types.get(path);
        if (type == null) {
            return null;
        }
        if (type.isSimpleType() || !CmsXmlUtils.isDeepXpath(elementPath)) {
            return type;
        }
        CmsXmlNestedContentDefinition nestedDefinition = (CmsXmlNestedContentDefinition)type;
        path = CmsXmlUtils.removeFirstXpathElement(elementPath);
        return nestedDefinition.getNestedContentDefinition().getSchemaType(path);
    }

    public static enum SequenceType {
        MULTIPLE_CHOICE,
        SEQUENCE,
        SINGLE_CHOICE;

    }
}

