/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsElementView;
import org.opencms.ade.containerpage.shared.CmsContainer;
import org.opencms.ade.galleries.shared.CmsGallerySearchBean;
import org.opencms.ade.sitemap.shared.CmsSitemapData;
import org.opencms.file.CmsObject;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContent;

public final class CmsADESessionCache {
    public static final String SESSION_ATTR_ADE_CACHE = "__OCMS_ADE_CACHE__";
    private static final Log LOG = CmsLog.getLog(CmsADESessionCache.class);
    private static final int RECENT_FORMATTERS_SIZE = 10;
    private Map<String, CmsContainerElementBean> m_containerElements;
    private Map<String, String> m_dynamicValues;
    private CmsUUID m_elementView;
    private boolean m_isEditSmallElements;
    private LastPageBean m_lastPage;
    private CmsGallerySearchBean m_lastPageEditorGallerySearch;
    private Map<String, List<CmsUUID>> m_recentFormatters = new ConcurrentHashMap<String, List<CmsUUID>>();
    private CmsSitemapData.EditorMode m_sitemapEditorMode;
    private Map<String, CmsJspStandardContextBean.TemplateBean> m_templateBeanCache = new HashMap<String, CmsJspStandardContextBean.TemplateBean>();
    private boolean m_toolbarVisible;
    private Map<CmsUUID, CmsXmlContent> m_xmlContents;

    protected CmsADESessionCache(CmsObject cms, HttpServletRequest request) {
        this.m_containerElements = new ConcurrentHashMap<String, CmsContainerElementBean>();
        this.m_xmlContents = new ConcurrentHashMap<CmsUUID, CmsXmlContent>();
        String elementView = null;
        if (request != null) {
            elementView = CmsWorkplace.getWorkplaceSettings(cms, request).getUserSettings().getAdditionalPreference("elementView", false);
        }
        if (elementView == null) {
            this.m_elementView = CmsElementView.DEFAULT_ELEMENT_VIEW.getId();
        } else {
            try {
                this.m_elementView = new CmsUUID(elementView);
            }
            catch (NumberFormatException e) {
                this.m_elementView = CmsElementView.DEFAULT_ELEMENT_VIEW.getId();
                LOG.warn((Object)("Malformed element view id '" + elementView + "'."), (Throwable)e);
            }
        }
        this.m_toolbarVisible = true;
    }

    public static CmsADESessionCache getCache(HttpServletRequest request, CmsObject cms) {
        CmsADESessionCache cache = (CmsADESessionCache)request.getSession().getAttribute(SESSION_ATTR_ADE_CACHE);
        if (cache == null) {
            cache = new CmsADESessionCache(cms, request);
            request.getSession().setAttribute(SESSION_ATTR_ADE_CACHE, (Object)cache);
        }
        return cache;
    }

    public void addRecentFormatter(String resType, CmsUUID formatterId) {
        List<CmsUUID> formatterIds = this.m_recentFormatters.get(resType);
        if (formatterIds == null) {
            formatterIds = new ArrayList<CmsUUID>();
            this.m_recentFormatters.put(resType, formatterIds);
        }
        formatterIds.remove(formatterId);
        if (formatterIds.size() >= 10) {
            formatterIds.remove(9);
        }
        formatterIds.add(0, formatterId);
    }

    public void clearDynamicValues() {
        this.m_dynamicValues = null;
    }

    public void clearLastPage() {
        this.m_lastPage = null;
    }

    public CmsContainerElementBean getCacheContainerElement(String key) {
        return this.m_containerElements.get(key);
    }

    public CmsXmlContent getCacheXmlContent(CmsUUID structureId) {
        return this.m_xmlContents.get(structureId);
    }

    public String getDynamicValue(String attribute) {
        return null == this.m_dynamicValues ? null : this.m_dynamicValues.get(attribute);
    }

    public CmsUUID getElementView() {
        return this.m_elementView;
    }

    public LastPageBean getLastPage() {
        return this.m_lastPage;
    }

    public CmsGallerySearchBean getLastPageEditorGallerySearch() {
        return this.m_lastPageEditorGallerySearch;
    }

    public I_CmsFormatterBean getRecentFormatter(String resType, CmsContainer container, boolean allowNested, CmsADEConfigData config) {
        I_CmsFormatterBean result = null;
        List<CmsUUID> formatterIds = this.m_recentFormatters.get(resType);
        if (formatterIds != null) {
            Map<CmsUUID, I_CmsFormatterBean> availableFormatters = config.getActiveFormatters();
            HashSet<String> types = new HashSet<String>(Arrays.asList(container.getType().trim().split(" *, *")));
            for (CmsUUID id : formatterIds) {
                I_CmsFormatterBean formatter = availableFormatters.get(id);
                if (formatter == null || !CmsFormatterConfiguration.matchFormatter(formatter, types, container.getWidth(), allowNested)) continue;
                result = formatter;
                break;
            }
        }
        return result;
    }

    public CmsSitemapData.EditorMode getSitemapEditorMode() {
        return this.m_sitemapEditorMode;
    }

    public CmsJspStandardContextBean.TemplateBean getTemplateBean(String uri, boolean safe) {
        CmsJspStandardContextBean.TemplateBean templateBean = this.m_templateBeanCache.get(uri);
        if (templateBean != null || !safe) {
            return templateBean;
        }
        return new CmsJspStandardContextBean.TemplateBean("", "");
    }

    public boolean isEditSmallElements() {
        return this.m_isEditSmallElements;
    }

    public boolean isToolbarVisible() {
        return this.m_toolbarVisible;
    }

    public void setCacheContainerElement(String key, CmsContainerElementBean containerElement) {
        this.m_containerElements.put(key, containerElement);
    }

    public void setCacheXmlContent(CmsUUID structureId, CmsXmlContent xmlContent) {
        this.m_xmlContents.put(structureId, xmlContent);
    }

    public void setDynamicValue(String attribute, String value) {
        if (null == this.m_dynamicValues) {
            this.m_dynamicValues = new ConcurrentHashMap<String, String>();
        }
        this.m_dynamicValues.put(attribute, value);
    }

    public void setEditSmallElements(boolean editSmallElements) {
        this.m_isEditSmallElements = editSmallElements;
    }

    public void setElementView(CmsUUID elementView) {
        this.m_elementView = elementView;
    }

    public void setLastPage(CmsObject cms, CmsUUID pageId, CmsUUID detailId) {
        this.m_lastPage = new LastPageBean(cms.getRequestContext().getSiteRoot(), pageId, detailId);
    }

    public void setLastPageEditorGallerySearch(CmsGallerySearchBean searchObj) {
        this.m_lastPageEditorGallerySearch = searchObj;
    }

    public void setSitemapEditorMode(CmsSitemapData.EditorMode sitemapEditorMode) {
        this.m_sitemapEditorMode = sitemapEditorMode;
    }

    public void setTemplateBean(String uri, CmsJspStandardContextBean.TemplateBean templateBean) {
        this.m_templateBeanCache.put(uri, templateBean);
    }

    public void setToolbarVisible(boolean toolbarVisible) {
        this.m_toolbarVisible = toolbarVisible;
    }

    public void uncacheXmlContent(CmsUUID structureId) {
        this.m_xmlContents.remove(structureId);
        this.m_dynamicValues = null;
    }

    public static class LastPageBean {
        private CmsUUID m_detailId;
        private CmsUUID m_pageId;
        private String m_siteRoot;

        public LastPageBean(String siteRoot, CmsUUID pageId, CmsUUID detailId) {
            this.m_siteRoot = siteRoot;
            this.m_pageId = pageId;
            this.m_detailId = detailId;
        }

        public CmsUUID getDetailId() {
            return this.m_detailId;
        }

        public CmsUUID getPageId() {
            return this.m_pageId;
        }

        public String getSiteRoot() {
            return this.m_siteRoot;
        }
    }
}

