/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import com.google.common.collect.SetMultimap;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;

public abstract class AbstractSchemaContext
implements SchemaContext {
    protected static final Comparator<Module> REVISION_COMPARATOR = (first, second) -> Revision.compare((Optional)second.getRevision(), (Optional)first.getRevision());
    protected static final Comparator<Module> NAME_REVISION_COMPARATOR = (first, second) -> {
        int cmp = first.getName().compareTo(second.getName());
        return cmp != 0 ? cmp : REVISION_COMPARATOR.compare((Module)first, (Module)second);
    };

    protected static final TreeSet<Module> createModuleSet() {
        return new TreeSet<Module>(REVISION_COMPARATOR);
    }

    protected abstract SetMultimap<URI, Module> getNamespaceToModules();

    protected abstract SetMultimap<String, Module> getNameToModules();

    protected abstract Map<QNameModule, Module> getModuleMap();

    public Set<DataSchemaNode> getDataDefinitions() {
        HashSet<DataSchemaNode> dataDefs = new HashSet<DataSchemaNode>();
        for (Module m : this.getModules()) {
            dataDefs.addAll(m.getChildNodes());
        }
        return dataDefs;
    }

    public Set<NotificationDefinition> getNotifications() {
        HashSet<NotificationDefinition> notifications = new HashSet<NotificationDefinition>();
        for (Module m : this.getModules()) {
            notifications.addAll(m.getNotifications());
        }
        return notifications;
    }

    public Set<RpcDefinition> getOperations() {
        HashSet<RpcDefinition> rpcs = new HashSet<RpcDefinition>();
        for (Module m : this.getModules()) {
            rpcs.addAll(m.getRpcs());
        }
        return rpcs;
    }

    public Set<ExtensionDefinition> getExtensions() {
        HashSet<ExtensionDefinition> extensions = new HashSet<ExtensionDefinition>();
        for (Module m : this.getModules()) {
            extensions.addAll(m.getExtensionSchemaNodes());
        }
        return extensions;
    }

    public Optional<Module> findModule(String name, Optional<Revision> revision) {
        for (Module module : this.getNameToModules().get((Object)name)) {
            if (!revision.equals(module.getRevision())) continue;
            return Optional.of(module);
        }
        return Optional.empty();
    }

    public Optional<Module> findModule(QNameModule qnameModule) {
        return Optional.ofNullable(this.getModuleMap().get(qnameModule));
    }

    public Set<Module> findModules(URI namespace) {
        return this.getNamespaceToModules().get((Object)namespace);
    }

    public Set<Module> findModules(String name) {
        return this.getNameToModules().get((Object)name);
    }

    @Deprecated
    public boolean isAugmenting() {
        return false;
    }

    @Deprecated
    public boolean isAddedByUses() {
        return false;
    }

    public boolean isConfiguration() {
        return false;
    }

    @Nonnull
    public QName getQName() {
        return SchemaContext.NAME;
    }

    @Nonnull
    public SchemaPath getPath() {
        return SchemaPath.ROOT;
    }

    @Nonnull
    public Status getStatus() {
        return Status.CURRENT;
    }

    @Nonnull
    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        ArrayList result = new ArrayList();
        for (Module module : this.getModules()) {
            result.addAll(module.getUnknownSchemaNodes());
        }
        return Collections.unmodifiableList(result);
    }

    public Set<TypeDefinition<?>> getTypeDefinitions() {
        LinkedHashSet result = new LinkedHashSet();
        for (Module module : this.getModules()) {
            result.addAll(module.getTypeDefinitions());
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<DataSchemaNode> getChildNodes() {
        LinkedHashSet result = new LinkedHashSet();
        for (Module module : this.getModules()) {
            result.addAll(module.getChildNodes());
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<GroupingDefinition> getGroupings() {
        LinkedHashSet result = new LinkedHashSet();
        for (Module module : this.getModules()) {
            result.addAll(module.getGroupings());
        }
        return Collections.unmodifiableSet(result);
    }

    public Optional<DataSchemaNode> findDataChildByName(QName name) {
        Objects.requireNonNull(name);
        for (Module module : this.getModules()) {
            Optional result = module.findDataChildByName(name);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    public Set<UsesNode> getUses() {
        return Collections.emptySet();
    }

    public boolean isPresenceContainer() {
        return false;
    }

    public Set<AugmentationSchemaNode> getAvailableAugmentations() {
        return Collections.emptySet();
    }
}

