/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;

public final class BaseTypes {
    public static final QName BINARY_QNAME = BaseTypes.constructQName("binary");
    public static final QName BITS_QNAME = BaseTypes.constructQName("bits");
    public static final QName BOOLEAN_QNAME = BaseTypes.constructQName("boolean");
    public static final QName DECIMAL64_QNAME = BaseTypes.constructQName("decimal64");
    public static final QName EMPTY_QNAME = BaseTypes.constructQName("empty");
    public static final QName ENUMERATION_QNAME = BaseTypes.constructQName("enumeration");
    public static final QName IDENTITYREF_QNAME = BaseTypes.constructQName("identityref");
    public static final QName INSTANCE_IDENTIFIER_QNAME = BaseTypes.constructQName("instance-identifier");
    public static final QName INT8_QNAME = BaseTypes.constructQName("int8");
    public static final QName INT16_QNAME = BaseTypes.constructQName("int16");
    public static final QName INT32_QNAME = BaseTypes.constructQName("int32");
    public static final QName INT64_QNAME = BaseTypes.constructQName("int64");
    public static final QName LEAFREF_QNAME = BaseTypes.constructQName("leafref");
    public static final QName STRING_QNAME = BaseTypes.constructQName("string");
    public static final QName UINT8_QNAME = BaseTypes.constructQName("uint8");
    public static final QName UINT16_QNAME = BaseTypes.constructQName("uint16");
    public static final QName UINT32_QNAME = BaseTypes.constructQName("uint32");
    public static final QName UINT64_QNAME = BaseTypes.constructQName("uint64");
    public static final QName UNION_QNAME = BaseTypes.constructQName("union");
    private static final Set<QName> BUILT_IN_TYPES = ImmutableSet.builder().add((Object)BINARY_QNAME).add((Object)BITS_QNAME).add((Object)BOOLEAN_QNAME).add((Object)DECIMAL64_QNAME).add((Object)EMPTY_QNAME).add((Object)ENUMERATION_QNAME).add((Object)IDENTITYREF_QNAME).add((Object)INSTANCE_IDENTIFIER_QNAME).add((Object)INT8_QNAME).add((Object)INT16_QNAME).add((Object)INT32_QNAME).add((Object)INT64_QNAME).add((Object)LEAFREF_QNAME).add((Object)STRING_QNAME).add((Object)UINT8_QNAME).add((Object)UINT16_QNAME).add((Object)UINT32_QNAME).add((Object)UINT64_QNAME).add((Object)UNION_QNAME).build();

    private BaseTypes() {
    }

    public static QName constructQName(String typeName) {
        return QName.create((QNameModule)YangConstants.RFC6020_YANG_MODULE, (String)typeName).intern();
    }

    public static boolean isYangBuildInType(String type) {
        return !Strings.isNullOrEmpty((String)type) && BUILT_IN_TYPES.contains(QName.create((QNameModule)YangConstants.RFC6020_YANG_MODULE, (String)type));
    }

    public static boolean isYangBuildInType(TypeDefinition<?> type) {
        return type != null && BUILT_IN_TYPES.contains(type.getQName());
    }
}

